/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.ListQuery;
import org.apache.geode.redis.internal.executor.list.ListExecutor;

public class LRangeExecutor
extends ListExecutor {
    private final String ERROR_NOT_NUMERIC = "The index provided is not numeric";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<Struct> range;
        int redisStop;
        int redisStart;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the LRANGE command is \"LRANGE key start stop\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] startArray = commandElems.get(2);
        byte[] stopArray = commandElems.get(3);
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Integer, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        int listSize = keyRegion.size() - 2;
        if (listSize == 0) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        try {
            redisStart = Coder.bytesToInt(startArray);
            redisStop = Coder.bytesToInt(stopArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not numeric"));
            return;
        }
        redisStart = this.getBoundedStartIndex(redisStart, listSize);
        redisStop = this.getBoundedEndIndex(redisStop, listSize);
        if (redisStart > redisStop) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        redisStart = Math.min(redisStart, listSize - 1);
        redisStop = Math.min(redisStop, listSize - 1);
        try {
            range = this.getRange(context, key, redisStart, redisStop, keyRegion);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (range == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
        } else {
            command.setResponse(Coder.getBulkStringArrayResponseOfValues(context.getByteBufAllocator(), range));
        }
    }

    private List<Struct> getRange(ExecutionHandlerContext context, ByteArrayWrapper key, int start, int stop, Region r) throws Exception {
        Query query = this.getQuery(key, ListQuery.LRANGE, context);
        Object[] params = new Object[]{stop + 1};
        SelectResults results = (SelectResults)query.execute(params);
        int size = results.size();
        if (results == null || size <= start) {
            return null;
        }
        return results.asList().subList(start, size);
    }
}

