/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class PersistExecutor
extends AbstractExecutor {
    private final int TIMEOUT_REMOVED = 1;
    private final int KEY_NOT_EXIST_OR_NO_TIMEOUT = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PERSIST command is \"PERSIST key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        boolean canceled = context.getRegionProvider().cancelKeyExpiration(key);
        if (canceled) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }
}

