/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxInstanceFactoryImpl;
import org.apache.geode.pdx.internal.json.JSONToPdxMapper;
import org.apache.geode.pdx.internal.json.PdxListHelper;
import org.apache.logging.log4j.Logger;

public class PdxInstanceHelper
implements JSONToPdxMapper {
    private static final Logger logger = LogService.getLogger();
    JSONToPdxMapper m_parent;
    PdxInstanceFactoryImpl m_pdxInstanceFactory;
    PdxInstance m_pdxInstance;
    String m_PdxName;

    private InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    public PdxInstanceHelper(String className, JSONToPdxMapper parent) {
        InternalCache cache = this.getCache();
        if (logger.isTraceEnabled()) {
            logger.trace("ClassName {}", (Object)className);
        }
        this.m_PdxName = className;
        this.m_parent = parent;
        this.m_pdxInstanceFactory = (PdxInstanceFactoryImpl)cache.createPdxInstanceFactory("__GEMFIRE_JSON", false);
    }

    @Override
    public JSONToPdxMapper getParent() {
        return this.m_parent;
    }

    @Override
    public void setPdxFieldName(String name) {
        if (logger.isTraceEnabled()) {
            logger.trace("setPdxClassName : {}", (Object)name);
        }
        this.m_PdxName = name;
    }

    @Override
    public void addStringField(String fieldName, String value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addStringField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value);
    }

    @Override
    public void addByteField(String fieldName, byte value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addByteField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeByte(fieldName, value);
    }

    @Override
    public void addShortField(String fieldName, short value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addShortField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeShort(fieldName, value);
    }

    @Override
    public void addIntField(String fieldName, int value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addIntField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeInt(fieldName, value);
    }

    @Override
    public void addLongField(String fieldName, long value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addLongField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeLong(fieldName, value);
    }

    @Override
    public void addBigDecimalField(String fieldName, BigDecimal value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigDecimalField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value);
    }

    @Override
    public void addBigIntegerField(String fieldName, BigInteger value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigIntegerField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value);
    }

    @Override
    public void addBooleanField(String fieldName, boolean value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBooleanField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeBoolean(fieldName, value);
    }

    @Override
    public void addFloatField(String fieldName, float value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addFloatField fieldName: {}; value: {}", (Object)fieldName, (Object)Float.valueOf(value));
        }
        this.m_pdxInstanceFactory.writeFloat(fieldName, value);
    }

    @Override
    public void addDoubleField(String fieldName, double value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addDoubleField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeDouble(fieldName, value);
    }

    @Override
    public void addNullField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("addNullField fieldName: {}; value: NULL", (Object)fieldName);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, null);
    }

    @Override
    public void addListField(String fieldName, PdxListHelper list) {
        if (logger.isTraceEnabled()) {
            logger.trace("addListField fieldName: {}", (Object)fieldName);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, list.getList());
    }

    @Override
    public void endListField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endListField fieldName: {}", (Object)fieldName);
        }
    }

    @Override
    public void addObjectField(String fieldName, Object member) {
        if (logger.isTraceEnabled()) {
            logger.trace("addObjectField fieldName: {}", (Object)fieldName);
        }
        if (fieldName == null) {
            throw new IllegalStateException("addObjectField:Object should have fieldname");
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, member);
    }

    @Override
    public void endObjectField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endObjectField fieldName: {}", (Object)fieldName);
        }
        this.m_pdxInstance = this.m_pdxInstanceFactory.create();
    }

    @Override
    public PdxInstance getPdxInstance() {
        return this.m_pdxInstance;
    }

    @Override
    public String getPdxFieldName() {
        return this.m_PdxName;
    }
}

