/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.internal.DSCODE;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.geode.pdx.FieldType;
import org.apache.geode.pdx.PdxFieldTypeMismatchException;
import org.apache.geode.pdx.PdxSerializable;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.PdxUnreadFields;
import org.apache.geode.pdx.internal.AutoSerializableManager;
import org.apache.geode.pdx.internal.DefaultPdxField;
import org.apache.geode.pdx.internal.InternalPdxReader;
import org.apache.geode.pdx.internal.PdxField;
import org.apache.geode.pdx.internal.PdxInputStream;
import org.apache.geode.pdx.internal.PdxString;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxUnreadData;
import org.apache.geode.pdx.internal.TrackingPdxReaderImpl;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.pdx.internal.UnreadPdxType;

public class PdxReaderImpl
implements InternalPdxReader,
Serializable {
    private static final long serialVersionUID = -6094553093860427759L;
    private final PdxType blobType;
    private final PdxInputStream dis;
    private transient PdxUnreadData readUnreadFieldsCalled;
    public static final int MAX_UNSIGNED_BYTE = 255;
    public static final int MAX_UNSIGNED_SHORT = 65535;
    public static boolean TESTHOOK_TRACKREADS = false;

    protected PdxReaderImpl(PdxReaderImpl copy) {
        this.blobType = copy.blobType;
        this.dis = new PdxInputStream(copy.dis);
        this.readUnreadFieldsCalled = copy.getReadUnreadFieldsCalled();
    }

    public PdxReaderImpl(PdxType pdxType, DataInput in, int len) throws IOException {
        this(pdxType, PdxReaderImpl.createDis(in, len));
    }

    private static PdxInputStream createDis(DataInput in, int len) throws IOException {
        PdxInputStream bbis;
        boolean isBBIS = in instanceof ByteBufferInputStream;
        if (isBBIS) {
            bbis = new PdxInputStream((ByteBufferInputStream)in, len);
            int bytesSkipped = in.skipBytes(len);
            for (int bytesRemaining = len - bytesSkipped; bytesRemaining > 0; --bytesRemaining) {
                in.readByte();
            }
        } else {
            byte[] bytes = new byte[len];
            in.readFully(bytes);
            bbis = new PdxInputStream(bytes);
        }
        return bbis;
    }

    protected PdxReaderImpl(PdxType pdxType, PdxInputStream bbis) {
        this.blobType = pdxType;
        this.dis = bbis;
    }

    private byte getSizeOfOffset() {
        int size = this.dis.size();
        if (size <= 255) {
            return 1;
        }
        if (size <= 65535) {
            return 2;
        }
        return 4;
    }

    @Override
    public PdxField getPdxField(String fieldName) {
        return this.blobType.getPdxField(fieldName);
    }

    @Override
    public char readChar(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return '\u0000';
        }
        if (ft.getFieldType() != FieldType.CHAR) {
            throw new PdxFieldTypeMismatchException("Expected char field but found field of type " + ft.getTypeIdString());
        }
        return this.readChar(ft);
    }

    @Override
    public char readChar(PdxField ft) {
        return this.dis.readChar(this.getPositionForField(ft));
    }

    @Override
    public char readChar() {
        return this.dis.readChar();
    }

    @Override
    public boolean readBoolean(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return false;
        }
        if (ft.getFieldType() != FieldType.BOOLEAN) {
            throw new PdxFieldTypeMismatchException("Expected boolean field but found field of type " + ft.getTypeIdString());
        }
        return this.readBoolean(ft);
    }

    @Override
    public boolean readBoolean(PdxField ft) {
        return this.dis.readBoolean(this.getPositionForField(ft));
    }

    @Override
    public boolean readBoolean() {
        return this.dis.readBoolean();
    }

    @Override
    public byte readByte(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return 0;
        }
        if (ft.getFieldType() != FieldType.BYTE) {
            throw new PdxFieldTypeMismatchException("Expected byte field but found field of type " + ft.getTypeIdString());
        }
        return this.readByte(ft);
    }

    @Override
    public byte readByte(PdxField ft) {
        return this.dis.readByte(this.getPositionForField(ft));
    }

    @Override
    public byte readByte() {
        return this.dis.readByte();
    }

    @Override
    public short readShort(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return 0;
        }
        if (ft.getFieldType() != FieldType.SHORT) {
            throw new PdxFieldTypeMismatchException("Expected short field but found field of type " + ft.getTypeIdString());
        }
        return this.readShort(ft);
    }

    @Override
    public short readShort(PdxField ft) {
        return this.dis.readShort(this.getPositionForField(ft));
    }

    @Override
    public short readShort() {
        return this.dis.readShort();
    }

    @Override
    public int readInt(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return 0;
        }
        if (ft.getFieldType() != FieldType.INT) {
            throw new PdxFieldTypeMismatchException("Expected int field but found field of type " + ft.getTypeIdString());
        }
        return this.readInt(ft);
    }

    @Override
    public int readInt(PdxField ft) {
        return this.dis.readInt(this.getPositionForField(ft));
    }

    @Override
    public int readInt() {
        return this.dis.readInt();
    }

    @Override
    public long readLong(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return 0L;
        }
        if (ft.getFieldType() != FieldType.LONG) {
            throw new PdxFieldTypeMismatchException("Expected long field but found field of type " + ft.getTypeIdString());
        }
        return this.readLong(ft);
    }

    @Override
    public long readLong(PdxField ft) {
        return this.dis.readLong(this.getPositionForField(ft));
    }

    @Override
    public long readLong() {
        return this.dis.readLong();
    }

    @Override
    public float readFloat(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return 0.0f;
        }
        if (ft.getFieldType() != FieldType.FLOAT) {
            throw new PdxFieldTypeMismatchException("Expected float field but found field of type " + ft.getTypeIdString());
        }
        return this.readFloat(ft);
    }

    @Override
    public float readFloat(PdxField ft) {
        return this.dis.readFloat(this.getPositionForField(ft));
    }

    @Override
    public float readFloat() {
        return this.dis.readFloat();
    }

    @Override
    public double readDouble(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return 0.0;
        }
        if (ft.getFieldType() != FieldType.DOUBLE) {
            throw new PdxFieldTypeMismatchException("Expected double field but found field of type " + ft.getTypeIdString());
        }
        return this.readDouble(ft);
    }

    @Override
    public double readDouble(PdxField ft) {
        return this.dis.readDouble(this.getPositionForField(ft));
    }

    @Override
    public double readDouble() {
        return this.dis.readDouble();
    }

    @Override
    public Date readDate(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.DATE) {
            throw new PdxFieldTypeMismatchException("Expected Date field but found field of type " + ft.getTypeIdString());
        }
        return this.readDate(ft);
    }

    @Override
    public Date readDate(PdxField ft) {
        return this.dis.readDate(this.getPositionForField(ft));
    }

    @Override
    public Date readDate() {
        return this.dis.readDate();
    }

    @Override
    public String readString(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.STRING) {
            throw new PdxFieldTypeMismatchException("Expected String field but found field of type " + ft.getTypeIdString());
        }
        return this.readString(ft);
    }

    @Override
    public String readString(PdxField ft) {
        return this.dis.readString(this.getPositionForField(ft));
    }

    @Override
    public String readString() {
        return this.dis.readString();
    }

    @Override
    public Object readObject(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.OBJECT) {
            throw new PdxFieldTypeMismatchException("Expected Object field but found field of type " + ft.getTypeIdString());
        }
        return this.readObject(ft);
    }

    @Override
    public Object readObject(PdxField ft) {
        if (ft instanceof DefaultPdxField) {
            return null;
        }
        return this.dis.readObject(this.getPositionForField(ft));
    }

    @Override
    public Object readObject() {
        return this.dis.readObject();
    }

    @Override
    public char[] readCharArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.CHAR_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected char[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readCharArray(ft);
    }

    @Override
    public char[] readCharArray(PdxField ft) {
        return this.dis.readCharArray(this.getPositionForField(ft));
    }

    @Override
    public char[] readCharArray() {
        return this.dis.readCharArray();
    }

    @Override
    public boolean[] readBooleanArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.BOOLEAN_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected boolean[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readBooleanArray(ft);
    }

    @Override
    public boolean[] readBooleanArray(PdxField ft) {
        return this.dis.readBooleanArray(this.getPositionForField(ft));
    }

    @Override
    public boolean[] readBooleanArray() {
        return this.dis.readBooleanArray();
    }

    @Override
    public byte[] readByteArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.BYTE_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected byte[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readByteArray(ft);
    }

    @Override
    public byte[] readByteArray(PdxField ft) {
        return this.dis.readByteArray(this.getPositionForField(ft));
    }

    @Override
    public byte[] readByteArray() {
        return this.dis.readByteArray();
    }

    @Override
    public short[] readShortArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.SHORT_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected short[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readShortArray(ft);
    }

    @Override
    public short[] readShortArray(PdxField ft) {
        return this.dis.readShortArray(this.getPositionForField(ft));
    }

    @Override
    public short[] readShortArray() {
        return this.dis.readShortArray();
    }

    @Override
    public int[] readIntArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.INT_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected int[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readIntArray(ft);
    }

    @Override
    public int[] readIntArray(PdxField ft) {
        return this.dis.readIntArray(this.getPositionForField(ft));
    }

    @Override
    public int[] readIntArray() {
        return this.dis.readIntArray();
    }

    @Override
    public long[] readLongArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.LONG_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected long[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readLongArray(ft);
    }

    @Override
    public long[] readLongArray(PdxField ft) {
        return this.dis.readLongArray(this.getPositionForField(ft));
    }

    @Override
    public long[] readLongArray() {
        return this.dis.readLongArray();
    }

    @Override
    public float[] readFloatArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.FLOAT_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected float[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readFloatArray(ft);
    }

    @Override
    public float[] readFloatArray(PdxField ft) {
        return this.dis.readFloatArray(this.getPositionForField(ft));
    }

    @Override
    public float[] readFloatArray() {
        return this.dis.readFloatArray();
    }

    @Override
    public double[] readDoubleArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.DOUBLE_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected double[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readDoubleArray(ft);
    }

    @Override
    public double[] readDoubleArray(PdxField ft) {
        return this.dis.readDoubleArray(this.getPositionForField(ft));
    }

    @Override
    public double[] readDoubleArray() {
        return this.dis.readDoubleArray();
    }

    @Override
    public String[] readStringArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.STRING_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected String[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readStringArray(ft);
    }

    @Override
    public String[] readStringArray(PdxField ft) {
        return this.dis.readStringArray(this.getPositionForField(ft));
    }

    @Override
    public String[] readStringArray() {
        return this.dis.readStringArray();
    }

    @Override
    public Object[] readObjectArray(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.OBJECT_ARRAY) {
            throw new PdxFieldTypeMismatchException("Expected Object[] field but found field of type " + ft.getTypeIdString());
        }
        return this.readObjectArray(ft);
    }

    @Override
    public Object[] readObjectArray(PdxField ft) {
        if (ft instanceof DefaultPdxField) {
            return null;
        }
        return this.dis.readObjectArray(this.getPositionForField(ft));
    }

    @Override
    public Object[] readObjectArray() {
        return this.dis.readObjectArray();
    }

    @Override
    public byte[][] readArrayOfByteArrays(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() != FieldType.ARRAY_OF_BYTE_ARRAYS) {
            throw new PdxFieldTypeMismatchException("Expected byte[][] field but found field of type " + ft.getTypeIdString());
        }
        return this.readArrayOfByteArrays(ft);
    }

    @Override
    public byte[][] readArrayOfByteArrays(PdxField ft) {
        return this.dis.readArrayOfByteArrays(this.getPositionForField(ft));
    }

    @Override
    public byte[][] readArrayOfByteArrays() {
        return this.dis.readArrayOfByteArrays();
    }

    private int getOffset(int idx) {
        int size = this.dis.size();
        if (size <= 255) {
            return this.dis.readByte(size - idx * 1) & 0xFF;
        }
        if (size <= 65535) {
            return this.dis.readShort(size - idx * 2) & 0xFFFF;
        }
        return this.dis.readInt(size - idx * 4);
    }

    private int getPositionForField(PdxField ft) {
        return this.getAbsolutePosition(ft);
    }

    private int getAbsolutePosition(PdxField ft) {
        int pos = 0;
        int idx0 = ft.getRelativeOffset();
        int idx1 = ft.getVlfOffsetIndex();
        if (ft.isVariableLengthType()) {
            pos = idx1 != -1 ? this.getOffset(idx1) : idx0;
        } else if (idx0 >= 0) {
            pos = idx0;
        } else if (idx1 > 0) {
            pos = this.getOffset(idx1) + idx0;
        } else if (idx1 == -1) {
            pos = this.getOffsetToVlfTable() + idx0;
        } else {
            throw new InternalGemFireException("idx0=" + idx0 + " idx1=" + idx1);
        }
        return pos;
    }

    private int getOffsetToVlfTable() {
        return this.dis.size() - this.blobType.getVariableLengthFieldCount() * this.getSizeOfOffset();
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.blobType.getPdxField(fieldName) != null;
    }

    @Override
    public boolean isIdentityField(String fieldName) {
        PdxField field = this.blobType.getPdxField(fieldName);
        return field != null && field.isIdentityField();
    }

    @Override
    public Object readField(String fieldName) {
        PdxField ft = this.blobType.getPdxField(fieldName);
        if (ft == null) {
            return null;
        }
        switch (ft.getFieldType()) {
            case CHAR: {
                return Character.valueOf(this.readChar(ft));
            }
            case BOOLEAN: {
                return this.readBoolean(ft);
            }
            case BYTE: {
                return this.readByte(ft);
            }
            case SHORT: {
                return this.readShort(ft);
            }
            case INT: {
                return this.readInt(ft);
            }
            case LONG: {
                return this.readLong(ft);
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat(ft));
            }
            case DOUBLE: {
                return this.readDouble(ft);
            }
            case DATE: {
                return this.readDate(ft);
            }
            case STRING: {
                return this.readString(ft);
            }
            case OBJECT: {
                return this.readObject(ft);
            }
            case BOOLEAN_ARRAY: {
                return this.readBooleanArray(ft);
            }
            case CHAR_ARRAY: {
                return this.readCharArray(ft);
            }
            case BYTE_ARRAY: {
                return this.readByteArray(ft);
            }
            case SHORT_ARRAY: {
                return this.readShortArray(ft);
            }
            case INT_ARRAY: {
                return this.readIntArray(ft);
            }
            case LONG_ARRAY: {
                return this.readLongArray(ft);
            }
            case FLOAT_ARRAY: {
                return this.readFloatArray(ft);
            }
            case DOUBLE_ARRAY: {
                return this.readDoubleArray(ft);
            }
            case STRING_ARRAY: {
                return this.readStringArray(ft);
            }
            case OBJECT_ARRAY: {
                return this.readObjectArray(ft);
            }
            case ARRAY_OF_BYTE_ARRAYS: {
                return this.readArrayOfByteArrays(ft);
            }
        }
        throw new InternalGemFireException("Unhandled field type " + (Object)((Object)ft.getFieldType()));
    }

    public Object getObject() throws IOException, ClassNotFoundException {
        return this.basicGetObject();
    }

    protected Object basicGetObject() {
        Object result;
        Class<?> pdxClass;
        String pdxClassName = this.getPdxType().getClassName();
        try {
            pdxClass = InternalDataSerializer.getCachedClass(pdxClassName);
        }
        catch (Exception e) {
            PdxSerializationException ex = new PdxSerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_A_CLASS_0.toLocalizedString(pdxClassName), e);
            throw ex;
        }
        AutoSerializableManager.AutoClassInfo ci = this.getPdxType().getAutoInfo(pdxClass);
        if (ci != null) {
            Object obj = ci.newInstance(pdxClass);
            this.orderedDeserialize(obj, ci);
            return obj;
        }
        InternalPdxReader pdxReader = this;
        UnreadPdxType unreadLocalPdxType = null;
        boolean needToTrackReads = TESTHOOK_TRACKREADS;
        GemFireCacheImpl cache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
        TypeRegistry tr = cache.getPdxRegistry();
        if (!cache.getPdxIgnoreUnreadFields()) {
            PdxType localPdxType = tr.getExistingTypeForClass(pdxClass);
            if (localPdxType != null) {
                if (this.getPdxType().getTypeId() != localPdxType.getTypeId() && this.getPdxType().hasExtraFields(localPdxType)) {
                    needToTrackReads = true;
                }
            } else {
                needToTrackReads = true;
            }
        }
        if (needToTrackReads) {
            unreadLocalPdxType = tr.getExistingTypeForClass(pdxClass, this.getPdxType().getTypeId());
            if (unreadLocalPdxType != null) {
                needToTrackReads = false;
            } else {
                pdxReader = new TrackingPdxReaderImpl(this, tr, pdxClass);
            }
        }
        if (PdxSerializable.class.isAssignableFrom(pdxClass)) {
            try {
                result = pdxClass.newInstance();
            }
            catch (Exception e) {
                PdxSerializationException ex = new PdxSerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_A_CLASS_0.toLocalizedString(pdxClassName), e);
                throw ex;
            }
            ((PdxSerializable)result).fromData(pdxReader);
        } else {
            PdxSerializer pdxSerializer = cache.getPdxSerializer();
            if (pdxSerializer != null) {
                result = pdxSerializer.fromData(pdxClass, pdxReader);
                if (result == null) {
                    throw new PdxSerializationException("Could not deserialize pdx because the pdx serializer's fromData returned false for a pdx of class " + pdxClassName);
                }
            } else {
                throw new PdxSerializationException("Could not deserialize pdx because a PdxSerializer does not exist.");
            }
        }
        PdxUnreadData ud = this.getReadUnreadFieldsCalled();
        if (ud != null) {
            if (unreadLocalPdxType != null) {
                if (unreadLocalPdxType.getUnreadFieldIndexes() != null) {
                    ud.initialize(unreadLocalPdxType, this);
                }
            } else if (needToTrackReads) {
                ((TrackingPdxReaderImpl)pdxReader).internalReadUnreadFields(ud);
            }
        } else if (needToTrackReads) {
            ud = ((TrackingPdxReaderImpl)pdxReader).internalReadUnreadFields(new PdxUnreadData());
            if (ud != null && !ud.isEmpty()) {
                tr.putUnreadData(result, ud);
            }
        } else if (unreadLocalPdxType != null && unreadLocalPdxType.getUnreadFieldIndexes() != null) {
            tr.putUnreadData(result, new PdxUnreadData(unreadLocalPdxType, this));
        }
        return result;
    }

    PdxUnreadData getReadUnreadFieldsCalled() {
        return this.readUnreadFieldsCalled;
    }

    void setReadUnreadFieldsCalled(PdxUnreadData v) {
        this.readUnreadFieldsCalled = v;
    }

    @Override
    public PdxType getPdxType() {
        return this.blobType;
    }

    public ByteBufferInputStream.ByteSource getRaw(int fieldIdx) {
        PdxField ft = this.getPdxType().getPdxFieldByIndex(fieldIdx);
        if (ft == null) {
            throw new InternalGemFireException("unknown field " + fieldIdx);
        }
        return this.getRaw(ft);
    }

    protected ByteBufferInputStream.ByteSource getRaw(PdxField ft) {
        if (ft instanceof DefaultPdxField) {
            return ((DefaultPdxField)ft).getDefaultBytes();
        }
        int startOffset = this.getAbsolutePosition(ft);
        int nextFieldIdx = ft.getFieldIndex() + 1;
        int endOffset = nextFieldIdx >= this.getPdxType().getFieldCount() ? this.getOffsetToVlfTable() : this.getAbsolutePosition(this.getPdxType().getPdxFieldByIndex(nextFieldIdx));
        return this.dis.slice(startOffset, endOffset);
    }

    @Override
    public PdxUnreadFields readUnreadFields() {
        PdxUnreadData result = new PdxUnreadData();
        this.setReadUnreadFieldsCalled(result);
        return result;
    }

    protected void basicSendTo(DataOutput out) throws IOException {
        this.dis.sendTo(out);
    }

    protected void basicSendTo(ByteBuffer bb) {
        this.dis.sendTo(bb);
    }

    protected int basicSize() {
        return this.dis.size();
    }

    protected void basicSetBuffer(ByteBuffer bb) {
        this.dis.setBuffer(bb);
    }

    @Override
    public void orderedDeserialize(Object obj, AutoSerializableManager.AutoClassInfo ci) {
        PdxReaderImpl reader = this.prepForOrderedReading();
        for (AutoSerializableManager.PdxFieldWrapper f : ci.getFields()) {
            f.orderedDeserialize(reader, obj);
        }
    }

    private PdxReaderImpl prepForOrderedReading() {
        PdxReaderImpl result = this;
        if (this.dis instanceof PdxInputStream) {
            result = new PdxReaderImpl(this);
        }
        int pos = 0;
        if (result.blobType.getFieldCount() > 0) {
            pos = this.getPositionForField(result.blobType.getFields().get(0));
        }
        result.dis.position(pos);
        return result;
    }

    public Object readRawField(String field) {
        PdxField ft = this.blobType.getPdxField(field);
        if (ft == null) {
            return null;
        }
        if (ft.getFieldType() == FieldType.STRING) {
            return this.readPdxString(ft);
        }
        PdxString pdxString = this.getPdxStringFromObjectField(ft);
        if (pdxString != null) {
            return pdxString;
        }
        return this.readField(field);
    }

    private PdxString getPdxStringFromObjectField(PdxField ft) {
        if (ft.getFieldType() == FieldType.OBJECT) {
            ByteBufferInputStream.ByteSource buffer = this.dis.getBuffer();
            byte[] bytes = null;
            if (!buffer.hasArray()) {
                throw new IllegalStateException();
            }
            bytes = buffer.array();
            int offset = this.getPositionForField(ft) + buffer.arrayOffset();
            if (bytes[offset] == DSCODE.STRING.toByte() || bytes[offset] == DSCODE.STRING_BYTES.toByte() || bytes[offset] == DSCODE.HUGE_STRING.toByte() || bytes[offset] == DSCODE.HUGE_STRING_BYTES.toByte()) {
                return new PdxString(bytes, offset);
            }
        }
        return null;
    }

    public PdxString readPdxString(PdxField ft) {
        ByteBufferInputStream.ByteSource buffer = this.dis.getBuffer();
        byte[] bytes = null;
        if (!buffer.hasArray()) {
            throw new IllegalStateException();
        }
        bytes = buffer.array();
        int offset = this.getPositionForField(ft) + buffer.arrayOffset();
        if (bytes[offset] == DSCODE.NULL.toByte() || bytes[offset] == DSCODE.NULL_STRING.toByte()) {
            return null;
        }
        return new PdxString(bytes, offset);
    }
}

