/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.geode.internal.DSCODE;

public enum FieldType {
    BOOLEAN(true, 1, "boolean", new byte[]{0}, false),
    BYTE(true, 1, "byte", new byte[]{0}, 0),
    CHAR(true, 2, "char", new byte[]{0, 0}, Character.valueOf('\u0000')),
    SHORT(true, 2, "short", new byte[]{0, 0}, 0),
    INT(true, 4, "int", new byte[]{0, 0, 0, 0}, 0),
    LONG(true, 8, "long", new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, 0),
    FLOAT(true, 4, "float", new byte[]{0, 0, 0, 0}, 0),
    DOUBLE(true, 8, "double", new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, 0),
    DATE(true, 8, "Date", new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, null),
    STRING(false, -1, "String", new byte[]{DSCODE.NULL_STRING.toByte()}, null),
    OBJECT(false, -1, "Object", new byte[]{DSCODE.NULL.toByte()}, null),
    BOOLEAN_ARRAY(false, -1, "boolean[]", new byte[]{-1}, null),
    CHAR_ARRAY(false, -1, "char[]", new byte[]{-1}, null),
    BYTE_ARRAY(false, -1, "byte[]", new byte[]{-1}, null),
    SHORT_ARRAY(false, -1, "short[]", new byte[]{-1}, null),
    INT_ARRAY(false, -1, "int[]", new byte[]{-1}, null),
    LONG_ARRAY(false, -1, "long[]", new byte[]{-1}, null),
    FLOAT_ARRAY(false, -1, "float[]", new byte[]{-1}, null),
    DOUBLE_ARRAY(false, -1, "double[]", new byte[]{-1}, null),
    STRING_ARRAY(false, -1, "String[]", new byte[]{-1}, null),
    OBJECT_ARRAY(false, -1, "Object[]", new byte[]{-1}, null),
    ARRAY_OF_BYTE_ARRAYS(false, -1, "byte[][]", new byte[]{-1}, null);

    private final boolean isFixedWidth;
    private final int width;
    private final String name;
    private final ByteBuffer defaultSerializedValue;
    private final Object defaultValue;

    private FieldType(boolean isFixedWidth, int width, String name, byte[] defaultBytes, Object defaultValue) {
        this.isFixedWidth = isFixedWidth;
        this.width = width;
        this.name = name;
        this.defaultSerializedValue = ByteBuffer.wrap(defaultBytes).asReadOnlyBuffer();
        this.defaultValue = defaultValue;
    }

    public boolean isFixedWidth() {
        return this.isFixedWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        return this.name;
    }

    public ByteBuffer getDefaultBytes() {
        return this.defaultSerializedValue;
    }

    public static FieldType get(Class<?> c) {
        if (c.equals(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (c.equals(Byte.TYPE)) {
            return BYTE;
        }
        if (c.equals(Character.TYPE)) {
            return CHAR;
        }
        if (c.equals(Short.TYPE)) {
            return SHORT;
        }
        if (c.equals(Integer.TYPE)) {
            return INT;
        }
        if (c.equals(Long.TYPE)) {
            return LONG;
        }
        if (c.equals(Float.TYPE)) {
            return FLOAT;
        }
        if (c.equals(Double.TYPE)) {
            return DOUBLE;
        }
        if (c.equals(String.class)) {
            return STRING;
        }
        if (c.equals(Date.class)) {
            return DATE;
        }
        if (c.isArray()) {
            if (c.equals(boolean[].class)) {
                return BOOLEAN_ARRAY;
            }
            if (c.equals(byte[].class)) {
                return BYTE_ARRAY;
            }
            if (c.equals(char[].class)) {
                return CHAR_ARRAY;
            }
            if (c.equals(short[].class)) {
                return SHORT_ARRAY;
            }
            if (c.equals(int[].class)) {
                return INT_ARRAY;
            }
            if (c.equals(long[].class)) {
                return LONG_ARRAY;
            }
            if (c.equals(float[].class)) {
                return FLOAT_ARRAY;
            }
            if (c.equals(double[].class)) {
                return DOUBLE_ARRAY;
            }
            if (c.equals(String[].class)) {
                return STRING_ARRAY;
            }
            if (c.equals(byte[][].class)) {
                return ARRAY_OF_BYTE_ARRAYS;
            }
            return OBJECT_ARRAY;
        }
        return OBJECT;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

