/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.geode.GemFireIOException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class DiskStoreUpgrader {
    public static String STACKTRACE_START = "--------------------------";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        boolean errored;
        String stackTraceString;
        block23: {
            String errorString = null;
            stackTraceString = null;
            String diskStoreName = null;
            String diskDirsStr = null;
            String[] diskDirs = null;
            String maxOpLogSize = null;
            long maxOplogSize = -1L;
            if (args.length < 3) {
                throw new IllegalArgumentException("Requires 3 arguments : <diskStoreName> <diskDirs> <maxOpLogSize>");
            }
            Properties prop = new Properties();
            try {
                prop.load(new StringReader(args[0] + GfshParser.LINE_SEPARATOR + args[1] + GfshParser.LINE_SEPARATOR + args[2]));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Requires 3 arguments : <diskStoreName> <diskDirs> <maxOpLogSize>");
            }
            errored = false;
            try {
                diskStoreName = prop.getProperty("name");
                diskDirsStr = prop.getProperty("disk-dirs");
                diskDirs = diskDirsStr.split(",");
                maxOpLogSize = prop.getProperty("max-oplog-size");
                maxOplogSize = Long.valueOf(maxOpLogSize);
                DiskStoreUpgrader.upgrade(diskStoreName, diskDirs, maxOplogSize);
                if (errorString == null) break block23;
            }
            catch (GemFireIOException e) {
                errored = true;
                Throwable cause = e.getCause();
                if (cause instanceof IllegalStateException) {
                    String message = cause.getMessage();
                    errorString = DiskStoreUpgrader.stringMatches(LocalizedStrings.DiskInitFile_THE_INIT_FILE_0_DOES_NOT_EXIST.toLocalizedString("(.*)"), message) ? CliStrings.format("Cannot locate disk store \"{0}\" in directory : \"{1}\"", diskStoreName, StringUtils.arrayToString(diskDirs)) : message;
                } else if (cause instanceof DiskAccessException) {
                    boolean isKnownCause = false;
                    Throwable nestedCause = cause.getCause();
                    if (nestedCause instanceof IOException) {
                        String message = nestedCause.getMessage();
                        if (DiskStoreUpgrader.stringMatches(LocalizedStrings.Oplog_THE_FILE_0_IS_BEING_USED_BY_ANOTHER_PROCESS.toLocalizedString("(.*)"), message)) {
                            errorString = "The disk is currently being used by another process";
                            isKnownCause = true;
                        }
                    }
                    if (!isKnownCause) {
                        errorString = CliStrings.format("Can not access disk store \"{0}\" from  \"{1}\". Check gfsh logs for error.", diskStoreName, StringUtils.arrayToString(diskDirs));
                    }
                } else {
                    errorString = e.getMessage();
                }
                stackTraceString = ExceptionUtils.getStackTrace((Throwable)e);
                if (errorString != null) {
                    System.err.println(errorString);
                }
                if (stackTraceString != null) {
                    System.err.println(STACKTRACE_START);
                    System.err.println(stackTraceString);
                }
                if (!errored) return;
                System.exit(1);
                return;
            }
            catch (IllegalArgumentException e2) {
                errored = true;
                errorString = e2.getMessage();
                stackTraceString = ExceptionUtils.getStackTrace((Throwable)e2);
                if (errorString != null) {
                    System.err.println(errorString);
                }
                if (stackTraceString != null) {
                    System.err.println(STACKTRACE_START);
                    System.err.println(stackTraceString);
                }
                if (!errored) return;
                {
                    catch (Throwable throwable) {
                        if (errorString != null) {
                            System.err.println(errorString);
                        }
                        if (stackTraceString != null) {
                            System.err.println(STACKTRACE_START);
                            System.err.println(stackTraceString);
                        }
                        if (!errored) throw throwable;
                        System.exit(1);
                        throw throwable;
                    }
                }
                System.exit(1);
                return;
            }
            System.err.println(errorString);
        }
        if (stackTraceString != null) {
            System.err.println(STACKTRACE_START);
            System.err.println(stackTraceString);
        }
        if (!errored) return;
        System.exit(1);
        return;
    }

    private static void upgrade(String diskStoreName, String[] diskDirs, long maxOplogSize) {
        File[] dirs = null;
        if (diskDirs != null) {
            dirs = new File[diskDirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
        }
        try {
            DiskStoreImpl.offlineCompact(diskStoreName, dirs, true, maxOplogSize);
        }
        catch (Exception ex) {
            String fieldsMessage = maxOplogSize != -1L ? "max-oplog-size=" + maxOplogSize + "," : "";
            fieldsMessage = fieldsMessage + StringUtils.arrayToString(dirs);
            throw new GemFireIOException(CliStrings.format("Error occurred while upgrading disk store={0} {1}. Reason: {2}", diskStoreName, fieldsMessage, ex.getMessage()), ex);
        }
    }

    private static boolean stringMatches(String str1, String str2) {
        return Pattern.matches(str1, str2);
    }
}

