/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import io.github.classgraph.utils.WhiteBlackList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ClasspathScanLoadHelper {
    private final ScanResult scanResult;

    public ClasspathScanLoadHelper(Collection<String> packagesToScan) {
        this.scanResult = new ClassGraph().whitelistPackages(packagesToScan.toArray(new String[0])).enableClassInfo().enableAnnotationInfo().scan();
    }

    public Set<Class<?>> scanPackagesForClassesImplementing(Class<?> implementedInterface, String ... onlyFromPackages) {
        ClassInfoList classInfoList = this.scanResult.getClassesImplementing(implementedInterface.getName()).filter(ci -> !ci.isAbstract() && !ci.isInterface() && ci.isPublic());
        classInfoList = classInfoList.filter(ci -> Arrays.stream(onlyFromPackages).anyMatch(p -> this.classMatchesPackage(ci.getName(), (String)p)));
        return classInfoList.loadClasses().stream().collect(Collectors.toSet());
    }

    public Set<Class<?>> scanClasspathForAnnotation(Class<?> annotation, String ... onlyFromPackages) {
        ClassInfoList classInfoList = this.scanResult.getClassesWithAnnotation(annotation.getName());
        classInfoList = classInfoList.filter(ci -> Arrays.stream(onlyFromPackages).anyMatch(p -> this.classMatchesPackage(ci.getName(), (String)p)));
        return classInfoList.loadClasses().stream().collect(Collectors.toSet());
    }

    private boolean classMatchesPackage(String className, String packageSpec) {
        if (!packageSpec.contains("*")) {
            return className.startsWith(packageSpec);
        }
        Pattern globPattern = WhiteBlackList.globToPattern((String)packageSpec);
        return globPattern.matcher(className).matches();
    }
}

