/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.CommandRequest;
import org.apache.geode.management.internal.cli.CommandResponse;
import org.apache.geode.management.internal.cli.CommandResponseBuilder;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.remote.CommandExecutor;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.ModelCommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.security.NotAuthorizedException;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.Assert;

public class GfshExecutionStrategy
implements ExecutionStrategy {
    private Class<?> mutex = GfshExecutionStrategy.class;
    private Gfsh shell;
    private LogWrapper logWrapper;

    GfshExecutionStrategy(Gfsh shell) {
        this.shell = shell;
        this.logWrapper = shell.getGfshFileLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ParseResult parseResult) {
        Method method = parseResult.getMethod();
        if (this.isShellOnly(method)) {
            Assert.notNull((Object)parseResult, (String)"Parse result required");
            Class<?> clazz = this.mutex;
            synchronized (clazz) {
                Assert.isTrue((boolean)this.isReadyForCommands(), (String)"Not yet ready for commands");
                Object exeuctionResult = new CommandExecutor().execute((GfshParseResult)parseResult);
                if (exeuctionResult instanceof ResultModel) {
                    return new ModelCommandResult((ResultModel)exeuctionResult);
                }
                return exeuctionResult;
            }
        }
        if (!GfshParseResult.class.isInstance(parseResult)) {
            throw new IllegalStateException("Configuration error!");
        }
        Result result = this.executeOnRemote((GfshParseResult)parseResult);
        return result;
    }

    private boolean isShellOnly(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.shellOnly();
    }

    private String getInterceptor(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null ? cliMetadata.interceptor() : "__NULL__";
    }

    public boolean isReadyForCommands() {
        return true;
    }

    public void terminate() {
        this.shell = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeOnRemote(GfshParseResult parseResult) {
        Path tempFile = null;
        if (!this.shell.isConnectedAndReady()) {
            this.shell.logWarning("Can't execute a remote command without connection. Use 'connect' first to connect.", null);
            this.logWrapper.info("Can't execute a remote command \"" + parseResult.getUserInput() + "\" without connection. Use 'connect' first to connect to GemFire.");
            return null;
        }
        List<File> fileData = null;
        CliAroundInterceptor interceptor = null;
        String interceptorClass = this.getInterceptor(parseResult.getMethod());
        boolean useResultModel = false;
        if (!"__NULL__".equals(interceptorClass)) {
            try {
                interceptor = (CliAroundInterceptor)ClassPathLoader.getLatest().forName(interceptorClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.shell.logWarning("Configuration error", e);
            }
            if (interceptor == null) {
                return ResultBuilder.createBadConfigurationErrorResult("Interceptor Configuration Error");
            }
            Object preExecResult = interceptor.preExecution(parseResult);
            if (preExecResult instanceof ResultModel) {
                useResultModel = true;
                if (((ResultModel)preExecResult).getStatus() != Result.Status.OK) {
                    return new ModelCommandResult((ResultModel)preExecResult);
                }
            } else if (Result.Status.ERROR.equals((Object)((Result)preExecResult).getStatus())) {
                return (Result)preExecResult;
            }
            if (preExecResult instanceof FileResult) {
                FileResult fileResult = (FileResult)preExecResult;
                fileData = fileResult.getFiles();
            }
        }
        Object response = null;
        Map<String, String> env = this.shell.getEnv();
        try {
            response = this.shell.getOperationInvoker().processCommand(new CommandRequest(parseResult, env, fileData));
            if (response == null) {
                CommandResult commandResult = ResultBuilder.createBadResponseErrorResult("Response was null for: " + parseResult.getUserInput());
                return commandResult;
            }
        }
        catch (NotAuthorizedException e) {
            CommandResult commandResult = ResultBuilder.createGemFireUnAuthorizedErrorResult("Unauthorized. Reason : " + e.getMessage());
            return commandResult;
        }
        catch (Exception e) {
            this.shell.logSevere(e.getMessage(), e);
            e.printStackTrace();
            CommandResult commandResult = ResultBuilder.createBadResponseErrorResult("Error occurred while executing \"" + parseResult.getUserInput() + "\" on manager.");
            return commandResult;
        }
        finally {
            env.clear();
        }
        Object commandResult = null;
        if (response instanceof String) {
            try {
                commandResult = ResultModel.fromJson((String)response);
                useResultModel = true;
            }
            catch (Exception ex) {
                String debugInfo;
                CommandResponse commandResponse = CommandResponseBuilder.prepareCommandResponseFromJson((String)response);
                if (commandResponse.isFailedToPersist()) {
                    this.shell.printAsSevere("This change is not persisted in the cluster configuration, either because the cluster configuration service is not running or the command is operating on targeted members.");
                    this.logWrapper.severe("This change is not persisted in the cluster configuration, either because the cluster configuration service is not running or the command is operating on targeted members.");
                }
                if (StringUtils.isNotBlank((String)(debugInfo = commandResponse.getDebugInfo()))) {
                    debugInfo = debugInfo.replaceAll("\n\n\n", "\n");
                    debugInfo = debugInfo.replaceAll("\n\n", "\n");
                    debugInfo = debugInfo.replaceAll("\n", "\n[From Manager : " + commandResponse.getSender() + "]");
                    debugInfo = "[From Manager : " + commandResponse.getSender() + "]" + debugInfo;
                    this.logWrapper.info(debugInfo);
                }
                commandResult = ResultBuilder.fromJson((String)response);
            }
        } else if (response instanceof Path) {
            tempFile = (Path)response;
        }
        if (interceptor != null) {
            try {
                commandResult = useResultModel ? interceptor.postExecution(parseResult, (ResultModel)commandResult, tempFile) : interceptor.postExecution(parseResult, (CommandResult)commandResult, tempFile);
            }
            catch (Exception e) {
                this.logWrapper.severe("error running post interceptor", e);
                commandResult = ResultBuilder.createGemFireErrorResult(e.getMessage());
            }
        }
        if (commandResult == null) {
            commandResult = ResultBuilder.createGemFireErrorResult("Unable to build commandResult using the remote response.");
        }
        CommandResult gfshResult = commandResult instanceof ResultModel ? new ModelCommandResult((ResultModel)commandResult) : (CommandResult)commandResult;
        return gfshResult;
    }
}

