/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.model.AbstractResultModel;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.FileResultModel;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;

public class ResultModel {
    public static final String INFO_SECTION = "info";
    public static final String MEMBER_STATUS_SECTION = "member-status";
    private String header;
    private String footer;
    private Map<String, AbstractResultModel> sections = new LinkedHashMap<String, AbstractResultModel>();
    private Result.Status status = Result.Status.OK;
    private Object configObject;
    private Map<String, FileResultModel> files = new LinkedHashMap<String, FileResultModel>();

    @JsonIgnore
    public Object getConfigObject() {
        return this.configObject;
    }

    public boolean getLegacy() {
        return false;
    }

    public void setLegacy(boolean legacy) {
    }

    public void setConfigObject(Object configObject) {
        this.configObject = configObject;
    }

    @JsonIgnore
    public boolean isSuccessful() {
        return this.status == Result.Status.OK;
    }

    public void setStatus(Result.Status status) {
        if (this.status == Result.Status.ERROR && status != this.status) {
            throw new IllegalStateException("Can't change the error state of the result.");
        }
        this.status = status;
    }

    public Result.Status getStatus() {
        return this.status;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public Map<String, AbstractResultModel> getContent() {
        return this.sections;
    }

    public void setContent(Map<String, AbstractResultModel> content) {
        this.sections = content;
    }

    public Map<String, FileResultModel> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, FileResultModel> files) {
        this.files = files;
    }

    public void addFile(String fileName, String content) {
        FileResultModel fileModel = new FileResultModel(fileName, content);
        this.files.put(fileName, fileModel);
    }

    public void addFile(File file, int fileType) {
        this.files.put(file.getName(), new FileResultModel(file, fileType));
    }

    public InfoResultModel addInfo() {
        return this.addInfo(INFO_SECTION);
    }

    public InfoResultModel addInfo(String namedSection) {
        AbstractResultModel model = this.sections.get(namedSection);
        if (model != null) {
            if (model instanceof InfoResultModel) {
                return (InfoResultModel)model;
            }
            throw new IllegalStateException(String.format("Section requested is %s, not InfoResultModel", model.getClass().getSimpleName()));
        }
        InfoResultModel section = new InfoResultModel();
        this.sections.put(namedSection, section);
        return section;
    }

    @JsonIgnore
    public List<InfoResultModel> getInfoSections() {
        return this.sections.values().stream().filter(InfoResultModel.class::isInstance).map(InfoResultModel.class::cast).collect(Collectors.toList());
    }

    public TabularResultModel addTable(String namedSection) {
        AbstractResultModel model = this.sections.get(namedSection);
        if (model != null) {
            if (model instanceof TabularResultModel) {
                return (TabularResultModel)model;
            }
            throw new IllegalStateException(String.format("Section requested is %s, not TabularResultModel", model.getClass().getSimpleName()));
        }
        TabularResultModel section = new TabularResultModel();
        this.sections.put(namedSection, section);
        return section;
    }

    public TabularResultModel addTableAndSetStatus(String namedSection, List<CliFunctionResult> functionResults, boolean ignoreIgnorable, boolean ignorePartialFailure) {
        AbstractResultModel model = this.sections.get(namedSection);
        if (model != null) {
            throw new IllegalStateException("Section already exists. Can't overwrite it with this new content.");
        }
        TabularResultModel section = this.addTable(namedSection);
        boolean atLeastOneSuccess = false;
        boolean atLeastOneFailure = false;
        section.setColumnHeader("Member", "Status", "Message");
        for (CliFunctionResult functionResult : functionResults) {
            if (functionResult == null) continue;
            section.addRow(functionResult.getMemberIdOrName(), functionResult.getStatus(ignoreIgnorable), functionResult.getStatusMessage());
            if (functionResult.isSuccessful()) {
                atLeastOneSuccess = true;
                continue;
            }
            if (functionResult.isIgnorableFailure() && ignoreIgnorable) {
                atLeastOneSuccess = true;
                continue;
            }
            if (functionResult.isIgnorableFailure() && !ignoreIgnorable) {
                atLeastOneFailure = true;
                continue;
            }
            if (functionResult.isSuccessful()) continue;
            atLeastOneFailure = true;
        }
        if (ignorePartialFailure) {
            this.setStatus(atLeastOneSuccess ? Result.Status.OK : Result.Status.ERROR);
        } else {
            this.setStatus(atLeastOneFailure ? Result.Status.ERROR : Result.Status.OK);
        }
        return section;
    }

    @JsonIgnore
    public List<TabularResultModel> getTableSections() {
        return this.sections.values().stream().filter(TabularResultModel.class::isInstance).map(TabularResultModel.class::cast).collect(Collectors.toList());
    }

    public TabularResultModel getTableSection(String name) {
        return (TabularResultModel)this.getSection(name);
    }

    public InfoResultModel getInfoSection(String name) {
        return (InfoResultModel)this.getSection(name);
    }

    public AbstractResultModel getSection(String name) {
        return this.sections.get(name);
    }

    public DataResultModel addData(String namedSection) {
        AbstractResultModel model = this.sections.get(namedSection);
        if (model != null) {
            if (model instanceof DataResultModel) {
                return (DataResultModel)model;
            }
            throw new IllegalStateException(String.format("Section requested is %s, not DataResultModel", model.getClass().getSimpleName()));
        }
        DataResultModel section = new DataResultModel();
        this.sections.put(namedSection, section);
        return section;
    }

    @JsonIgnore
    public List<DataResultModel> getDataSections() {
        return this.sections.values().stream().filter(DataResultModel.class::isInstance).map(DataResultModel.class::cast).collect(Collectors.toList());
    }

    public DataResultModel getDataSection(String name) {
        return (DataResultModel)this.getSection(name);
    }

    public List<String> getSectionNames() {
        ArrayList<String> sectionNames = new ArrayList<String>();
        this.sections.forEach((k, v) -> sectionNames.add((String)k));
        return sectionNames;
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mapper.writeValue((OutputStream)baos, (Object)this);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return baos.toString();
    }

    public String toString() {
        return this.toJson();
    }

    public static ResultModel fromJson(String json) {
        ResultModel response;
        ObjectMapper mapper = new ObjectMapper();
        try {
            response = (ResultModel)mapper.readValue(json, ResultModel.class);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
        return response;
    }

    public static ResultModel createCommandProcessingError(String message) {
        return ResultModel.createError("Error processing command: " + message);
    }

    public static ResultModel createError(String message) {
        ResultModel result = ResultModel.createInfo(message);
        result.setStatus(Result.Status.ERROR);
        return result;
    }

    public static ResultModel createInfo(String message) {
        ResultModel result = new ResultModel();
        result.addInfo(INFO_SECTION).addLine(message);
        result.setStatus(Result.Status.OK);
        return result;
    }

    public static ResultModel createMemberStatusResult(List<CliFunctionResult> functionResults, boolean ignoreIgnorable, boolean ignorePartialFailure) {
        return ResultModel.createMemberStatusResult(functionResults, null, null, ignoreIgnorable, ignorePartialFailure);
    }

    public static ResultModel createMemberStatusResult(List<CliFunctionResult> functionResults) {
        return ResultModel.createMemberStatusResult(functionResults, null, null, false, true);
    }

    public static ResultModel createMemberStatusResult(List<CliFunctionResult> functionResults, boolean ignoreIgnorable) {
        return ResultModel.createMemberStatusResult(functionResults, null, null, ignoreIgnorable, true);
    }

    public static ResultModel createMemberStatusResult(List<CliFunctionResult> functionResults, String header, String footer, boolean ignoreIgnorable, boolean ignorePartialFailure) {
        ResultModel result = new ResultModel();
        TabularResultModel tabularResultModel = result.addTableAndSetStatus(MEMBER_STATUS_SECTION, functionResults, ignoreIgnorable, ignorePartialFailure);
        tabularResultModel.setHeader(header);
        tabularResultModel.setFooter(footer);
        return result;
    }

    public void saveFileTo(File dir) throws IOException {
        if (this.getFiles().size() == 0 || dir == null) {
            return;
        }
        InfoResultModel info = this.addInfo("fileSave");
        if (!dir.exists() && !dir.mkdirs()) {
            info.addLine(dir.getAbsolutePath() + " can not be created.");
            this.setStatus(Result.Status.ERROR);
            return;
        }
        if (!dir.isDirectory()) {
            info.addLine(dir.getAbsolutePath() + " is not a directory.");
            this.setStatus(Result.Status.ERROR);
            return;
        }
        if (!dir.canWrite()) {
            info.addLine("Can not write to " + dir.getAbsolutePath());
            this.setStatus(Result.Status.ERROR);
            return;
        }
        for (FileResultModel fileResult : this.files.values()) {
            info.addLine(fileResult.saveFile(dir));
        }
    }
}

