/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class FileResultModel {
    public static int FILE_TYPE_BINARY = 0;
    public static int FILE_TYPE_TEXT = 1;
    private String filename;
    private int type;
    private byte[] data;
    private int length;

    public FileResultModel() {
    }

    public FileResultModel(String fileName, String content) {
        this.filename = fileName;
        this.data = content.getBytes();
        this.length = this.data.length;
        this.type = FILE_TYPE_TEXT;
    }

    public FileResultModel(File file, int fileType) {
        if (fileType != FILE_TYPE_BINARY && fileType != FILE_TYPE_TEXT) {
            throw new IllegalArgumentException("Unsupported file type is specified.");
        }
        this.filename = file.getName();
        try {
            this.data = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read file: " + file.getAbsolutePath(), e);
        }
        this.length = this.data.length;
        this.type = fileType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String saveFile(File directory) throws IOException {
        String options = "(Y/N)";
        File file = new File(directory, this.filename).getAbsoluteFile();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (file.exists()) {
            String fileExistsMessage = String.format("File with name \"$s\" already exists in \"$s\".", this.filename, directory.getAbsolutePath());
            if (gfsh != null && !gfsh.isQuietMode()) {
                String interaction = gfsh.interact(fileExistsMessage = fileExistsMessage + " Overwrite? " + options + " : ");
                if (!"y".equalsIgnoreCase(interaction.trim())) {
                    return "User aborted. Did not overwrite " + file.getAbsolutePath();
                }
            } else {
                return fileExistsMessage;
            }
        }
        if (this.type == 1) {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(new String(this.data));
            bw.flush();
            fw.flush();
            fw.close();
        } else if (this.type == 0) {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.data);
            fos.flush();
            fos.close();
        }
        return "File saved to " + file.getAbsolutePath();
    }
}

