/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.zip.DataFormatException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public abstract class AbstractResultData
implements ResultData {
    protected GfJsonObject gfJsonObject;
    protected GfJsonObject contentObject;
    private Result.Status status = Result.Status.OK;

    protected AbstractResultData() {
        this.gfJsonObject = new GfJsonObject();
        this.contentObject = new GfJsonObject();
        try {
            this.gfJsonObject.putOpt("content", this.contentObject);
        }
        catch (GfJsonException gfJsonException) {
            // empty catch block
        }
    }

    protected AbstractResultData(GfJsonObject jsonObject) {
        this.gfJsonObject = jsonObject;
        this.contentObject = this.gfJsonObject.getJSONObject("content");
    }

    @Override
    public GfJsonObject getGfJsonObject() {
        return this.gfJsonObject;
    }

    @Override
    public abstract String getType();

    @Override
    public String getHeader() {
        return this.gfJsonObject.getString("header");
    }

    @Override
    public String getFooter() {
        return this.gfJsonObject.getString("footer");
    }

    public AbstractResultData setHeader(String headerText) {
        try {
            this.gfJsonObject.put("header", headerText);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    public AbstractResultData setFooter(String footerText) {
        try {
            this.gfJsonObject.put("footer", footerText);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    private static String addTimeStampBeforeLastDot(String src) {
        String toAdd = String.valueOf(new Time(System.currentTimeMillis()));
        toAdd = "-" + toAdd.replaceAll(":", "_");
        int lastIndexOf = src.lastIndexOf(".");
        if (lastIndexOf != -1) {
            String substr1 = src.substring(0, lastIndexOf);
            String substr2 = src.substring(lastIndexOf);
            src = substr1 + toAdd + substr2;
        } else {
            src = src + toAdd;
        }
        return src;
    }

    public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
        return this.addAsFile(fileName, fileContents.getBytes(), 1, message, addTimeStampToName);
    }

    public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
        if (addTimeStampToName) {
            fileName = AbstractResultData.addTimeStampBeforeLastDot(fileName);
        }
        return this.addAsFile(fileName, data, fileType, message);
    }

    private ResultData addAsFile(String fileName, byte[] data, int fileType, String message) {
        if (fileType != 0 && fileType != 1) {
            throw new IllegalArgumentException("Unsupported file type is specified.");
        }
        GfJsonObject sectionData = new GfJsonObject();
        try {
            GfJsonArray fileDataArray = this.contentObject.getJSONArray("__bytes__");
            if (fileDataArray == null) {
                fileDataArray = new GfJsonArray();
                this.contentObject.put("__bytes__", fileDataArray);
            }
            fileDataArray.put(sectionData);
            sectionData.put("fileName", fileName);
            sectionData.put("fileType", fileType);
            sectionData.put("fileMessage", message);
            CliUtil.DeflaterInflaterData deflaterInflaterData = CliUtil.compressBytes(data);
            sectionData.put("fileData", Base64.getEncoder().encodeToString(deflaterInflaterData.getData()));
            sectionData.put("dataLength", deflaterInflaterData.getDataLength());
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void readFileDataAndDump(GfJsonArray byteDataArray, String directory) throws GfJsonException, DataFormatException, IOException {
        boolean overwriteAllExisting = false;
        int length = byteDataArray.size();
        String options = length > 1 ? "(y/N/a)" : "(y/N)";
        for (int i = 0; i < length; ++i) {
            File parentDirectory;
            String fileMessage;
            String fileName;
            GfJsonObject object = byteDataArray.getJSONObject(i);
            int fileType = object.getInt("fileType");
            if (fileType != 0 && fileType != 1) {
                throw new IllegalArgumentException("Unsupported file type found.");
            }
            GfJsonArray fileNameJsonBytes = object.getJSONArray("fileName");
            if (fileNameJsonBytes != null) {
                byte[] fileNameBytes = GfJsonArray.toByteArray(fileNameJsonBytes);
                fileName = new String(fileNameBytes);
            } else {
                fileName = (String)object.get("fileName");
            }
            GfJsonArray fileMessageJsonBytes = object.getJSONArray("fileMessage");
            if (fileMessageJsonBytes != null) {
                byte[] fileMessageBytes = GfJsonArray.toByteArray(fileMessageJsonBytes);
                fileMessage = new String(fileMessageBytes);
            } else {
                fileMessage = (String)object.get("fileMessage");
            }
            String fileDataString = (String)object.get("fileData");
            int fileDataLength = (Integer)object.get("dataLength");
            byte[] byteArray = Base64.getDecoder().decode(fileDataString);
            byte[] uncompressBytes = CliUtil.uncompressBytes(byteArray, fileDataLength).getData();
            File fileToDumpData = new File(fileName);
            if (!fileToDumpData.isAbsolute()) {
                if (directory == null || directory.isEmpty()) {
                    directory = System.getProperty("user.dir", ".");
                }
                fileToDumpData = new File(directory, fileName);
            }
            if ((parentDirectory = fileToDumpData.getParentFile()) != null) {
                parentDirectory.mkdirs();
            }
            Gfsh gfsh = Gfsh.getCurrentInstance();
            if (fileToDumpData.exists()) {
                String fileExistsMessage = CliStrings.format("File with name \"{0}\" already exists in \"{1}\".", fileName, fileToDumpData.getParent(), options);
                if (gfsh == null || gfsh.isQuietMode() || overwriteAllExisting) throw new IOException(fileExistsMessage);
                String interaction = gfsh.interact(fileExistsMessage = fileExistsMessage + " Overwrite? " + options + " : ");
                if ("a".equalsIgnoreCase(interaction.trim())) {
                    overwriteAllExisting = true;
                } else if (!"y".equalsIgnoreCase(interaction.trim())) {
                    continue;
                }
            } else {
                if (!parentDirectory.exists()) {
                    AbstractResultData.handleCondition(CliStrings.format("Parent directory of \"{0}\" does not exist.", (Object)fileToDumpData.getAbsolutePath()));
                    return;
                }
                if (!parentDirectory.canWrite()) {
                    AbstractResultData.handleCondition(CliStrings.format("Parent directory of \"{0}\" is not writable.", (Object)fileToDumpData.getAbsolutePath()));
                    return;
                }
                if (!parentDirectory.isDirectory()) {
                    AbstractResultData.handleCondition(CliStrings.format("Parent of \"{0}\" is not a directory.", (Object)fileToDumpData.getAbsolutePath()));
                    return;
                }
            }
            if (fileType == 1) {
                FileWriter fw = new FileWriter(fileToDumpData);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(new String(uncompressBytes));
                bw.flush();
                fw.flush();
                fw.close();
            } else if (fileType == 0) {
                FileOutputStream fos = new FileOutputStream(fileToDumpData);
                fos.write(uncompressBytes);
                fos.flush();
                fos.close();
            }
            if (fileMessage == null || fileMessage.isEmpty() || gfsh == null) continue;
            Gfsh.println(MessageFormat.format(fileMessage, fileToDumpData.getAbsolutePath()));
        }
    }

    static void handleCondition(String message) throws IOException {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh == null || gfsh.isQuietMode()) {
            throw new IOException(message);
        }
        gfsh.logWarning(message, null);
    }

    @Override
    public void setStatus(Result.Status status) {
        this.status = status;
    }

    @Override
    public Result.Status getStatus() {
        return this.status;
    }
}

