/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.lang.reflect.Method;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.exceptions.UserErrorException;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class CommandExecutor {
    public static final String RUN_ON_MEMBER_CHANGE_NOT_PERSISTED = "Configuration change is not persisted because the command is executed on specific member.";
    public static final String SERVICE_NOT_RUNNING_CHANGE_NOT_PERSISTED = "Cluster configuration service is not running. Configuration change is not persisted.";
    private Logger logger = LogService.getLogger();

    public Object execute(GfshParseResult parseResult) {
        return this.execute(null, parseResult);
    }

    public Object execute(Object command, GfshParseResult parseResult) {
        try {
            Object result = this.invokeCommand(command, parseResult);
            if (result == null) {
                return ResultModel.createError("Command returned null: " + (Object)((Object)parseResult));
            }
            return result;
        }
        catch (NotAuthorizedException e) {
            this.logger.error("Not authorized to execute \"" + (Object)((Object)parseResult) + "\".", (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentException | IllegalStateException | UserErrorException e) {
            return ResultModel.createError(e.getMessage());
        }
        catch (EntityNotFoundException e) {
            if (e.isStatusOK()) {
                return ResultModel.createInfo("Skipping: " + e.getMessage());
            }
            return ResultModel.createError(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error("Could not execute \"" + (Object)((Object)parseResult) + "\".", (Throwable)e);
            return ResultModel.createError("Error while processing command <" + (Object)((Object)parseResult) + "> Reason : " + e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw t;
        }
    }

    protected Object invokeCommand(Object command, GfshParseResult parseResult) {
        String[] groups;
        if (command == null) {
            command = parseResult.getInstance();
        }
        Object result = ReflectionUtils.invokeMethod((Method)parseResult.getMethod(), (Object)command, (Object[])parseResult.getArguments());
        if (!(command instanceof SingleGfshCommand)) {
            return result;
        }
        SingleGfshCommand gfshCommand = (SingleGfshCommand)command;
        ResultModel resultModel = (ResultModel)result;
        if (resultModel.getStatus() == Result.Status.ERROR) {
            return result;
        }
        InfoResultModel infoResultModel = resultModel.addInfo("info");
        ConfigurationPersistenceService ccService = gfshCommand.getConfigurationPersistenceService();
        if (ccService == null) {
            infoResultModel.addLine(SERVICE_NOT_RUNNING_CHANGE_NOT_PERSISTED);
            return resultModel;
        }
        if (parseResult.getParamValue("member") != null) {
            infoResultModel.addLine(RUN_ON_MEMBER_CHANGE_NOT_PERSISTED);
            return resultModel;
        }
        String groupInput = parseResult.getParamValueAsString("group");
        if (groupInput == null) {
            groupInput = "cluster";
        }
        for (String group : groups = groupInput.split(",")) {
            ccService.updateCacheConfig(group, cc -> {
                try {
                    gfshCommand.updateClusterConfig(group, (CacheConfig)cc, resultModel.getConfigObject());
                    infoResultModel.addLine("Changes to configuration for group '" + group + "' are persisted.");
                }
                catch (Exception e) {
                    String message = "failed to update cluster config for " + group;
                    this.logger.error(message, (Throwable)e);
                    infoResultModel.addLine(message + ". Reason: " + e.getMessage());
                    return null;
                }
                return cc;
            });
        }
        return resultModel;
    }
}

