/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.geode.management.internal.cli.CommandResponseWriter;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.remote.WrapperThreadLocal;

public class CommandExecutionContext {
    private static final ThreadLocal<Map<String, String>> ENV = new ThreadLocal();
    private static final ThreadLocal<Boolean> FROM_SHELL = new ThreadLocal();
    private static final ThreadLocal<List<String>> SHELL_FILEPATH = new ThreadLocal();
    private static final WrapperThreadLocal<CommandResponseWriter> WRITER_WRAPPER = new WrapperThreadLocal<CommandResponseWriter>(){

        @Override
        protected CommandResponseWriter createWrapped() {
            return new CommandResponseWriter();
        }
    };

    public static String getShellEnvProperty(String propertyName, String defaultValue) {
        String propertyValue = null;
        Map<String, String> gfshEnv = ENV.get();
        if (gfshEnv != null) {
            propertyValue = gfshEnv.get(propertyName);
        }
        return propertyValue != null ? propertyValue : defaultValue;
    }

    public static int getShellFetchSize() {
        int fetchSize = 100;
        String fetchSizeStr = CommandExecutionContext.getShellEnvProperty("APP_FETCH_SIZE", null);
        if (fetchSizeStr != null) {
            fetchSize = Integer.valueOf(fetchSizeStr);
        }
        return fetchSize;
    }

    public static String getShellLineSeparator() {
        return CommandExecutionContext.getShellEnvProperty("SYS_OS_LINE_SEPARATOR", GfshParser.LINE_SEPARATOR);
    }

    public static Map<String, String> getShellEnv() {
        Map<String, String> envMap = ENV.get();
        if (envMap != null) {
            return Collections.unmodifiableMap(envMap);
        }
        return Collections.emptyMap();
    }

    public static void setShellEnv(Map<String, String> env) {
        ENV.set(env);
    }

    public static List<String> getFilePathFromShell() {
        return SHELL_FILEPATH.get();
    }

    public static void setFilePathToShell(List<String> data) {
        SHELL_FILEPATH.set(data);
    }

    public static boolean isShellRequest() {
        return FROM_SHELL.get() != null && FROM_SHELL.get() != false;
    }

    public static void setShellRequest() {
        FROM_SHELL.set(true);
    }

    public static boolean isSetWrapperThreadLocal() {
        return WRITER_WRAPPER.isSet();
    }

    public static CommandResponseWriter getCommandResponseWriter() {
        return (CommandResponseWriter)WRITER_WRAPPER.get();
    }

    public static CommandResponseWriter getAndCreateIfAbsentCommandResponseWriter() {
        return WRITER_WRAPPER.getAndCreateIfAbsent();
    }

    public static void clear() {
        Map<String, String> map = ENV.get();
        if (map != null) {
            map.clear();
        }
        ENV.set(null);
        FROM_SHELL.set(false);
        SHELL_FILEPATH.set(null);
        WRITER_WRAPPER.set(null);
    }
}

