/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.pdx.PdxInstance;

public class TypedJson {
    public static int DEFAULT_COLLECTION_ELEMENT_LIMIT = 100;
    public static final Object NULL = GfJsonObject.NULL;
    static final String NONFINITE = "Non-Finite";
    Map<Object, List<Object>> forbidden = new IdentityHashMap<Object, List<Object>>();
    boolean commanate;
    private Map<String, List<Object>> map;
    private int queryCollectionsDepth;

    public TypedJson(String key, Object value, int queryCollectionsDepth) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.map = new LinkedHashMap<String, List<Object>>();
        if (value != null) {
            list.add(value);
        }
        this.map.put(key, list);
        this.queryCollectionsDepth = queryCollectionsDepth;
    }

    public TypedJson(int queryCollectionsDepth) {
        this.map = new LinkedHashMap<String, List<Object>>();
        this.queryCollectionsDepth = queryCollectionsDepth;
    }

    public TypedJson() {
        this.map = new LinkedHashMap<String, List<Object>>();
        this.queryCollectionsDepth = DEFAULT_COLLECTION_ELEMENT_LIMIT;
    }

    public TypedJson(String key, Object value) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.map = new LinkedHashMap<String, List<Object>>();
        if (value != null) {
            list.add(value);
        }
        this.map.put(key, list);
        this.queryCollectionsDepth = DEFAULT_COLLECTION_ELEMENT_LIMIT;
    }

    void bfs(Writer w, Object root) throws IOException {
        if (root == null || TypedJson.isPrimitiveOrWrapper(root.getClass())) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        IdentityHashMap seen = new IdentityHashMap();
        seen.put(root, null);
        queue.addFirst(root);
        while (!queue.isEmpty()) {
            Object r = queue.pollFirst();
            List<Object> childrens = this.getChildrens(w, r);
            for (Object n : childrens) {
                if (n == null || TypedJson.isPrimitiveOrWrapper(n.getClass())) continue;
                if (!seen.containsKey(n)) {
                    queue.addFirst(n);
                    seen.put(n, null);
                    continue;
                }
                List<Object> list = this.forbidden.get(r);
                if (list != null) {
                    list.add(n);
                    this.forbidden.put(r, list);
                    continue;
                }
                ArrayList<Object> newList = new ArrayList<Object>();
                newList.add(n);
                this.forbidden.put(r, newList);
            }
        }
    }

    List<Object> getChildrens(Writer w, Object object) throws IOException {
        if (TypedJson.isSpecialObject(object)) {
            return this.visitSpecialObjects(w, object, false);
        }
        return this.visitChildrens(w, object, false);
    }

    public TypedJson add(String key, Object value) {
        List<Object> list = this.map.get(key);
        if (list != null) {
            list.add(value);
        } else {
            list = new ArrayList<Object>();
            list.add(value);
            this.map.put(key, list);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringWriter w = new StringWriter();
        StringBuffer stringBuffer = w.getBuffer();
        synchronized (stringBuffer) {
            try {
                return this.write(w).toString();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public int length() {
        return this.map.size();
    }

    Writer write(Writer writer) throws GfJsonException {
        try {
            boolean addComma = false;
            int length = this.length();
            Iterator<String> keys = this.map.keySet().iterator();
            writer.write(123);
            if (length == 1) {
                String key = keys.next();
                writer.write(TypedJson.quote(key.toString()));
                writer.write(58);
                this.writeList(writer, this.map.get(key));
            } else if (length != 0) {
                while (keys.hasNext()) {
                    String key = keys.next();
                    if (addComma) {
                        writer.write(44);
                    }
                    writer.write(TypedJson.quote(key.toString()));
                    writer.write(58);
                    this.writeList(writer, this.map.get(key));
                    this.commanate = false;
                    addComma = true;
                }
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new GfJsonException(exception);
        }
    }

    Writer writeList(Writer writer, List<Object> myArrayList) throws GfJsonException {
        try {
            boolean addComma = false;
            int length = myArrayList.size();
            if (length == 0) {
                writer.write(93);
                this.writeValue(writer, null);
                writer.write(93);
            }
            if (length == 1) {
                writer.write(91);
                this.writeValue(writer, myArrayList.get(0));
                writer.write(93);
            } else if (length != 0) {
                writer.write(91);
                for (int i = 0; i < length; ++i) {
                    if (addComma) {
                        writer.write(44);
                    }
                    this.writeValue(writer, myArrayList.get(i));
                    this.commanate = false;
                    addComma = true;
                }
                writer.write(93);
            }
            return writer;
        }
        catch (IOException e) {
            throw new GfJsonException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return TypedJson.quote(string, sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    static boolean shouldVisitChildren(Object object) {
        Class<?> type = object.getClass();
        if (TypedJson.isPrimitiveOrWrapper(type)) {
            return false;
        }
        return !TypedJson.isSpecialObject(object);
    }

    static boolean isPrimitiveOrWrapper(Class<?> klass) {
        return klass.isAssignableFrom(Byte.class) || klass.isAssignableFrom(Byte.TYPE) || klass.isAssignableFrom(Short.class) || klass.isAssignableFrom(Short.TYPE) || klass.isAssignableFrom(Integer.class) || klass.isAssignableFrom(Integer.TYPE) || klass.isAssignableFrom(Long.class) || klass.isAssignableFrom(Long.TYPE) || klass.isAssignableFrom(Float.class) || klass.isAssignableFrom(Float.TYPE) || klass.isAssignableFrom(Double.class) || klass.isAssignableFrom(Double.TYPE) || klass.isAssignableFrom(Boolean.class) || klass.isAssignableFrom(Boolean.TYPE) || klass.isAssignableFrom(String.class) || klass.isAssignableFrom(Character.TYPE) || klass.isAssignableFrom(Character.class) || klass.isAssignableFrom(Date.class) || klass.isAssignableFrom(java.util.Date.class) || klass.isAssignableFrom(BigDecimal.class);
    }

    static boolean isSpecialObject(Object object) {
        Class<?> type = object.getClass();
        if (type.isArray() || type.isEnum()) {
            return true;
        }
        return object instanceof Collection || object instanceof Map || object instanceof PdxInstance || object instanceof Struct || object instanceof Region.Entry;
    }

    void writeVal(Writer w, Object value) throws IOException {
        w.write(123);
        this.addVal(w, value);
        w.write(125);
    }

    void addVal(Writer w, Object object) {
        if (object == null) {
            return;
        }
        if (TypedJson.shouldVisitChildren(object)) {
            this.visitChildrens(w, object, true);
        }
    }

    void writeKeyValue(Writer w, Object key, Object value, Class type) throws IOException {
        if (this.commanate) {
            w.write(",");
        }
        if (value == null || value.equals(null)) {
            w.write(TypedJson.quote(key.toString()));
            w.write(58);
            w.write("null");
            this.commanate = true;
            return;
        }
        Class<?> clazz = value.getClass();
        w.write(TypedJson.quote(key.toString()));
        w.write(58);
        if (type != null) {
            this.writeType(w, type, value);
        }
        if (TypedJson.isPrimitiveOrWrapper(clazz)) {
            this.writePrimitives(w, value);
            this.commanate = true;
        } else if (TypedJson.isSpecialObject(value)) {
            this.commanate = false;
            this.visitSpecialObjects(w, value, true);
            this.commanate = true;
        } else {
            this.commanate = false;
            this.writeVal(w, value);
            this.commanate = true;
        }
        this.endType(w, clazz);
    }

    void writePrimitives(Writer w, Object value) throws IOException {
        if (value instanceof Number) {
            w.write(TypedJson.numberToString((Number)value));
            return;
        }
        if (value instanceof String || value instanceof Character || value instanceof Date || value instanceof java.util.Date) {
            w.write(TypedJson.quote(value.toString()));
            return;
        }
        w.write(value.toString());
    }

    void writeArray(Writer w, Object object) throws IOException {
        if (this.commanate) {
            w.write(",");
        }
        w.write(91);
        int length = Array.getLength(object);
        int elements = 0;
        for (int i = 0; i < length && elements < this.queryCollectionsDepth; ++elements, ++i) {
            Object item = Array.get(object, i);
            if (i != 0) {
                w.write(",");
            }
            if (item != null) {
                Class<?> clazz = item.getClass();
                if (TypedJson.isPrimitiveOrWrapper(clazz)) {
                    this.writePrimitives(w, item);
                } else if (TypedJson.isSpecialObject(item)) {
                    this.visitSpecialObjects(w, item, true);
                } else {
                    this.writeVal(w, item);
                }
            } else {
                w.write("null");
            }
            this.commanate = false;
        }
        w.write(93);
        this.commanate = true;
    }

    List<Object> getArrayChildren(Object object) {
        ArrayList<Object> items = new ArrayList<Object>();
        int length = Array.getLength(object);
        int elements = 0;
        for (int i = 0; i < length && elements < this.queryCollectionsDepth; ++i) {
            Object item = Array.get(object, i);
            items.add(item);
        }
        return items;
    }

    void writeEnum(Writer w, Object object) throws IOException {
        if (this.commanate) {
            w.write(",");
        }
        w.write(TypedJson.quote(object.toString()));
        this.commanate = true;
    }

    void writeTypedJson(Writer w, TypedJson object) throws IOException {
        if (this.commanate) {
            w.write(",");
        }
        w.write(TypedJson.quote(object.toString()));
        this.commanate = true;
    }

    void writeValue(Writer w, Object value) {
        try {
            if (value == null || value.equals(null)) {
                w.write("null");
                return;
            }
            this.bfs(w, value);
            Class<?> rootClazz = value.getClass();
            this.writeType(w, rootClazz, value);
            if (TypedJson.isPrimitiveOrWrapper(rootClazz)) {
                this.writePrimitives(w, value);
            } else if (TypedJson.isSpecialObject(value)) {
                this.visitSpecialObjects(w, value, true);
            } else {
                this.writeVal(w, value);
            }
            this.endType(w, rootClazz);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void startKey(Writer writer, String key) throws IOException {
        if (key != null) {
            writer.write(123);
            writer.write(TypedJson.quote(key.toString()));
            writer.write(58);
        }
    }

    void endKey(Writer writer, String key) throws IOException {
        if (key != null) {
            writer.write(125);
        }
    }

    List<Object> visitSpecialObjects(Writer w, Object object, boolean write) throws IOException {
        ArrayList<Object> elements = new ArrayList<Object>();
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (write) {
                this.writeArray(w, object);
            } else {
                return this.getArrayChildren(object);
            }
        }
        if (clazz.isEnum()) {
            if (write) {
                this.writeEnum(w, object);
            } else {
                elements.add(object);
            }
            return elements;
        }
        if (object instanceof TypedJson) {
            this.writeTypedJson(w, (TypedJson)object);
            return elements;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Iterator iter = collection.iterator();
            int i = 0;
            if (write) {
                w.write(123);
            }
            while (iter.hasNext() && i < this.queryCollectionsDepth) {
                Object item = iter.next();
                if (write) {
                    this.writeKeyValue(w, i, item, item != null ? item.getClass() : null);
                } else {
                    elements.add(item);
                }
                ++i;
            }
            if (write) {
                w.write(125);
            }
            return elements;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator it = map.entrySet().iterator();
            int i = 0;
            if (write) {
                w.write(123);
            }
            while (it.hasNext() && i < this.queryCollectionsDepth) {
                Map.Entry e = it.next();
                Object value = e.getValue();
                if (write) {
                    this.writeKeyValue(w, e.getKey(), value, value != null ? value.getClass() : null);
                } else {
                    elements.add(value);
                }
                ++i;
            }
            if (write) {
                w.write(125);
            }
            return elements;
        }
        if (object instanceof PdxInstance) {
            PdxInstance pdxInstance = (PdxInstance)object;
            if (write) {
                w.write(123);
            }
            for (String field : pdxInstance.getFieldNames()) {
                Object fieldValue = pdxInstance.getField(field);
                if (write) {
                    this.writeKeyValue(w, field, fieldValue, fieldValue != null ? fieldValue.getClass() : null);
                    continue;
                }
                elements.add(fieldValue);
            }
            if (write) {
                w.write(125);
            }
            return elements;
        }
        if (object instanceof Struct) {
            StructImpl impl = (StructImpl)object;
            String[] fields = impl.getFieldNames();
            Object[] values = impl.getFieldValues();
            if (write) {
                w.write(123);
            }
            for (int i = 0; i < fields.length; ++i) {
                Object fieldValue = values[i];
                if (write) {
                    this.writeKeyValue(w, fields[i], fieldValue, fieldValue != null ? fieldValue.getClass() : null);
                    continue;
                }
                elements.add(fieldValue);
            }
            if (write) {
                w.write(125);
            }
            return elements;
        }
        if (object instanceof Region.Entry) {
            Region.Entry entry = (Region.Entry)object;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (write) {
                w.write(123);
                this.writeKeyValue(w, key, value, value != null ? value.getClass() : null);
                w.write(125);
            } else {
                elements.add(value);
            }
            return elements;
        }
        return elements;
    }

    void writeType(Writer w, Class clazz, Object value) throws IOException {
        if (clazz != TypedJson.class) {
            w.write(91);
            w.write(TypedJson.quote(this.internalToExternal(clazz, value)));
            w.write(",");
        }
    }

    String internalToExternal(Class clazz, Object value) {
        if (value != null && value instanceof Region.Entry) {
            return Region.Entry.class.getCanonicalName();
        }
        if (value != null && value instanceof PdxInstance) {
            return PdxInstance.class.getCanonicalName();
        }
        return clazz.getCanonicalName();
    }

    void endType(Writer w, Class clazz) throws IOException {
        if (clazz != TypedJson.class) {
            w.write(93);
        }
    }

    List<Object> visitChildrens(Writer w, Object object, boolean write) {
        ArrayList<Object> elements = new ArrayList<Object>();
        Method[] methods = this.getMethods(object);
        for (int i = 0; i < methods.length; ++i) {
            try {
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                method.setAccessible(true);
                Object result = method.invoke(object, (Object[])null);
                if (write) {
                    List<Object> forbiddenList = this.forbidden.get(object);
                    if (forbiddenList != null && forbiddenList.contains(result)) {
                        this.writeKeyValue(w, key, result.getClass().getCanonicalName(), method.getReturnType());
                        continue;
                    }
                    this.writeKeyValue(w, key, result, method.getReturnType());
                    continue;
                }
                elements.add(result);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return elements;
    }

    Method[] getMethods(Object object) {
        Class<?> klass = object.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] decMethods = klass.getDeclaredMethods();
        HashMap<String, Method> decMethodMap = new HashMap<String, Method>();
        for (Method method : decMethods) {
            decMethodMap.put(method.getName(), method);
        }
        if (includeSuperClass) {
            Method[] allMethods = klass.getMethods();
            List<Method> allMethodList = Arrays.asList(allMethods);
            for (Method method : allMethodList) {
                if (decMethodMap.get(method.getName()) != null) continue;
                decMethodMap.put(method.getName(), method);
            }
        }
        Method[] methodArr = new Method[decMethodMap.size()];
        return decMethodMap.values().toArray(methodArr);
    }

    public static String numberToString(Number number) {
        if (number == null) {
            return "";
        }
        if (number != null && (number instanceof Double ? ((Double)number).isInfinite() || ((Double)number).isNaN() : number instanceof Float && (((Float)number).isInfinite() || ((Float)number).isNaN()))) {
            return NONFINITE;
        }
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static Writer quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String hhhh = "000" + Integer.toHexString(c);
                        w.write("\\u" + hhhh.substring(hhhh.length() - 4));
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
        return w;
    }
}

