/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;

public class UserFunctionExecution
implements InternalFunction<Object[]> {
    public static final String ID = UserFunctionExecution.class.getName();
    private static Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext<Object[]> context) {
        Cache cache = context.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        String[] functionArgs = null;
        Object[] args = context.getArguments();
        if (args == null) {
            context.getResultSender().lastResult(new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, "Could not retrieve arguments"));
            return;
        }
        String functionId = (String)args[0];
        String filterString = (String)args[1];
        String resultCollectorName = (String)args[2];
        String argumentsString = (String)args[3];
        String onRegion = (String)args[4];
        Properties credentials = (Properties)args[5];
        SecurityService securityService = ((InternalCache)context.getCache()).getSecurityService();
        boolean loginNeeded = false;
        try {
            Subject subject = securityService.getSubject();
            loginNeeded = subject == null || !subject.isAuthenticated();
        }
        catch (AuthenticationRequiredException e) {
            loginNeeded = true;
        }
        boolean loginSuccessful = false;
        try {
            Function function;
            if (loginNeeded) {
                securityService.login(credentials);
                loginSuccessful = true;
            }
            if (argumentsString != null && argumentsString.length() > 0) {
                functionArgs = argumentsString.split(",");
            }
            Set<Object> filters = new HashSet();
            ResultCollector resultCollectorInstance = null;
            if (resultCollectorName != null && resultCollectorName.length() > 0) {
                resultCollectorInstance = (ResultCollector)ClassPathLoader.getLatest().forName(resultCollectorName).newInstance();
            }
            if (filterString != null && filterString.length() > 0) {
                filters = Arrays.stream(filterString.split(",")).collect(Collectors.toSet());
            }
            if ((function = FunctionService.getFunction(functionId)) == null) {
                context.getResultSender().lastResult(new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format("Function : {0} is not registered on member.", (Object)functionId)));
                return;
            }
            function.getRequiredPermissions(onRegion).forEach(securityService::authorize);
            Execution execution = null;
            if (onRegion != null && onRegion.length() > 0) {
                Region region = cache.getRegion(onRegion);
                if (region == null) {
                    context.getResultSender().lastResult(new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, onRegion + " does not exist"));
                    return;
                }
                execution = FunctionService.onRegion(region);
            } else {
                execution = FunctionService.onMember(member);
            }
            if (execution == null) {
                context.getResultSender().lastResult(new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format("While executing function : {0} on member : {1} one region : {2} error occurred : {3}", functionId, member.getId(), onRegion, "Could not retrieve executor")));
                return;
            }
            if (resultCollectorInstance != null) {
                execution = execution.withCollector(resultCollectorInstance);
            }
            if (functionArgs != null && functionArgs.length > 0) {
                execution = execution.setArguments(functionArgs);
            }
            if (filters.size() > 0) {
                execution = execution.withFilter(filters);
            }
            List results = (List)execution.execute(function.getId()).getResult();
            ArrayList<String> resultMessage = new ArrayList<String>();
            boolean functionSuccess = true;
            if (results != null) {
                for (Object resultObj : results) {
                    if (resultObj == null) continue;
                    if (resultObj instanceof Exception) {
                        resultMessage.add(((Exception)resultObj).getMessage());
                        functionSuccess = false;
                        continue;
                    }
                    resultMessage.add(resultObj.toString());
                }
            }
            context.getResultSender().lastResult(new CliFunctionResult(context.getMemberName(), functionSuccess, ((Object)resultMessage).toString()));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            context.getResultSender().lastResult(new CliFunctionResult(context.getMemberName(), false, CliStrings.format("ResultCollector : {0} not found. Error : {1}", resultCollectorName, e.getMessage())));
        }
        catch (Exception e) {
            logger.error("error executing function " + functionId, (Throwable)e);
            context.getResultSender().lastResult(new CliFunctionResult(context.getMemberName(), false, "Exception: " + e.getMessage()));
        }
        finally {
            if (loginSuccessful) {
                securityService.logout();
            }
        }
    }

    @Override
    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.emptySet();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

