/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class ExportConfigFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ExportConfigFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Cache cache = context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            StringWriter xmlWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(xmlWriter);
            CacheXmlGenerator.generate(cache, printWriter, true, false, false);
            printWriter.close();
            DistributionConfigImpl config = (DistributionConfigImpl)((InternalDistributedSystem)cache.getDistributedSystem()).getConfig();
            StringBuffer propStringBuf = new StringBuffer();
            String lineSeparator = System.getProperty("line.separator");
            for (Map.Entry<String, String> entry : config.getConfigPropsFromSource(ConfigSource.runtime()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry<String, String> entry : config.getConfigPropsFromSource(ConfigSource.api()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry<String, String> entry : config.getConfigPropsDefinedUsingFiles().entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry<String, String> entry : config.getConfigPropsFromSource(ConfigSource.launcher()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(lineSeparator);
            }
            CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])new String[]{xmlWriter.toString(), propStringBuf.toString()});
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not export config {}", (Object)th.getMessage(), (Object)th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

