/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import javax.naming.NamingException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class DestroyJndiBindingFunction
extends CliFunction<String> {
    static final String RESULT_MESSAGE = "Jndi binding \"{0}\" destroyed on \"{1}\"";
    static final String EXCEPTION_RESULT_MESSAGE = "Jndi binding \"{0}\" not found on \"{1}\"";

    @Override
    public CliFunctionResult executeFunction(FunctionContext context) {
        String jndiName = (String)context.getArguments();
        try {
            JNDIInvoker.unMapDatasource(jndiName);
            return new CliFunctionResult(context.getMemberName(), true, CliStrings.format(RESULT_MESSAGE, jndiName, context.getMemberName()));
        }
        catch (NamingException e) {
            return new CliFunctionResult(context.getMemberName(), true, CliStrings.format(EXCEPTION_RESULT_MESSAGE, jndiName, context.getMemberName()));
        }
    }
}

