/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class CreateJndiBindingFunction
extends CliFunction<JndiBindingsType.JndiBinding> {
    static final String RESULT_MESSAGE = "Initiated jndi binding \"{0}\" on \"{1}\". See server logs to verify.";

    @Override
    public CliFunctionResult executeFunction(FunctionContext<JndiBindingsType.JndiBinding> context) {
        ResultSender resultSender = context.getResultSender();
        JndiBindingsType.JndiBinding configuration = context.getArguments();
        JNDIInvoker.mapDatasource(CreateJndiBindingFunction.getParamsAsMap(configuration), CreateJndiBindingFunction.convert(configuration.getConfigProperties()));
        return new CliFunctionResult(context.getMemberName(), true, CliStrings.format(RESULT_MESSAGE, configuration.getJndiName(), context.getMemberName()));
    }

    static Map getParamsAsMap(JndiBindingsType.JndiBinding binding) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("blocking-timeout-seconds", binding.getBlockingTimeoutSeconds());
        params.put("conn-pooled-datasource-class", binding.getConnPooledDatasourceClass());
        params.put("connection-url", binding.getConnectionUrl());
        params.put("idle-timeout-seconds", binding.getIdleTimeoutSeconds());
        params.put("init-pool-size", binding.getInitPoolSize());
        params.put("jdbc-driver-class", binding.getJdbcDriverClass());
        params.put("jndi-name", binding.getJndiName());
        params.put("login-timeout-seconds", binding.getLoginTimeoutSeconds());
        params.put("managed-conn-factory-class", binding.getManagedConnFactoryClass());
        params.put("max-pool-size", binding.getMaxPoolSize());
        params.put("password", binding.getPassword());
        params.put("transaction-type", binding.getTransactionType());
        params.put("type", binding.getType());
        params.put("user-name", binding.getUserName());
        params.put("xa-datasource-class", binding.getXaDatasourceClass());
        return params;
    }

    static List<ConfigProperty> convert(List<JndiBindingsType.JndiBinding.ConfigProperty> properties) {
        return properties.stream().map(p -> {
            ConfigProperty prop = new ConfigProperty();
            prop.setName(p.getName());
            prop.setType(p.getType());
            prop.setValue(p.getValue());
            return prop;
        }).collect(Collectors.toList());
    }
}

