/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class CliFunctionResult
implements Comparable<CliFunctionResult>,
DataSerializableFixedID {
    private String memberIdOrName;
    private Serializable[] serializables = new String[0];
    private Object resultObject;
    private XmlEntity xmlEntity;
    private byte[] byteData = new byte[0];
    private StatusState state;

    @Deprecated
    public CliFunctionResult() {
    }

    @Deprecated
    public CliFunctionResult(String memberIdOrName) {
        this.memberIdOrName = memberIdOrName;
        this.state = StatusState.OK;
    }

    @Deprecated
    public CliFunctionResult(String memberIdOrName, Serializable[] serializables) {
        this.memberIdOrName = memberIdOrName;
        this.serializables = serializables;
        this.state = StatusState.OK;
    }

    @Deprecated
    public CliFunctionResult(String memberIdOrName, XmlEntity xmlEntity) {
        this.memberIdOrName = memberIdOrName;
        this.xmlEntity = xmlEntity;
        this.state = StatusState.OK;
    }

    @Deprecated
    public CliFunctionResult(String memberIdOrName, XmlEntity xmlEntity, Serializable[] serializables) {
        this.memberIdOrName = memberIdOrName;
        this.xmlEntity = xmlEntity;
        this.serializables = serializables;
        this.state = StatusState.OK;
    }

    @Deprecated
    public CliFunctionResult(String memberIdOrName, XmlEntity xmlEntity, String message) {
        this.memberIdOrName = memberIdOrName;
        this.xmlEntity = xmlEntity;
        if (message != null) {
            this.serializables = new String[]{message};
        }
        this.state = StatusState.OK;
    }

    @Deprecated
    public CliFunctionResult(String memberIdOrName, boolean successful, String message) {
        this(memberIdOrName, successful ? StatusState.OK : StatusState.ERROR, message);
    }

    public CliFunctionResult(String memberIdOrName, StatusState state, String message) {
        this.memberIdOrName = memberIdOrName;
        this.state = state;
        if (message != null) {
            this.serializables = new String[]{message};
        }
    }

    public CliFunctionResult(String memberIdOrName, Object resultObject, String message) {
        this.memberIdOrName = memberIdOrName;
        this.resultObject = resultObject;
        if (message != null) {
            this.serializables = new String[]{message};
        }
        this.state = resultObject instanceof Throwable ? StatusState.ERROR : StatusState.OK;
    }

    public CliFunctionResult(String memberIdOrName, Object resultObject) {
        this(memberIdOrName, resultObject, null);
    }

    public String getMemberIdOrName() {
        return this.memberIdOrName;
    }

    @Deprecated
    public String getMessage() {
        if (this.serializables.length == 0 || !(this.serializables[0] instanceof String)) {
            return null;
        }
        return (String)((Object)this.serializables[0]);
    }

    public String getStatus(boolean skipIgnore) {
        if (this.state == StatusState.IGNORABLE) {
            return skipIgnore ? "IGNORED" : "ERROR";
        }
        return this.state.name();
    }

    public String getStatus() {
        return this.getStatus(true);
    }

    public String getStatusMessage() {
        String message = this.getMessage();
        if (this.isSuccessful()) {
            return message;
        }
        String errorMessage = "";
        if (!(message == null || this.resultObject != null && ((Throwable)this.resultObject).getMessage().contains(message))) {
            errorMessage = message;
        }
        if (this.resultObject != null) {
            errorMessage = errorMessage.trim() + " " + ((Throwable)this.resultObject).getClass().getName() + ": " + ((Throwable)this.resultObject).getMessage();
        }
        return errorMessage;
    }

    @Deprecated
    public String getLegacyStatus() {
        String message = this.getMessage();
        if (this.isSuccessful()) {
            return message;
        }
        String errorMessage = "ERROR: ";
        if (!(message == null || this.resultObject != null && ((Throwable)this.resultObject).getMessage().contains(message))) {
            errorMessage = errorMessage + message;
        }
        if (this.resultObject != null) {
            errorMessage = errorMessage.trim() + " " + ((Throwable)this.resultObject).getClass().getName() + ": " + ((Throwable)this.resultObject).getMessage();
        }
        return errorMessage;
    }

    @Deprecated
    public Serializable[] getSerializables() {
        return this.serializables;
    }

    @Deprecated
    public Throwable getThrowable() {
        if (this.isSuccessful()) {
            return null;
        }
        return (Throwable)this.resultObject;
    }

    public Object getResultObject() {
        return this.resultObject;
    }

    @Override
    public int getDSFID() {
        return 152;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.toDataPre_GEODE_1_6_0_0(out);
        DataSerializer.writeEnum(this.state, out);
    }

    public void toDataPre_GEODE_1_6_0_0(DataOutput out) throws IOException {
        DataSerializer.writeString(this.memberIdOrName, out);
        DataSerializer.writePrimitiveBoolean(this.isSuccessful(), out);
        DataSerializer.writeObject(this.xmlEntity, out);
        DataSerializer.writeObjectArray(this.serializables, out);
        DataSerializer.writeObject(this.resultObject, out);
        DataSerializer.writeByteArray(this.byteData, out);
    }

    public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
        DataSerializer.writeString(this.memberIdOrName, out);
        DataSerializer.writeObjectArray(this.serializables, out);
        DataSerializer.writeObject(this.resultObject, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataPre_GEODE_1_6_0_0(in);
        this.state = DataSerializer.readEnum(StatusState.class, in);
    }

    public void fromDataPre_GEODE_1_6_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.memberIdOrName = DataSerializer.readString(in);
        this.state = DataSerializer.readPrimitiveBoolean(in) ? StatusState.OK : StatusState.ERROR;
        this.xmlEntity = (XmlEntity)DataSerializer.readObject(in);
        this.serializables = (Serializable[])DataSerializer.readObjectArray(in);
        this.resultObject = DataSerializer.readObject(in);
        this.byteData = DataSerializer.readByteArray(in);
    }

    public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.memberIdOrName = DataSerializer.readString(in);
        this.resultObject = DataSerializer.readObject(in);
        this.serializables = (Serializable[])DataSerializer.readObjectArray(in);
    }

    public boolean isSuccessful() {
        return this.state == StatusState.OK;
    }

    public boolean isIgnorableFailure() {
        return this.state == StatusState.IGNORABLE;
    }

    @Deprecated
    public XmlEntity getXmlEntity() {
        return this.xmlEntity;
    }

    @Deprecated
    public byte[] getByteData() {
        return this.byteData;
    }

    @Override
    public int compareTo(CliFunctionResult o) {
        if (this.memberIdOrName == null && o.memberIdOrName == null) {
            return 0;
        }
        if (this.memberIdOrName == null && o.memberIdOrName != null) {
            return -1;
        }
        if (this.memberIdOrName != null && o.memberIdOrName == null) {
            return 1;
        }
        return this.getMemberIdOrName().compareTo(o.memberIdOrName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.memberIdOrName == null ? 0 : this.memberIdOrName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CliFunctionResult other = (CliFunctionResult)obj;
        return !(this.memberIdOrName == null ? other.memberIdOrName != null : !this.memberIdOrName.equals(other.memberIdOrName));
    }

    public String toString() {
        return "CliFunctionResult [memberId=" + this.memberIdOrName + ", successful=" + this.isSuccessful() + ", xmlEntity=" + this.xmlEntity + ", serializables=" + Arrays.toString(this.serializables) + ", throwable=" + this.resultObject + ", byteData=" + Arrays.toString(this.byteData) + "]";
    }

    public static List<CliFunctionResult> cleanResults(List<?> results) {
        ArrayList<CliFunctionResult> returnResults = new ArrayList<CliFunctionResult>(results.size());
        for (Object result : results) {
            if (!(result instanceof CliFunctionResult)) continue;
            returnResults.add((CliFunctionResult)result);
        }
        Collections.sort(returnResults);
        return returnResults;
    }

    @Override
    public Version[] getSerializationVersions() {
        return new Version[]{Version.GFE_80};
    }

    public static enum StatusState {
        OK,
        ERROR,
        IGNORABLE;

    }
}

