/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.UndeployFunction;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class UndeployCommand
extends InternalGfshCommand {
    private final UndeployFunction undeployFunction = new UndeployFunction();

    @CliCommand(value={"undeploy"}, help="Undeploy JARs from a member or members.")
    @CliMetaData(relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public Result undeploy(@CliOption(key={"group", "groups"}, help="Group(s) of members from which to undeploy JARs. If not specified, undeploy will occur on all members.", optionContext="geode.converter.member.groups:disable-string-converter") String[] groups, @CliOption(key={"jar", "jars"}, help="JAR(s) to be undeployed.  If not specified, all JARs will be undeployed.") String[] jars) {
        try {
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            Set<DistributedMember> targetMembers = this.findMembers(groups, null);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction(this.undeployFunction, new Object[]{jars}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Un-Deployed JAR", "");
                    tabularData.accumulate("Un-Deployed JAR Location", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                String[] strings = (String[])result.getSerializables();
                for (int i = 0; i < strings.length; i += 2) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Un-Deployed JAR", strings[i]);
                    tabularData.accumulate("Un-Deployed From JAR Location", strings[i + 1]);
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No JAR Files Found");
            }
            CommandResult result = ResultBuilder.buildResult(tabularData);
            if (tabularData.getStatus().equals((Object)Result.Status.OK)) {
                this.persistClusterConfiguration(result, () -> this.getConfigurationPersistenceService().removeJars(jars, groups));
            }
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult("Exception while attempting to un-deploy: " + th.getClass().getName() + ": " + th.getMessage());
        }
    }
}

