/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.partitioned.ColocatedRegionDetails;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.ShowMissingDiskStoresFunction;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class ShowMissingDiskStoreCommand
extends InternalGfshCommand {
    public static final String MISSING_DISK_STORES_SECTION = "missing-disk-stores";
    public static final String MISSING_COLOCATED_REGIONS_SECTION = "missing-colocated-regions";

    @CliCommand(value={"show missing-disk-stores"}, help="Display a summary of the disk stores that are currently missing from a distributed system.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel showMissingDiskStore() {
        Set<DistributedMember> dataMembers = DiskStoreCommandsUtils.getNormalMembers((InternalCache)this.getCache());
        if (dataMembers.isEmpty()) {
            return ResultModel.createInfo("No caching members found.");
        }
        List<?> results = this.getMissingDiskStoresList(dataMembers);
        return this.toMissingDiskStoresTabularResult(results);
    }

    private List<?> getMissingDiskStoresList(Set<DistributedMember> members) {
        Execution membersFunctionExecutor = this.getMembersFunctionExecutor(members);
        if (membersFunctionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)membersFunctionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultCollector = membersFunctionExecutor.execute(new ShowMissingDiskStoresFunction());
        List results = (List)resultCollector.getResult();
        ArrayList distributedPersistentRecoveryDetails = new ArrayList(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            distributedPersistentRecoveryDetails.addAll((Set)result);
        }
        return distributedPersistentRecoveryDetails;
    }

    private ResultModel toMissingDiskStoresTabularResult(List<?> resultDetails) throws ResultDataException {
        ResultModel result = new ResultModel();
        ArrayList<PersistentMemberPattern> missingDiskStores = new ArrayList<PersistentMemberPattern>();
        ArrayList<ColocatedRegionDetails> missingColocatedRegions = new ArrayList<ColocatedRegionDetails>();
        for (Object detail : resultDetails) {
            if (detail instanceof PersistentMemberPattern) {
                missingDiskStores.add((PersistentMemberPattern)detail);
                continue;
            }
            if (detail instanceof ColocatedRegionDetails) {
                missingColocatedRegions.add((ColocatedRegionDetails)detail);
                continue;
            }
            throw new ResultDataException("Unknown type of PersistentRecoveryFailures result");
        }
        boolean hasMissingDiskStores = !missingDiskStores.isEmpty();
        boolean hasMissingColocatedRegions = !missingColocatedRegions.isEmpty();
        TabularResultModel missingDiskStoreSection = result.addTable(MISSING_DISK_STORES_SECTION);
        if (hasMissingDiskStores) {
            missingDiskStoreSection.setHeader("Missing Disk Stores");
            for (PersistentMemberPattern persistentMemberDetails : missingDiskStores) {
                missingDiskStoreSection.accumulate("Disk Store ID", persistentMemberDetails.getUUID().toString());
                missingDiskStoreSection.accumulate("Host", persistentMemberDetails.getHost().toString());
                missingDiskStoreSection.accumulate("Directory", persistentMemberDetails.getDirectory());
            }
        } else {
            missingDiskStoreSection.setHeader("No missing disk store found");
        }
        TabularResultModel missingRegionsSection = result.addTable(MISSING_COLOCATED_REGIONS_SECTION);
        if (hasMissingColocatedRegions) {
            missingRegionsSection.setHeader("Missing Colocated Regions");
            for (ColocatedRegionDetails colocatedRegionDetails : missingColocatedRegions) {
                missingRegionsSection.accumulate("Host", colocatedRegionDetails.getHost());
                missingRegionsSection.accumulate("Distributed Member", colocatedRegionDetails.getMember());
                missingRegionsSection.accumulate("Parent Region", colocatedRegionDetails.getParent());
                missingRegionsSection.accumulate("Missing Colocated Region", colocatedRegionDetails.getChild());
            }
        } else {
            missingRegionsSection.setHeader("No missing colocated region found");
        }
        return result;
    }
}

