/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShCommand
extends InternalGfshCommand {
    @CliCommand(value={"sh"}, help="Allows execution of operating system (OS) commands. Use '&' to return to gfsh prompt immediately. NOTE: Commands which pass output to another shell command are not currently supported.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result sh(@CliOption(key={"", "command"}, mandatory=true, help="The command to execute.") String command, @CliOption(key={"use-console"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Useful on Unix systems for applications which need handle of console. Adds \"</dev/tty >/dev/tty\" to the user specified command.") boolean useConsole) {
        CommandResult result;
        try {
            result = ResultBuilder.buildResult(ShCommand.executeCommand(Gfsh.getCurrentInstance(), command, useConsole));
        }
        catch (IOException | IllegalStateException e) {
            result = ResultBuilder.createUserErrorResult(e.getMessage());
            LogWrapper.getInstance(this.getCache()).warning("Unable to execute command \"" + command + "\". Reason:" + e.getMessage() + ".");
        }
        return result;
    }

    private static InfoResultData executeCommand(Gfsh gfsh, String userCommand, boolean useConsole) throws IOException {
        String lineRead;
        InfoResultData infoResultData = ResultBuilder.createInfoResultData();
        String cmdToExecute = userCommand;
        String cmdExecutor = "/bin/sh";
        String cmdExecutorOpt = "-c";
        if (SystemUtils.isWindows()) {
            cmdExecutor = "cmd";
            cmdExecutorOpt = "/c";
        } else if (useConsole) {
            cmdToExecute = cmdToExecute + " </dev/tty >/dev/tty";
        }
        String[] commandArray = new String[]{cmdExecutor, cmdExecutorOpt, cmdToExecute};
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(commandArray);
        builder.directory();
        builder.redirectErrorStream();
        Process proc = builder.start();
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((lineRead = input.readLine()) != null) {
            infoResultData.addLine(lineRead);
        }
        proc.getOutputStream().close();
        try {
            if (proc.waitFor() != 0) {
                gfsh.logWarning("The command '" + userCommand + "' did not complete successfully", null);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e.getMessage(), e);
        }
        return infoResultData;
    }
}

