/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.functions.GetRegionNamesFunction;
import org.apache.geode.management.internal.configuration.functions.RecreateCacheFunction;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.xml.sax.SAXException;

public class ImportClusterConfigurationCommand
extends InternalGfshCommand {
    public static Logger logger = LogService.getLogger();
    public static final String XML_FILE = "xml-file";
    public static final String ACTION = "action";
    public static final String ACTION_HELP = "What to do with the running servers if any. APPLY would try to apply the configuration to the empty servers. STAGE would leave the running servers alone.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"import cluster-configuration"}, help="Imports configuration into cluster configuration hosted at the locators")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ImportClusterConfigurationCommand$ImportInterceptor", isFileUploaded=true, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel importSharedConfig(@CliOption(key={"group"}, specifiedDefaultValue="cluster", unspecifiedDefaultValue="cluster") String group, @CliOption(key={"xml-file"}) String xmlFile, @CliOption(key={"action"}, help="What to do with the running servers if any. APPLY would try to apply the configuration to the empty servers. STAGE would leave the running servers alone.", unspecifiedDefaultValue="APPLY") Action action, @CliOption(key={"zip-file-name"}, help="The zip file containing the cluster configuration artifacts, which are to be imported") String zip) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        if (!this.isSharedConfigurationRunning()) {
            return ResultModel.createError("Cluster configuration service is not running.");
        }
        InternalConfigurationPersistenceService ccService = this.getConfigurationPersistenceService();
        Set<DistributedMember> servers = this.findMembers(group);
        File file = this.getUploadedFile();
        ResultModel result = new ResultModel();
        InfoResultModel infoSection = result.addInfo("info");
        ccService.lockSharedConfiguration();
        try {
            if (action == Action.APPLY && servers.size() > 0) {
                if (ccService.hasXmlConfiguration()) {
                    ResultModel resultModel = ResultModel.createError("Can not configure servers that are already configured.");
                    return resultModel;
                }
                Set regionsOnServers = servers.stream().map(this::getRegionNamesOnServer).flatMap(Collection::stream).collect(Collectors.toSet());
                if (!regionsOnServers.isEmpty()) {
                    ResultModel resultModel = ResultModel.createError("Can not configure servers with existing regions: " + regionsOnServers.stream().collect(Collectors.joining(",")));
                    return resultModel;
                }
            }
            this.backupTheOldConfig(ccService);
            if (zip != null) {
                Path tempDir = Files.createTempDirectory("config", new FileAttribute[0]);
                ZipUtils.unzip(file.getAbsolutePath(), tempDir.toAbsolutePath().toString());
                ccService.loadSharedConfigurationFromDir(tempDir.toFile());
                FileUtils.deleteQuietly((File)tempDir.toFile());
                infoSection.addLine("Cluster configuration successfully imported.");
            } else {
                Configuration configuration = ccService.getConfiguration(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                }
                configuration.setCacheXmlFile(file);
                ccService.setConfiguration(group, configuration);
                logger.info(configuration.getConfigName() + "xml content: \n" + configuration.getCacheXmlContent());
                infoSection.addLine("Successfully set the '" + group + "' configuration to the content of " + xmlFile);
            }
        }
        finally {
            FileUtils.deleteQuietly((File)file);
            ccService.unlockSharedConfiguration();
        }
        if (servers.size() > 0) {
            if (action == Action.APPLY) {
                List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult(new RecreateCacheFunction(), null, servers);
                TabularResultModel tableSection = result.addTableAndSetStatus("member-status", functionResults, false, true);
                tableSection.setHeader("Configure the servers in '" + group + "' group: ");
            } else {
                infoSection.addLine("Existing servers are not affected with this configuration change.");
            }
        }
        return result;
    }

    void backupTheOldConfig(InternalConfigurationPersistenceService ccService) throws IOException {
        String backupDir = "cluster_config_" + new SimpleDateFormat("yyyyMMddhhmm").format(new Date()) + '.' + System.nanoTime();
        File backDirFile = ccService.getClusterConfigDirPath().getParent().resolve(backupDir).toFile();
        for (Configuration config : ccService.getEntireConfiguration().values()) {
            ccService.writeConfigToFile(config, backDirFile);
        }
    }

    File getUploadedFile() {
        List<String> filePathFromShell = CommandExecutionContext.getFilePathFromShell();
        File file = new File(filePathFromShell.get(0));
        return file;
    }

    Set<DistributedMember> findMembers(String group) {
        Set<DistributedMember> serversInGroup = "cluster".equals(group) ? this.getAllNormalMembers() : this.findMembers(new String[]{group}, null);
        return serversInGroup;
    }

    private Set<String> getRegionNamesOnServer(DistributedMember server) {
        ResultCollector<?, ?> rc = this.executeFunction((Function)new GetRegionNamesFunction(), null, server);
        List results = (List)rc.getResult();
        return (Set)results.get(0);
    }

    public static class ImportInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Object preExecution(GfshParseResult parseResult) {
            String zip = parseResult.getParamValueAsString("zip-file-name");
            String xmlFile = parseResult.getParamValueAsString(ImportClusterConfigurationCommand.XML_FILE);
            String group = parseResult.getParamValueAsString("group");
            if (group != null && group.contains(",")) {
                return ResultModel.createError("Only a single group name is supported.");
            }
            if (zip == null && xmlFile == null) {
                return ResultModel.createError("Either a zip file or a xml file is required.");
            }
            if (zip != null && xmlFile != null) {
                return ResultModel.createError("Zip file and xml File can't both be specified.");
            }
            if (zip != null) {
                if (!group.equals("cluster")) {
                    return ResultModel.createError("zip file can not be imported with a specific group.");
                }
                if (!zip.endsWith(".zip")) {
                    return ResultModel.createError("Invalid file type. The file extension must be .zip");
                }
            }
            if (xmlFile != null && !xmlFile.endsWith(".xml")) {
                return ResultModel.createError("Invalid file type. The file extension must be .xml.");
            }
            String file = zip != null ? zip : xmlFile;
            File importedFile = new File(file).getAbsoluteFile();
            if (!importedFile.exists()) {
                return ResultModel.createError("'" + file + "' not found.");
            }
            String message = "This command will replace the existing cluster configuration, if any, The old configuration will be backed up in the working directory.\n\nContinue? ";
            if (this.readYesNo(message, AbstractCliAroundInterceptor.Response.YES) == AbstractCliAroundInterceptor.Response.NO) {
                return ResultModel.createError("Aborted import of " + file + ".");
            }
            Action action = (Action)((Object)parseResult.getParamValue(ImportClusterConfigurationCommand.ACTION));
            if (action == Action.STAGE && this.readYesNo(message = "The configuration you are trying to import should NOT have any conflict with the configurationof existing running servers if any, otherwise you may not be able to start new servers. \nIt is also expected that you would restart the servers with the old configuration after new servers have come up.\n\nContinue? ", AbstractCliAroundInterceptor.Response.YES) == AbstractCliAroundInterceptor.Response.NO) {
                return ResultModel.createError("Aborted import of " + xmlFile + ".");
            }
            FileResult result = new FileResult();
            result.addFile(importedFile);
            return result;
        }
    }

    public static enum Action {
        APPLY,
        STAGE;

    }
}

