/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.ExportLogsFunction;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.logging.log4j.Logger;

public class ExportLogsInterceptor
extends AbstractCliAroundInterceptor {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result preExecution(GfshParseResult parseResult) {
        LocalDateTime endTime;
        LocalDateTime startTime;
        if (parseResult.getParamValueAsString("group") != null && parseResult.getParamValueAsString("member") != null) {
            return ResultBuilder.createUserErrorResult("Can't specify both group and member.");
        }
        String logLevel = parseResult.getParamValueAsString("log-level");
        if (StringUtils.isBlank((String)logLevel) || LogLevel.getLevel(logLevel) == null) {
            return ResultBuilder.createUserErrorResult("Invalid log level: " + logLevel);
        }
        String start = parseResult.getParamValueAsString("start-time");
        String end = parseResult.getParamValueAsString("end-time");
        if (start != null && end != null && (startTime = ExportLogsFunction.parseTime(start)).isAfter(endTime = ExportLogsFunction.parseTime(end))) {
            return ResultBuilder.createUserErrorResult("start-time has to be earlier than end-time.");
        }
        boolean onlyLogs = (Boolean)parseResult.getParamValue("logs-only");
        boolean onlyStats = (Boolean)parseResult.getParamValue("stats-only");
        if (onlyLogs && onlyStats) {
            return ResultBuilder.createUserErrorResult("logs-only and stats-only can't both be true");
        }
        return ResultBuilder.createInfoResult("");
    }

    @Override
    public CommandResult postExecution(GfshParseResult parseResult, CommandResult commandResult, Path tempFile) {
        if (tempFile != null) {
            String dirName = parseResult.getParamValueAsString("dir");
            Path dirPath = StringUtils.isBlank((String)dirName) ? Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath() : Paths.get(dirName, new String[0]).toAbsolutePath();
            String fileName = "exportedLogs_" + System.currentTimeMillis() + ".zip";
            File exportedLogFile = dirPath.resolve(fileName).toFile();
            try {
                FileUtils.copyFile((File)tempFile.toFile(), (File)exportedLogFile);
                FileUtils.deleteQuietly((File)tempFile.toFile());
                commandResult = (CommandResult)ResultBuilder.createInfoResult("Logs exported to: " + exportedLogFile.getAbsolutePath());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                commandResult = ResultBuilder.createGemFireErrorResult(e.getMessage());
            }
        } else if (commandResult.getStatus() == Result.Status.OK) {
            commandResult = (CommandResult)ResultBuilder.createInfoResult("Logs exported to the connected member's file system: " + commandResult.nextLine());
        }
        return commandResult;
    }
}

