/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.domain.MemberResult;
import org.apache.geode.management.internal.cli.domain.SubscriptionQueueSizeResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;

public class DurableClientCommandsResultBuilder {
    public Result buildResult(List<MemberResult> results, String successHeader, String failureHeader) {
        boolean failure = true;
        boolean partialFailure = false;
        HashMap<String, List<String>> errorMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> successMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> exceptionMap = new HashMap<String, List<String>>();
        for (MemberResult memberResult : results) {
            if (memberResult.isSuccessful()) {
                failure = false;
                this.groupByMessage(memberResult.getSuccessMessage(), memberResult.getMemberNameOrId(), successMap);
                continue;
            }
            if (memberResult.isOpPossible()) {
                partialFailure = true;
                this.groupByMessage(memberResult.getExceptionMessage(), memberResult.getMemberNameOrId(), exceptionMap);
                continue;
            }
            this.groupByMessage(memberResult.getErrorMessage(), memberResult.getMemberNameOrId(), errorMap);
        }
        CommandResult result = !failure && !partialFailure ? ResultBuilder.buildResult(this.buildSuccessData(successMap)) : ResultBuilder.buildResult(this.buildFailureData(successMap, exceptionMap, errorMap, failureHeader));
        return result;
    }

    Result buildTableResultForQueueSize(List<SubscriptionQueueSizeResult> results, String queueSizeColumnName) {
        CommandResult result;
        boolean failure = true;
        HashMap<String, List<String>> failureMap = new HashMap<String, List<String>>();
        TreeMap<String, Long> memberQueueSizeTable = new TreeMap<String, Long>();
        for (SubscriptionQueueSizeResult memberResult : results) {
            if (memberResult.isSuccessful()) {
                failure = false;
                memberQueueSizeTable.put(memberResult.getMemberNameOrId(), memberResult.getSubscriptionQueueSize());
                continue;
            }
            this.groupByMessage(memberResult.getErrorMessage(), memberResult.getMemberNameOrId(), failureMap);
        }
        if (!failure) {
            TabularResultData table = ResultBuilder.createTabularResultData();
            Set members = memberQueueSizeTable.keySet();
            for (String member : members) {
                long queueSize = (Long)memberQueueSizeTable.get(member);
                table.accumulate("member", member);
                table.accumulate(queueSizeColumnName, queueSize);
            }
            result = ResultBuilder.buildResult(table);
        } else {
            ErrorResultData erd = ResultBuilder.createErrorResultData();
            this.buildErrorResult(erd, failureMap);
            result = ResultBuilder.buildResult(erd);
        }
        return result;
    }

    void groupByMessage(String message, String memberNameOrId, Map<String, List<String>> map) {
        List<String> members = map.get(message);
        if (members == null) {
            members = new LinkedList<String>();
        }
        members.add(memberNameOrId);
        map.put(message, members);
    }

    private InfoResultData buildSuccessData(Map<String, List<String>> successMap) {
        InfoResultData ird = ResultBuilder.createInfoResultData();
        Set<String> successMessages = successMap.keySet();
        for (String successMessage : successMessages) {
            ird.addLine(CliStrings.format("{0} on following members.", (Object)successMessage));
            List<String> successfulMembers = successMap.get(successMessage);
            int num = 0;
            for (String member : successfulMembers) {
                ird.addLine("" + ++num + "." + member);
            }
            ird.addLine("\n");
        }
        return ird;
    }

    ErrorResultData buildFailureData(Map<String, List<String>> successMap, Map<String, List<String>> exceptionMap, Map<String, List<String>> errorMap, String errorHeader) {
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        this.buildErrorResult(erd, successMap);
        erd.addLine("\n");
        erd.addLine(errorHeader);
        this.buildErrorResult(erd, exceptionMap);
        this.buildErrorResult(erd, errorMap);
        return erd;
    }

    private void buildErrorResult(ErrorResultData erd, Map<String, List<String>> resultMap) {
        if (resultMap != null && !resultMap.isEmpty()) {
            Set<String> messages = resultMap.keySet();
            for (String message : messages) {
                erd.addLine("\n");
                erd.addLine(message);
                erd.addLine("Occurred on members");
                List<String> members = resultMap.get(message);
                int num = 0;
                for (String member : members) {
                    erd.addLine("" + ++num + "." + member);
                }
            }
        }
    }
}

