/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.RegionDestroyFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyRegionCommand
extends InternalGfshCommand {
    @CliCommand(value={"destroy region"}, help="Destroy/Remove a region.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result destroyRegion(@CliOption(key={"name"}, optionContext="geode.converter.region.path:disable-string-converter", mandatory=true, help="Name/Path of the region to be removed.") String regionPath, @CliOption(key={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExists) throws Throwable {
        Set<DistributedMember> regionMembersList = this.findMembersForRegion(regionPath);
        if (regionMembersList.size() == 0) {
            String message = CliStrings.format("Could not find a Region with Region path \"{0}\" in this Geode cluster. If region was recently created, please wait for at least {1} to allow the associated Management resources to be federated.", regionPath, "jmx-manager-update-rate milliseconds");
            throw new EntityNotFoundException(message, ifExists);
        }
        List<CliFunctionResult> resultsList = this.executeAndGetFunctionResult(RegionDestroyFunction.INSTANCE, regionPath, regionMembersList);
        CommandResult result = ResultBuilder.buildResult(resultsList);
        XmlEntity xmlEntity = this.findXmlEntity(resultsList);
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> this.getConfigurationPersistenceService().deleteXmlEntity(xmlEntity, null));
        }
        return result;
    }
}

