/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DestroyGatewayReceiverFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyGatewayReceiverCommand
extends SingleGfshCommand {
    public static final String DESTROY_GATEWAYRECEIVER = "destroy gateway-receiver";
    public static final String DESTROY_GATEWAYRECEIVER__HELP = "Destroy the Gateway Receiver on a member or members.";
    public static final String DESTROY_GATEWAYRECEIVER__GROUP__HELP = "Group(s) of members on which to destroy the Gateway Receiver.";
    public static final String DESTROY_GATEWAYRECEIVER__MEMBER__HELP = "Name/Id of the member on which to destroy the Gateway Receiver.";

    @CliCommand(value={"destroy gateway-receiver"}, help="Destroy the Gateway Receiver on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel destroyGatewayReceiver(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to destroy the Gateway Receiver.") String[] onGroups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to destroy the Gateway Receiver.") String[] onMember, @CliOption(key={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExists) {
        boolean persisted = true;
        Set<DistributedMember> members = this.getMembers(onGroups, onMember);
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult(DestroyGatewayReceiverFunction.INSTANCE, null, members);
        ResultModel result = ResultModel.createMemberStatusResult(functionResults, ifExists);
        result.setConfigObject(new CacheConfig.GatewayReceiver());
        return result;
    }

    @Override
    public void updateClusterConfig(String group, CacheConfig config, Object element) {
        if (config.getGatewayReceiver() != null) {
            config.setGatewayReceiver(null);
        }
    }
}

