/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.domain.FixedPartitionAttributesInfo;
import org.apache.geode.management.internal.cli.domain.RegionDescription;
import org.apache.geode.management.internal.cli.domain.RegionDescriptionPerMember;
import org.apache.geode.management.internal.cli.functions.GetRegionDescriptionFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeRegionCommand
extends InternalGfshCommand {
    public static final Logger logger = LogService.getLogger();
    private static final GetRegionDescriptionFunction getRegionDescription = new GetRegionDescriptionFunction();

    @CliCommand(value={"describe region"}, help="Display the attributes and key information of a region.")
    @CliMetaData(relatedTopic={"Region", "Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeRegion(@CliOption(key={"name"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region to be described.", mandatory=true) String regionName) {
        List<?> resultList = this.getFunctionResultFromMembers(regionName);
        resultList.stream().filter(Throwable.class::isInstance).map(Throwable.class::cast).forEach(t -> logger.info(t.getMessage(), t));
        Map<String, List<RegionDescriptionPerMember>> perTypeDescriptions = resultList.stream().filter(RegionDescriptionPerMember.class::isInstance).map(RegionDescriptionPerMember.class::cast).collect(Collectors.groupingBy(this::descriptionGrouper));
        ArrayList<RegionDescription> regionDescriptions = new ArrayList<RegionDescription>();
        for (List<RegionDescriptionPerMember> regionDescPerMemberType : perTypeDescriptions.values()) {
            RegionDescription regionDescription = new RegionDescription();
            for (RegionDescriptionPerMember regionDescPerMember : regionDescPerMemberType) {
                regionDescription.add(regionDescPerMember);
            }
            if (regionDescription.isPartition()) {
                regionDescription.getCndRegionAttributes().remove("scope");
            } else {
                String scope = regionDescription.getCndRegionAttributes().get("scope");
                if (scope != null) {
                    scope = scope.toLowerCase().replace('_', '-');
                    regionDescription.getCndRegionAttributes().put("scope", scope);
                }
            }
            regionDescriptions.add(regionDescription);
        }
        return this.buildDescriptionResult(regionName, regionDescriptions);
    }

    private String descriptionGrouper(RegionDescriptionPerMember perTypeDesc) {
        return perTypeDesc.getName() + perTypeDesc.getScope() + perTypeDesc.getDataPolicy() + perTypeDesc.isAccessor();
    }

    List<?> getFunctionResultFromMembers(String regionName) {
        ResultCollector<?, ?> rc = this.executeFunction((Function)getRegionDescription, (Object)regionName, this.getAllNormalMembers());
        return (List)rc.getResult();
    }

    public Result buildDescriptionResult(String regionName, List<RegionDescription> regionDescriptions) {
        if (regionDescriptions.isEmpty()) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Region : {0} not found", (Object)regionName));
        }
        CompositeResultData crd = ResultBuilder.createCompositeResultData();
        for (RegionDescription regionDescription : regionDescriptions) {
            CompositeResultData.SectionResultData regionSection = crd.addSection();
            regionSection.addSeparator('-');
            regionSection.addData("Name", regionDescription.getName());
            String dataPolicy = regionDescription.getDataPolicy().toString().toLowerCase().replace('_', ' ');
            regionSection.addData("Data Policy", dataPolicy);
            String memberType = regionDescription.isAccessor() ? "Accessor Members" : "Hosting Members";
            regionSection.addData(memberType, StringUtils.join(regionDescription.getHostingMembers(), (char)'\n'));
            regionSection.addSeparator('.');
            TabularResultData commonNonDefaultAttrTable = regionSection.addTable();
            commonNonDefaultAttrTable.setHeader(CliStrings.format("Non-Default Attributes Shared By {0}  ", (Object)memberType));
            Map<String, String> cndRegionAttrsMap = regionDescription.getCndRegionAttributes();
            Map<String, String> cndEvictionAttrsMap = regionDescription.getCndEvictionAttributes();
            Map<String, String> cndPartitionAttrsMap = regionDescription.getCndPartitionAttributes();
            this.writeCommonAttributesToTable(commonNonDefaultAttrTable, "Region", cndRegionAttrsMap);
            this.writeCommonAttributesToTable(commonNonDefaultAttrTable, "Eviction", cndEvictionAttrsMap);
            this.writeCommonAttributesToTable(commonNonDefaultAttrTable, "Partition", cndPartitionAttrsMap);
            Map<String, RegionDescriptionPerMember> regDescPerMemberMap = regionDescription.getRegionDescriptionPerMemberMap();
            Set<String> members = regDescPerMemberMap.keySet();
            TabularResultData table = regionSection.addTable();
            boolean setHeader = false;
            for (String member : members) {
                RegionDescriptionPerMember regDescPerMem = regDescPerMemberMap.get(member);
                Map<String, String> ndRa = regDescPerMem.getNonDefaultRegionAttributes();
                Map<String, String> ndEa = regDescPerMem.getNonDefaultEvictionAttributes();
                Map<String, String> ndPa = regDescPerMem.getNonDefaultPartitionAttributes();
                ndRa.keySet().removeAll(cndRegionAttrsMap.keySet());
                ndEa.keySet().removeAll(cndEvictionAttrsMap.keySet());
                ndPa.keySet().removeAll(cndPartitionAttrsMap.keySet());
                if (regionDescription.isPartition() && ndRa.get("scope") != null) {
                    ndRa.remove("scope");
                }
                List<FixedPartitionAttributesInfo> fpaList = regDescPerMem.getFixedPartitionAttributes();
                if (ndRa.isEmpty() && ndEa.isEmpty() && ndPa.isEmpty() && (fpaList == null || fpaList.isEmpty())) continue;
                setHeader = true;
                boolean memberNameAdded = this.writeAttributesToTable(table, "Region", ndRa, member, false);
                memberNameAdded = this.writeAttributesToTable(table, "Eviction", ndEa, member, memberNameAdded);
                memberNameAdded = this.writeAttributesToTable(table, "Partition", ndPa, member, memberNameAdded);
                this.writeFixedPartitionAttributesToTable(table, fpaList, member, memberNameAdded);
            }
            if (!setHeader) continue;
            table.setHeader(CliStrings.format("Non-Default Attributes Specific To The {0} ", (Object)memberType));
        }
        return ResultBuilder.buildResult(crd);
    }

    private void writeCommonAttributesToTable(TabularResultData table, String attributeType, Map<String, String> attributesMap) {
        if (!attributesMap.isEmpty()) {
            Set<String> attributes = attributesMap.keySet();
            boolean isTypeAdded = false;
            String blank = "";
            for (String attributeName : attributes) {
                String type;
                String attributeValue = attributesMap.get(attributeName);
                if (!isTypeAdded) {
                    type = attributeType;
                    isTypeAdded = true;
                } else {
                    type = "";
                }
                this.writeCommonAttributeToTable(table, type, attributeName, attributeValue);
            }
        }
    }

    private void writeFixedPartitionAttributesToTable(TabularResultData table, List<FixedPartitionAttributesInfo> fpaList, String member, boolean isMemberNameAdded) {
        if (fpaList != null) {
            boolean isTypeAdded = false;
            String blank = "";
            for (FixedPartitionAttributesInfo fpa : fpaList) {
                String memName;
                String type;
                StringBuilder fpaBuilder = new StringBuilder();
                fpaBuilder.append(fpa.getPartitionName());
                fpaBuilder.append(',');
                if (fpa.isPrimary()) {
                    fpaBuilder.append("Primary");
                } else {
                    fpaBuilder.append("Secondary");
                }
                fpaBuilder.append(',');
                fpaBuilder.append(fpa.getNumBuckets());
                if (!isTypeAdded) {
                    type = "";
                    isTypeAdded = true;
                } else {
                    type = "";
                }
                if (!isMemberNameAdded) {
                    memName = member;
                    isMemberNameAdded = true;
                } else {
                    memName = "";
                }
                this.writeAttributeToTable(table, memName, type, "Fixed Partition", fpaBuilder.toString());
            }
        }
    }

    private boolean writeAttributesToTable(TabularResultData table, String attributeType, Map<String, String> attributesMap, String member, boolean isMemberNameAdded) {
        if (!attributesMap.isEmpty()) {
            Set<String> attributes = attributesMap.keySet();
            boolean isTypeAdded = false;
            String blank = "";
            for (String attributeName : attributes) {
                String memName;
                String type;
                String attributeValue = attributesMap.get(attributeName);
                if (!isTypeAdded) {
                    type = attributeType;
                    isTypeAdded = true;
                } else {
                    type = "";
                }
                if (!isMemberNameAdded) {
                    memName = member;
                    isMemberNameAdded = true;
                } else {
                    memName = "";
                }
                this.writeAttributeToTable(table, memName, type, attributeName, attributeValue);
            }
        }
        return isMemberNameAdded;
    }

    private void writeAttributeToTable(TabularResultData table, String member, String attributeType, String attributeName, String attributeValue) {
        String blank = "";
        if (attributeValue != null) {
            String[] attributeValues = attributeValue.split(",");
            boolean isFirstValue = true;
            for (String value : attributeValues) {
                if (isFirstValue) {
                    table.accumulate("Member", member);
                    table.accumulate("Type", attributeType);
                    table.accumulate("Name", attributeName);
                    table.accumulate("Value", value);
                    isFirstValue = false;
                    continue;
                }
                table.accumulate("Member", "");
                table.accumulate("Type", "");
                table.accumulate("Name", "");
                table.accumulate("Value", value);
            }
        }
    }

    private void writeCommonAttributeToTable(TabularResultData table, String attributeType, String attributeName, String attributeValue) {
        String blank = "";
        if (attributeValue != null) {
            String[] attributeValues = attributeValue.split(",");
            boolean isFirstValue = true;
            for (String value : attributeValues) {
                if (isFirstValue) {
                    isFirstValue = false;
                    table.accumulate("Type", attributeType);
                    table.accumulate("Name", attributeName);
                    table.accumulate("Value", value);
                    continue;
                }
                table.accumulate("Type", "");
                table.accumulate("Name", "");
                table.accumulate("Value", value);
            }
        }
    }
}

