/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;

public class DataCommandsUtils {
    static String makeBrokenJsonCompliant(String json) {
        if (json == null) {
            return null;
        }
        if (json.startsWith("(") && json.endsWith(")")) {
            return "{" + json.substring(1, json.length() - 1) + "}";
        }
        return json;
    }

    static DataCommandResult callFunctionForRegion(DataCommandRequest request, DataCommandFunction putfn, Set<DistributedMember> members) {
        if (members.size() == 1) {
            DistributedMember member = members.iterator().next();
            ResultCollector collector = FunctionService.onMember(member).setArguments(request).execute(putfn);
            List list = (List)collector.getResult();
            Object object = list.get(0);
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                DataCommandResult result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            DataCommandResult result = (DataCommandResult)list.get(0);
            result.aggregate(null);
            return result;
        }
        ResultCollector collector = FunctionService.onMembers(members).setArguments(request).execute(putfn);
        List list = (List)collector.getResult();
        DataCommandResult result = null;
        for (Object object : list) {
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            if (result == null) {
                result = (DataCommandResult)object;
                result.aggregate(null);
                continue;
            }
            result.aggregate((DataCommandResult)object);
        }
        return result;
    }
}

