/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityExistsException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateJndiBindingFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateJndiBindingCommand
extends SingleGfshCommand {
    private static final Logger logger = LogService.getLogger();
    static final String CREATE_JNDIBINDING = "create jndi-binding";
    static final String CREATE_JNDIBINDING__HELP = "Create a jndi binding that holds the configuration for the XA datasource.";
    static final String BLOCKING_TIMEOUT_SECONDS = "blocking-timeout-seconds";
    static final String BLOCKING_TIMEOUT_SECONDS__HELP = "This element specifies the maximum time to block while waiting for a connection before throwing an exception.";
    static final String CONNECTION_POOLED_DATASOURCE_CLASS = "conn-pooled-datasource-class";
    static final String CONNECTION_POOLED_DATASOURCE_CLASS__HELP = "This is the fully qualified name of the connection pool implementation to hold XA datasource connections.";
    static final String CONNECTION_URL = "connection-url";
    static final String CONNECTION_URL__HELP = "This is the JDBC driver connection URL string, for example, jdbc:hsqldb:hsql://localhost:1701.";
    static final String IDLE_TIMEOUT_SECONDS = "idle-timeout-seconds";
    static final String IDLE_TIMEOUT_SECONDS__HELP = "This element specifies the time a connection may be idle before being closed.";
    static final String INIT_POOL_SIZE = "init-pool-size";
    static final String INIT_POOL_SIZE__HELP = "This element specifies the initial number of connections the pool should hold.";
    static final String JDBC_DRIVER_CLASS = "jdbc-driver-class";
    static final String JDBC_DRIVER_CLASS__HELP = "This is the fully qualified name of the JDBC driver class.";
    static final String JNDI_NAME = "name";
    static final String JNDI_NAME__HELP = "Name of the binding to be created.";
    static final String LOGIN_TIMEOUT_SECONDS = "login-timeout-seconds";
    static final String LOGIN_TIMEOUT_SECONDS__HELP = "Time in seconds after which the client thread for retrieving connection will experience timeout.";
    static final String MANAGED_CONN_FACTORY_CLASS = "managed-conn-factory-class";
    static final String MANAGED_CONN_FACTORY_CLASS__HELP = "This is the fully qualified name of the connection factory implementation.";
    static final String MAX_POOL_SIZE = "max-pool-size";
    static final String MAX_POOL_SIZE__HELP = "This element specifies the maximum number of connections for a pool. No more than the max-pool-size number of connections will be created in a pool.";
    static final String PASSWORD = "password";
    static final String PASSWORD__HELP = "This element specifies the default password used when creating a new connection.";
    static final String TRANSACTION_TYPE = "transaction-type";
    static final String TRANSACTION_TYPE__HELP = "Type of the transaction.";
    static final String TYPE = "type";
    static final String TYPE__HELP = "Type of the XA datasource. The following types are pre-defined by the product: MANAGED, SIMPLE, POOLED, XAPOOLED.";
    static final String USERNAME = "username";
    static final String USERNAME__HELP = "This element specifies the default username used when creating a new connection.";
    static final String XA_DATASOURCE_CLASS = "xa-datasource-class";
    static final String XA_DATASOURCE_CLASS__HELP = "The fully qualified name of the javax.sql.XADataSource implementation class.";
    static final String IFNOTEXISTS__HELP = "Skip the create operation when a jndi binding with the same name already exists.  Without specifying this option, this command execution results into an error.";
    static final String DATASOURCE_CONFIG_PROPERTIES = "datasource-config-properties";
    static final String DATASOURCE_CONFIG_PROPERTIES_HELP = "Properties for the custom XADataSource driver. Append json string containing (name, type, value) to set any property. Eg: --datasource-config-properties={'name':'name1','type':'type1','value':'value1'},{'name':'name2','type':'type2','value':'value2'}";

    @CliCommand(value={"create jndi-binding"}, help="Create a jndi binding that holds the configuration for the XA datasource.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel createJDNIBinding(@CliOption(key={"blocking-timeout-seconds"}, help="This element specifies the maximum time to block while waiting for a connection before throwing an exception.") Integer blockingTimeout, @CliOption(key={"conn-pooled-datasource-class"}, help="This is the fully qualified name of the connection pool implementation to hold XA datasource connections.") String connectionPooledDatasource, @CliOption(key={"connection-url"}, mandatory=true, help="This is the JDBC driver connection URL string, for example, jdbc:hsqldb:hsql://localhost:1701.") String connectionUrl, @CliOption(key={"idle-timeout-seconds"}, help="This element specifies the time a connection may be idle before being closed.") Integer idleTimeout, @CliOption(key={"init-pool-size"}, help="This element specifies the initial number of connections the pool should hold.") Integer initPoolSize, @CliOption(key={"jdbc-driver-class"}, mandatory=true, help="This is the fully qualified name of the JDBC driver class.") String jdbcDriver, @CliOption(key={"name"}, mandatory=true, help="Name of the binding to be created.") String jndiName, @CliOption(key={"login-timeout-seconds"}, help="Time in seconds after which the client thread for retrieving connection will experience timeout.") Integer loginTimeout, @CliOption(key={"managed-conn-factory-class"}, help="This is the fully qualified name of the connection factory implementation.") String managedConnFactory, @CliOption(key={"max-pool-size"}, help="This element specifies the maximum number of connections for a pool. No more than the max-pool-size number of connections will be created in a pool.") Integer maxPoolSize, @CliOption(key={"password"}, help="This element specifies the default password used when creating a new connection.") String password, @CliOption(key={"transaction-type"}, help="Type of the transaction.") String transactionType, @CliOption(key={"type"}, mandatory=true, help="Type of the XA datasource. The following types are pre-defined by the product: MANAGED, SIMPLE, POOLED, XAPOOLED.") DATASOURCE_TYPE type, @CliOption(key={"username"}, help="This element specifies the default username used when creating a new connection.") String username, @CliOption(key={"xa-datasource-class"}, help="The fully qualified name of the javax.sql.XADataSource implementation class.") String xaDataSource, @CliOption(key={"if-not-exists"}, help="Skip the create operation when a jndi binding with the same name already exists.  Without specifying this option, this command execution results into an error.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifNotExists, @CliOption(key={"datasource-config-properties"}, optionContext="splittingRegex=,(?![^{]*\\})", help="Properties for the custom XADataSource driver. Append json string containing (name, type, value) to set any property. Eg: --datasource-config-properties={'name':'name1','type':'type1','value':'value1'},{'name':'name2','type':'type2','value':'value2'}") JndiBindingsType.JndiBinding.ConfigProperty[] dsConfigProperties) {
        JndiBindingsType.JndiBinding existing;
        CacheConfig cacheConfig;
        InternalConfigurationPersistenceService service;
        JndiBindingsType.JndiBinding configuration = new JndiBindingsType.JndiBinding();
        configuration.setBlockingTimeoutSeconds(Objects.toString(blockingTimeout, null));
        configuration.setConnPooledDatasourceClass(connectionPooledDatasource);
        configuration.setConnectionUrl(connectionUrl);
        configuration.setIdleTimeoutSeconds(Objects.toString(idleTimeout, null));
        configuration.setInitPoolSize(Objects.toString(initPoolSize, null));
        configuration.setJdbcDriverClass(jdbcDriver);
        configuration.setJndiName(jndiName);
        configuration.setLoginTimeoutSeconds(Objects.toString(loginTimeout, null));
        configuration.setManagedConnFactoryClass(managedConnFactory);
        configuration.setMaxPoolSize(Objects.toString(maxPoolSize, null));
        configuration.setPassword(password);
        configuration.setTransactionType(transactionType);
        configuration.setType(type.getType());
        configuration.setUserName(username);
        configuration.setXaDatasourceClass(xaDataSource);
        if (dsConfigProperties != null && dsConfigProperties.length > 0) {
            configuration.getConfigProperties().addAll(Arrays.asList(dsConfigProperties));
        }
        if ((service = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService()) != null && (cacheConfig = service.getCacheConfig("cluster")) != null && (existing = CacheElement.findElement(cacheConfig.getJndiBindings(), jndiName)) != null) {
            throw new EntityExistsException(CliStrings.format("Jndi binding with jndi-name \"{0}\" already exists.", (Object)jndiName), ifNotExists);
        }
        Set<DistributedMember> targetMembers = this.findMembers(null, null);
        if (targetMembers.size() > 0) {
            List<CliFunctionResult> jndiCreationResult = this.executeAndGetFunctionResult(new CreateJndiBindingFunction(), configuration, targetMembers);
            ResultModel result = ResultModel.createMemberStatusResult(jndiCreationResult);
            result.setConfigObject(configuration);
            return result;
        }
        return ResultModel.createInfo("No members found.");
    }

    @Override
    public void updateClusterConfig(String group, CacheConfig config, Object element) {
        config.getJndiBindings().add((JndiBindingsType.JndiBinding)element);
    }

    public static enum DATASOURCE_TYPE {
        MANAGED("ManagedDataSource"),
        SIMPLE("SimpleDataSource"),
        POOLED("PooledDataSource"),
        XAPOOLED("XAPooledDataSource");

        private final String type;

        private DATASOURCE_TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name();
        }
    }
}

