/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateIndexFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateIndexCommand
extends SingleGfshCommand {
    private static final CreateIndexFunction createIndexFunction = new CreateIndexFunction();

    @CliCommand(value={"create index"}, help="Create an index that can be used when executing queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the index to create.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member in which the index will be created.") String[] memberNameOrID, @CliOption(key={"type"}, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type:disable-enum-converter", help="Type of the index. Valid values are: range and key. Deprecated: Since Geode 1.4, hash should not be used.") IndexType indexType, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members in which the index will be created.") String[] groups) {
        Set<DistributedMember> targetMembers = this.findMembers(groups, memberNameOrID);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        RegionConfig.Index index = new RegionConfig.Index();
        index.setName(indexName);
        index.setExpression(indexedExpression);
        index.setFromClause(regionPath);
        if (indexType == IndexType.PRIMARY_KEY) {
            index.setKeyIndex(true);
        } else {
            index.setKeyIndex(false);
            index.setType(indexType.getName());
        }
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult(createIndexFunction, index, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult(functionResults);
        result.setConfigObject(index);
        return result;
    }

    String getValidRegionName(String regionPath, CacheConfig cacheConfig) {
        String[] regionPathTokens = regionPath.trim().split(" ");
        regionPath = regionPathTokens[0];
        while (regionPath.contains(".") && cacheConfig.findRegionConfiguration(regionPath) == null) {
            regionPath = regionPath.substring(0, regionPath.lastIndexOf("."));
        }
        return regionPath;
    }

    @Override
    public void updateClusterConfig(String group, CacheConfig config, Object element) {
        RegionConfig.Index index = (RegionConfig.Index)element;
        String regionPath = this.getValidRegionName(index.getFromClause(), config);
        RegionConfig regionConfig = config.findRegionConfiguration(regionPath);
        if (regionConfig == null) {
            throw new EntityNotFoundException("Region " + index.getFromClause() + " not found.");
        }
        regionConfig.getIndexes().add(index);
    }
}

