/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverCreateFunction;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverFunctionArgs;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateGatewayReceiverCommand
extends SingleGfshCommand {
    @CliCommand(value={"create gateway-receiver"}, help="Create the Gateway Receiver on a member or members.")
    @CliMetaData(relatedTopic={"WAN"}, interceptor="org.apache.geode.management.internal.cli.commands.CreateGatewayReceiverCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel createGatewayReceiver(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to create the Gateway Receiver.") String[] onGroups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to create the Gateway Receiver.") String[] onMember, @CliOption(key={"manual-start"}, help="Whether manual start is to be enabled or the receiver will start automatically after creation.") Boolean manualStart, @CliOption(key={"start-port"}, help="Starting value of the port range from which the GatewayReceiver's port will be chosen.") Integer startPort, @CliOption(key={"end-port"}, help="End value of the port range from which the GatewayReceiver's port will be chosen.") Integer endPort, @CliOption(key={"bind-address"}, help="The IP address or host name that the receiver's socket will listen on for client connections.") String bindAddress, @CliOption(key={"maximum-time-between-pings"}, help="The maximum amount of time between client pings.") Integer maximumTimeBetweenPings, @CliOption(key={"socket-buffer-size"}, help="The buffer size in bytes of the socket connection for this GatewayReceiver.") Integer socketBufferSize, @CliOption(key={"gateway-transport-filter"}, help="The fully qualified class names of GatewayTransportFilters (separated by comma) to be added to the GatewayReceiver. e.g. gateway-transport-filter=com.user.filters.MyFilter1,com.user.filters.MyFilters2") String[] gatewayTransportFilters, @CliOption(key={"hostname-for-senders"}, help="The host name that server locators will tell GatewaySenders this GatewayReceiver is listening on.") String hostnameForSenders, @CliOption(key={"if-not-exists"}, help="If true, the command will be a no-op if the entity does exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") Boolean ifNotExists) {
        CacheConfig.GatewayReceiver configuration = this.buildConfiguration(manualStart, startPort, endPort, bindAddress, maximumTimeBetweenPings, socketBufferSize, gatewayTransportFilters, hostnameForSenders);
        GatewayReceiverFunctionArgs gatewayReceiverFunctionArgs = new GatewayReceiverFunctionArgs(configuration, ifNotExists);
        Set<DistributedMember> membersToCreateGatewayReceiverOn = this.getMembers(onGroups, onMember);
        List<CliFunctionResult> gatewayReceiverCreateResults = this.executeAndGetFunctionResult(GatewayReceiverCreateFunction.INSTANCE, gatewayReceiverFunctionArgs, membersToCreateGatewayReceiverOn);
        ResultModel result = ResultModel.createMemberStatusResult(gatewayReceiverCreateResults);
        result.setConfigObject(configuration);
        return result;
    }

    @Override
    public void updateClusterConfig(String group, CacheConfig config, Object configObject) {
        config.setGatewayReceiver((CacheConfig.GatewayReceiver)configObject);
    }

    private CacheConfig.GatewayReceiver buildConfiguration(Boolean manualStart, Integer startPort, Integer endPort, String bindAddress, Integer maximumTimeBetweenPings, Integer socketBufferSize, String[] gatewayTransportFilters, String hostnameForSenders) {
        CacheConfig.GatewayReceiver configuration = new CacheConfig.GatewayReceiver();
        if (gatewayTransportFilters != null) {
            List filters = Arrays.stream(gatewayTransportFilters).map(fullyQualifiedClassName -> {
                DeclarableType thisFilter = new DeclarableType();
                thisFilter.setClassName((String)fullyQualifiedClassName);
                return thisFilter;
            }).collect(Collectors.toList());
            configuration.getGatewayTransportFilters().addAll(filters);
        }
        if (startPort != null) {
            configuration.setStartPort(String.valueOf(startPort));
        }
        if (endPort != null) {
            configuration.setEndPort(String.valueOf(endPort));
        }
        configuration.setBindAddress(bindAddress);
        if (maximumTimeBetweenPings != null) {
            configuration.setMaximumTimeBetweenPings(String.valueOf(maximumTimeBetweenPings));
        }
        if (socketBufferSize != null) {
            configuration.setSocketBufferSize(String.valueOf(socketBufferSize));
        }
        configuration.setHostnameForSenders(hostnameForSenders);
        configuration.setManualStart(manualStart);
        return configuration;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            Integer startPort = (Integer)parseResult.getParamValue("start-port");
            Integer endPort = (Integer)parseResult.getParamValue("end-port");
            if (startPort == null) {
                startPort = 5000;
            }
            if (endPort == null) {
                endPort = 5500;
            }
            if (startPort > endPort) {
                return ResultModel.createError("start-port must be smaller than end-port.");
            }
            return ResultModel.createInfo("");
        }
    }
}

