/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.ChangeLogLevelFunction;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ChangeLogLevelCommand
extends InternalGfshCommand {
    private static Logger logger = LogService.getLogger();

    @CliCommand(value={"change loglevel"}, help="This command changes log-level run time on specified servers.")
    @CliMetaData(relatedTopic={"Logs"}, interceptor="org.apache.geode.management.internal.cli.commands.ChangeLogLevelCommand$ChangeLogLevelCommandInterceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.WRITE)
    public Result changeLogLevel(@CliOption(key={"member", "members"}, help="Name/Id of the member to change the log-level") String[] memberIds, @CliOption(key={"group", "groups"}, unspecifiedDefaultValue="", help="Groups of members to change the log-level") String[] grps, @CliOption(key={"loglevel"}, optionContext="geode.converter.log.levels:disable-string-converter", mandatory=true, unspecifiedDefaultValue="", help="Log level to change to") String logLevel) {
        if (!(memberIds != null && memberIds.length != 0 || grps != null && grps.length != 0)) {
            return ResultBuilder.createUserErrorResult("Specify one of group or member");
        }
        Cache cache = this.getCache();
        HashSet<DistributedMember> dsMembers = new HashSet<DistributedMember>();
        Set<DistributedMember> ds = this.getAllMembers();
        if (grps != null && grps.length > 0) {
            for (String grp : grps) {
                dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(grp));
            }
        }
        if (memberIds != null && memberIds.length > 0) {
            block3: for (String member : memberIds) {
                for (DistributedMember mem : ds) {
                    if (mem.getName() == null || !mem.getName().equals(member) && !mem.getId().equals(member)) continue;
                    dsMembers.add(mem);
                    continue block3;
                }
            }
        }
        if (dsMembers.size() == 0) {
            return ResultBuilder.createGemFireErrorResult("No members were found matching the given member IDs or groups.");
        }
        ChangeLogLevelFunction logFunction = new ChangeLogLevelFunction();
        FunctionService.registerFunction(logFunction);
        Object[] functionArgs = new Object[]{logLevel};
        CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = compositeResultData.addSection("section");
        TabularResultData resultTable = section.addTable("ChangeLogLevel");
        resultTable = resultTable.setHeader("Summary");
        Execution execution = FunctionService.onMembers(dsMembers).setArguments(functionArgs);
        if (execution == null) {
            return ResultBuilder.createUserErrorResult("Cannot execute change log-level.");
        }
        List resultList = (List)this.executeFunction((Function)logFunction, (Object)functionArgs, dsMembers).getResult();
        for (Object object : resultList) {
            try {
                if (object instanceof Throwable) {
                    logger.warn("Exception in ChangeLogLevelFunction " + ((Throwable)object).getMessage(), (Throwable)object);
                    continue;
                }
                if (object == null) continue;
                Map resultMap = (Map)object;
                Map.Entry entry = resultMap.entrySet().iterator().next();
                if (((String)entry.getValue()).contains("ChangeLogLevelFunction exception")) {
                    resultTable.accumulate("Member", entry.getKey());
                    resultTable.accumulate("Changed log-level", "false");
                    continue;
                }
                resultTable.accumulate("Member", entry.getKey());
                resultTable.accumulate("Changed log-level", "true");
            }
            catch (Exception ex) {
                logger.warn("change log level command exception " + ex);
            }
        }
        CommandResult result = ResultBuilder.buildResult(compositeResultData);
        logger.info("change log-level command result=" + result);
        return result;
    }

    public static class ChangeLogLevelCommandInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String logLevel = parseResult.getParamValueAsString("loglevel");
            if (StringUtils.isBlank((String)logLevel) || LogLevel.getLevel(logLevel) == null) {
                return ResultBuilder.createUserErrorResult("Invalid log level: " + logLevel);
            }
            return ResultBuilder.createInfoResult("");
        }
    }
}

