/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.commands.RegionCommandsUtils;
import org.apache.geode.management.internal.cli.domain.ClassName;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.RegionAlterFunction;
import org.apache.geode.management.internal.cli.functions.RegionFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class AlterRegionCommand
extends InternalGfshCommand {
    @CliCommand(value={"alter region"}, help="Alter a region with the given path and configuration.")
    @CliMetaData(relatedTopic={"Region"})
    public Result alterRegion(@CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region to be altered.") String regionPath, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which the region will be altered.") String[] groups, @CliOption(key={"entry-idle-time-expiration"}, help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @CliOption(key={"entry-idle-time-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on an entry that has exceeded the idle expiration.") ExpirationAction entryExpirationIdleTimeAction, @CliOption(key={"entry-time-to-live-expiration"}, help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @CliOption(key={"entry-time-to-live-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on an entry that has exceeded the TTL expiration.") ExpirationAction entryExpirationTTLAction, @CliOption(key={"entry-idle-time-custom-expiry"}, specifiedDefaultValue="", help="The name of the class implementing CustomExpiry for entry idle time. Append json string for initialization properties.") ClassName<CustomExpiry> entryIdleTimeCustomExpiry, @CliOption(key={"entry-time-to-live-custom-expiry"}, specifiedDefaultValue="", help="The name of the class implementing CustomExpiry for entry time to live. Append json string for initialization properties.") ClassName<CustomExpiry> entryTTLCustomExpiry, @CliOption(key={"region-idle-time-expiration"}, help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @CliOption(key={"region-idle-time-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on a region that has exceeded the idle expiration.") ExpirationAction regionExpirationIdleTimeAction, @CliOption(key={"region-time-to-live-expiration"}, help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @CliOption(key={"region-time-to-live-expiration-action"}, specifiedDefaultValue="INVALIDATE", help="Action to be taken on a region that has exceeded the TTL expiration.") ExpirationAction regionExpirationTTLAction, @CliOption(key={"cache-listener"}, specifiedDefaultValue="", optionContext="splittingRegex=,(?![^{]*\\})", help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Any number of cache listeners can be configured.") ClassName<CacheListener>[] cacheListeners, @CliOption(key={"cache-loader"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") ClassName<CacheLoader> cacheLoader, @CliOption(key={"cache-writer"}, specifiedDefaultValue="", help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") ClassName<CacheWriter> cacheWriter, @CliOption(key={"async-event-queue-id"}, specifiedDefaultValue="", help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @CliOption(key={"gateway-sender-id"}, specifiedDefaultValue="", help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @CliOption(key={"enable-cloning"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") boolean cloningEnabled, @CliOption(key={"eviction-max"}, specifiedDefaultValue="0", help="Maximum value for the Eviction Attributes which the Eviction Algorithm uses to determine when to perform its Eviction Action. The unit of the maximum value is determined by the Eviction Algorithm.") Integer evictionMax) {
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.MANAGE, regionPath);
        InternalCache cache = (InternalCache)this.getCache();
        if (groups != null) {
            RegionCommandsUtils.validateGroups(cache, groups);
        }
        RegionFunctionArgs regionFunctionArgs = new RegionFunctionArgs();
        regionFunctionArgs.setRegionPath(regionPath);
        regionFunctionArgs.setEntryExpirationIdleTime(entryExpirationIdleTime, entryExpirationIdleTimeAction);
        regionFunctionArgs.setEntryExpirationTTL(entryExpirationTTL, entryExpirationTTLAction);
        regionFunctionArgs.setEntryIdleTimeCustomExpiry(entryIdleTimeCustomExpiry);
        regionFunctionArgs.setEntryTTLCustomExpiry(entryTTLCustomExpiry);
        regionFunctionArgs.setRegionExpirationIdleTime(regionExpirationIdleTime, regionExpirationIdleTimeAction);
        regionFunctionArgs.setRegionExpirationTTL(regionExpirationTTL, regionExpirationTTLAction);
        regionFunctionArgs.setCacheListeners(cacheListeners);
        regionFunctionArgs.setCacheLoader(cacheLoader);
        regionFunctionArgs.setCacheWriter(cacheWriter);
        regionFunctionArgs.setAsyncEventQueueIds(asyncEventQueueIds);
        regionFunctionArgs.setGatewaySenderIds(gatewaySenderIds);
        regionFunctionArgs.setCloningEnabled(cloningEnabled);
        regionFunctionArgs.setEvictionMax(evictionMax);
        if (evictionMax != null && evictionMax < 0) {
            throw new IllegalArgumentException(CliStrings.format("Specify 0 or a positive integer value for eviction-max.  \"{0}\" is not valid.", (Object)evictionMax));
        }
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        List<CliFunctionResult> regionAlterResults = this.executeAndGetFunctionResult(new RegionAlterFunction(), regionFunctionArgs, targetMembers);
        CommandResult result = ResultBuilder.buildResult(regionAlterResults);
        XmlEntity xmlEntity = this.findXmlEntity(regionAlterResults);
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> this.getConfigurationPersistenceService().addXmlEntity(xmlEntity, groups));
        }
        return result;
    }
}

