/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AlterAsyncEventQueueCommand
extends InternalGfshCommand {
    public static final String GROUP_STATUS_SECTION = "group-status";
    static final String COMMAND_NAME = "alter async-event-queue";
    static final String ID = "id";
    static final String BATCH_SIZE = "batch-size";
    static final String BATCH_TIME_INTERVAL = "batch-time-interval";
    static final String MAX_QUEUE_MEMORY = "max-queue-memory";
    static final String MAXIMUM_QUEUE_MEMORY = "maximum-queue-memory";
    static final String COMMAND_HELP = "alter attributes of async-event-queue, needs rolling restart for new attributes to take effect. ";
    static final String ID_HELP = "Id of the async event queue to be changed.";
    static final String BATCH_SIZE_HELP = "Maximum number of events that a batch can contain.";
    static final String BATCH_TIME_INTERVAL_HELP = "Maximum amount of time, in ms, that can elapse before a batch is delivered.";
    static final String MAXIMUM_QUEUE_MEMORY_HELP = "Maximum amount of memory, in megabytes, that the queue can consume before overflowing to disk.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"alter async-event-queue"}, help="alter attributes of async-event-queue, needs rolling restart for new attributes to take effect. ")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.AlterAsyncEventQueueCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public ResultModel execute(@CliOption(key={"id"}, mandatory=true, help="Id of the async event queue to be changed.") String id, @CliOption(key={"batch-size"}, help="Maximum number of events that a batch can contain.") Integer batchSize, @CliOption(key={"batch-time-interval"}, help="Maximum amount of time, in ms, that can elapse before a batch is delivered.") Integer batchTimeInterval, @CliOption(key={"max-queue-memory"}, help="Maximum amount of memory, in megabytes, that the queue can consume before overflowing to disk.") Integer maxQueueMemory, @CliOption(key={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExists) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        InternalConfigurationPersistenceService service = this.getConfigurationPersistenceService();
        if (service == null) {
            return ResultModel.createError("Cluster Configuration Service is not available. Please connect to a locator with running Cluster Configuration Service.");
        }
        boolean locked = service.lockSharedConfiguration();
        if (!locked) {
            return ResultModel.createCommandProcessingError("Unable to lock the cluster configuration.");
        }
        ResultModel result = new ResultModel();
        TabularResultModel tableData = result.addTable(GROUP_STATUS_SECTION);
        boolean xmlUpdated = false;
        try {
            Region<String, Configuration> configRegion = service.getConfigurationRegion();
            for (String group : configRegion.keySet()) {
                Configuration config = configRegion.get(group);
                if (config.getCacheXmlContent() == null) continue;
                Document document = XmlUtils.createDocumentFromXml(config.getCacheXmlContent());
                NodeList nodeList = document.getElementsByTagName("async-event-queue");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element item = (Element)nodeList.item(i);
                    String queueId = item.getAttribute(ID);
                    if (!id.equals(queueId)) continue;
                    if (batchSize != null) {
                        item.setAttribute(BATCH_SIZE, batchSize + "");
                    }
                    if (batchTimeInterval != null) {
                        item.setAttribute(BATCH_TIME_INTERVAL, batchTimeInterval + "");
                    }
                    if (maxQueueMemory != null) {
                        item.setAttribute(MAXIMUM_QUEUE_MEMORY, maxQueueMemory + "");
                    }
                    tableData.accumulate("Group", group);
                    tableData.accumulate("Status", "Cluster Configuration Updated");
                    xmlUpdated = true;
                    break;
                }
                if (!xmlUpdated) continue;
                String newXml = XmlUtils.prettyXml(document.getFirstChild());
                config.setCacheXmlContent(newXml);
                configRegion.put(group, config);
            }
        }
        finally {
            service.unlockSharedConfiguration();
        }
        if (!xmlUpdated) {
            String message = String.format("Can not find an async event queue with id '%s'.", id);
            throw new EntityNotFoundException(message, ifExists);
        }
        tableData.setFooter(System.lineSeparator() + "These changes won't take effect on the running servers. " + System.lineSeparator() + "Please restart the servers in these groups for the changes to take effect.");
        return result;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            Object batchSize = parseResult.getParamValue(AlterAsyncEventQueueCommand.BATCH_SIZE);
            Object batchTimeInterval = parseResult.getParamValue(AlterAsyncEventQueueCommand.BATCH_TIME_INTERVAL);
            Object maxQueueMemory = parseResult.getParamValue(AlterAsyncEventQueueCommand.MAX_QUEUE_MEMORY);
            if (batchSize == null && batchTimeInterval == null && maxQueueMemory == null) {
                return ResultModel.createError("need to specify at least one option to modify.");
            }
            return new ResultModel();
        }
    }
}

