/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ResourceEventsListener;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.internal.AlertDetails;
import org.apache.geode.management.internal.beans.ManagementAdapter;

public class ManagementListener
implements ResourceEventsListener {
    private ManagementAdapter adapter;
    private LogWriterI18n logger;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public ManagementListener() {
        this.adapter = new ManagementAdapter();
        this.logger = InternalDistributedSystem.getLoggerI18n();
    }

    private boolean shouldProceed(ResourceEvent event) {
        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
        if (system == null && !event.equals((Object)ResourceEvent.CACHE_REMOVE)) {
            return false;
        }
        GemFireCacheImpl currentCache = GemFireCacheImpl.getInstance();
        if (currentCache == null) {
            return false;
        }
        return !currentCache.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleEvent(ResourceEvent event, Object resource) {
        if (!this.shouldProceed(event)) {
            return;
        }
        try {
            if (event == ResourceEvent.CACHE_CREATE || event == ResourceEvent.CACHE_REMOVE) {
                this.readWriteLock.writeLock().lock();
            } else {
                this.readWriteLock.readLock().lock();
            }
            switch (event) {
                case CACHE_CREATE: {
                    InternalCache createdCache = (InternalCache)resource;
                    this.adapter.handleCacheCreation(createdCache);
                    return;
                }
                case CACHE_REMOVE: {
                    InternalCache removedCache = (InternalCache)resource;
                    this.adapter.handleCacheRemoval(removedCache);
                    return;
                }
                case REGION_CREATE: {
                    Region createdRegion = (Region)resource;
                    this.adapter.handleRegionCreation(createdRegion);
                    return;
                }
                case REGION_REMOVE: {
                    Region removedRegion = (Region)resource;
                    this.adapter.handleRegionRemoval(removedRegion);
                    return;
                }
                case DISKSTORE_CREATE: {
                    DiskStore createdDisk = (DiskStore)resource;
                    this.adapter.handleDiskCreation(createdDisk);
                    return;
                }
                case DISKSTORE_REMOVE: {
                    DiskStore removedDisk = (DiskStore)resource;
                    this.adapter.handleDiskRemoval(removedDisk);
                    return;
                }
                case GATEWAYRECEIVER_CREATE: {
                    GatewayReceiver createdRecv = (GatewayReceiver)resource;
                    this.adapter.handleGatewayReceiverCreate(createdRecv);
                    return;
                }
                case GATEWAYRECEIVER_DESTROY: {
                    GatewayReceiver destroyedRecv = (GatewayReceiver)resource;
                    this.adapter.handleGatewayReceiverDestroy(destroyedRecv);
                    return;
                }
                case GATEWAYRECEIVER_START: {
                    GatewayReceiver startedRecv = (GatewayReceiver)resource;
                    this.adapter.handleGatewayReceiverStart(startedRecv);
                    return;
                }
                case GATEWAYRECEIVER_STOP: {
                    GatewayReceiver stoppededRecv = (GatewayReceiver)resource;
                    this.adapter.handleGatewayReceiverStop(stoppededRecv);
                    return;
                }
                case GATEWAYSENDER_CREATE: {
                    GatewaySender sender = (GatewaySender)resource;
                    this.adapter.handleGatewaySenderCreation(sender);
                    return;
                }
                case GATEWAYSENDER_START: {
                    GatewaySender startedSender = (GatewaySender)resource;
                    this.adapter.handleGatewaySenderStart(startedSender);
                    return;
                }
                case GATEWAYSENDER_STOP: {
                    GatewaySender stoppedSender = (GatewaySender)resource;
                    this.adapter.handleGatewaySenderStop(stoppedSender);
                    return;
                }
                case GATEWAYSENDER_PAUSE: {
                    GatewaySender pausedSender = (GatewaySender)resource;
                    this.adapter.handleGatewaySenderPaused(pausedSender);
                    return;
                }
                case GATEWAYSENDER_RESUME: {
                    GatewaySender resumedSender = (GatewaySender)resource;
                    this.adapter.handleGatewaySenderResumed(resumedSender);
                    return;
                }
                case GATEWAYSENDER_REMOVE: {
                    GatewaySender removedSender = (GatewaySender)resource;
                    this.adapter.handleGatewaySenderRemoved(removedSender);
                    return;
                }
                case LOCKSERVICE_CREATE: {
                    DLockService createdLockService = (DLockService)resource;
                    this.adapter.handleLockServiceCreation(createdLockService);
                    return;
                }
                case LOCKSERVICE_REMOVE: {
                    DLockService removedLockService = (DLockService)resource;
                    this.adapter.handleLockServiceRemoval(removedLockService);
                    return;
                }
                case MANAGER_CREATE: {
                    this.adapter.handleManagerCreation();
                    return;
                }
                case MANAGER_START: {
                    this.adapter.handleManagerStart();
                    return;
                }
                case MANAGER_STOP: {
                    this.adapter.handleManagerStop();
                    return;
                }
                case ASYNCEVENTQUEUE_CREATE: {
                    AsyncEventQueue queue = (AsyncEventQueue)resource;
                    this.adapter.handleAsyncEventQueueCreation(queue);
                    return;
                }
                case ASYNCEVENTQUEUE_REMOVE: {
                    AsyncEventQueue removedQueue = (AsyncEventQueue)resource;
                    this.adapter.handleAsyncEventQueueRemoval(removedQueue);
                    return;
                }
                case SYSTEM_ALERT: {
                    AlertDetails details = (AlertDetails)resource;
                    this.adapter.handleSystemNotification(details);
                    return;
                }
                case CACHE_SERVER_START: {
                    CacheServer startedServer = (CacheServer)resource;
                    this.adapter.handleCacheServerStart(startedServer);
                    return;
                }
                case CACHE_SERVER_STOP: {
                    CacheServer stoppedServer = (CacheServer)resource;
                    this.adapter.handleCacheServerStop(stoppedServer);
                    return;
                }
                case LOCATOR_START: {
                    Locator loc = (Locator)resource;
                    this.adapter.handleLocatorStart(loc);
                    return;
                }
                case CACHE_SERVICE_CREATE: {
                    CacheService service = (CacheService)resource;
                    this.adapter.handleCacheServiceCreation(service);
                    return;
                }
            }
            return;
        }
        finally {
            if (event == ResourceEvent.CACHE_CREATE || event == ResourceEvent.CACHE_REMOVE) {
                this.readWriteLock.writeLock().unlock();
            } else {
                this.readWriteLock.readLock().unlock();
            }
        }
    }
}

