/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.management.internal.MBeanProxyInvocationHandler;
import org.apache.geode.management.internal.OpenMethod;
import org.apache.geode.management.internal.OpenTypeUtil;

public class MXBeanProxyInvocationHandler {
    private ObjectName objectName;
    private MBeanProxyInvocationHandler proxyHandler;
    private final Map<Method, MethodHandler> methodHandlerMap = OpenTypeUtil.newMap();
    private LogWriterI18n logger;

    public MXBeanProxyInvocationHandler(ObjectName objectName, Class<?> mxbeanInterface, MBeanProxyInvocationHandler proxyHandler) throws Exception {
        if (mxbeanInterface == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.objectName = objectName;
        this.proxyHandler = proxyHandler;
        this.logger = InternalDistributedSystem.getLoggerI18n();
        this.initHandlers(mxbeanInterface);
    }

    private void initHandlers(Class<?> mbeanInterface) throws Exception {
        Method[] methodArray = mbeanInterface.getMethods();
        List<Method> methods = MXBeanProxyInvocationHandler.eliminateCovariantMethods(methodArray);
        for (Method m : methods) {
            String name = m.getName();
            String attrName = "";
            if (name.startsWith("get")) {
                attrName = name.substring(3);
            } else if (name.startsWith("is") && m.getReturnType() == Boolean.TYPE) {
                attrName = name.substring(2);
            }
            if (attrName.length() != 0 && m.getParameterTypes().length == 0 && m.getReturnType() != Void.TYPE) {
                this.methodHandlerMap.put(m, new GetterHandler(attrName, OpenMethod.from(m)));
                continue;
            }
            if (name.startsWith("set") && name.length() > 3 && m.getParameterTypes().length == 1 && m.getReturnType() == Void.TYPE) {
                this.methodHandlerMap.put(m, new SetterHandler(attrName, OpenMethod.from(m)));
                continue;
            }
            this.methodHandlerMap.put(m, new OpHandler(attrName, OpenMethod.from(m)));
        }
    }

    static List<Method> eliminateCovariantMethods(Method[] methodArray) {
        int len = methodArray.length;
        Method[] sorted = (Method[])methodArray.clone();
        Arrays.sort(sorted, MethodOrder.instance);
        Set<Method> overridden = OpenTypeUtil.newSet();
        for (int i = 1; i < len; ++i) {
            Method m0 = sorted[i - 1];
            Method m1 = sorted[i];
            if (!m0.getName().equals(m1.getName()) || !Arrays.equals(m0.getParameterTypes(), m1.getParameterTypes())) continue;
            overridden.add(m0);
        }
        List<Method> methods = OpenTypeUtil.newList(Arrays.asList(methodArray));
        methods.removeAll(overridden);
        return methods;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodHandler handler = this.methodHandlerMap.get(method);
        OpenMethod cm = handler.getConvertingMethod();
        Object[] openArgs = cm.toOpenParameters(args);
        Object result = handler.invoke(proxy, method, openArgs);
        return cm.fromOpenReturnValue(result);
    }

    private class OpHandler
    extends MethodHandler {
        OpHandler(String operationName, OpenMethod cm) {
            super(operationName, cm);
        }

        @Override
        Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            String[] signature = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                signature[i] = paramTypes[i].getName();
            }
            return MXBeanProxyInvocationHandler.this.proxyHandler.delegateToFucntionService(MXBeanProxyInvocationHandler.this.objectName, methodName, args, signature);
        }
    }

    private class SetterHandler
    extends MethodHandler {
        SetterHandler(String attributeName, OpenMethod cm) {
            super(attributeName, cm);
        }

        @Override
        Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            String[] signature = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                signature[i] = paramTypes[i].getName();
            }
            return MXBeanProxyInvocationHandler.this.proxyHandler.delegateToFucntionService(MXBeanProxyInvocationHandler.this.objectName, methodName, args, signature);
        }
    }

    private class GetterHandler
    extends MethodHandler {
        GetterHandler(String attributeName, OpenMethod cm) {
            super(attributeName, cm);
        }

        @Override
        Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            assert (args == null || args.length == 0);
            String methodName = method.getName();
            String attrName = "";
            if (methodName.startsWith("get")) {
                attrName = methodName.substring(3);
            } else if (methodName.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
                attrName = methodName.substring(2);
            }
            return MXBeanProxyInvocationHandler.this.proxyHandler.delegateToObjectState(attrName);
        }
    }

    private abstract class MethodHandler {
        private final String name;
        private final OpenMethod convertingMethod;

        MethodHandler(String name, OpenMethod cm) {
            this.name = name;
            this.convertingMethod = cm;
        }

        String getName() {
            return this.name;
        }

        OpenMethod getConvertingMethod() {
            return this.convertingMethod;
        }

        abstract Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;
    }

    private static class MethodOrder
    implements Comparator<Method> {
        public static final MethodOrder instance = new MethodOrder();

        private MethodOrder() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?> bret;
            Object[] bparams;
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            Object[] aparams = a.getParameterTypes();
            if (aparams.length != (bparams = b.getParameterTypes()).length) {
                return aparams.length - bparams.length;
            }
            if (!Arrays.equals(aparams, bparams)) {
                return Arrays.toString(aparams).compareTo(Arrays.toString(bparams));
            }
            Class<?> aret = a.getReturnType();
            if (aret == (bret = b.getReturnType())) {
                return 0;
            }
            if (aret.isAssignableFrom(bret)) {
                return -1;
            }
            return 1;
        }
    }
}

