/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.geode.annotations.TestingOnly;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MBeanProxyFactory;
import org.apache.geode.management.internal.ManagementCacheListener;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.Manager;
import org.apache.geode.management.internal.MemberMessenger;
import org.apache.geode.management.internal.NotificationCacheListener;
import org.apache.geode.management.internal.NotificationKey;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class FederatingManager
extends Manager {
    public static final Logger logger = LogService.getLogger();
    private ExecutorService pooledMembershipExecutor;
    protected MBeanProxyFactory proxyFactory;
    private MBeanJMXAdapter jmxAdapter;
    private MemberMessenger messenger;
    private SystemManagementService service;
    private AtomicReference<Exception> latestException = new AtomicReference<Object>(null);

    public FederatingManager(MBeanJMXAdapter jmxAdapter, ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache) {
        super(repo, system, cache);
        this.service = service;
        this.proxyFactory = new MBeanProxyFactory(jmxAdapter, service);
        this.jmxAdapter = jmxAdapter;
        this.messenger = new MemberMessenger(jmxAdapter, repo, system);
    }

    @TestingOnly
    void setProxyFactory(MBeanProxyFactory newProxyFactory) {
        this.proxyFactory = newProxyFactory;
    }

    @Override
    public synchronized void startManager() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting the Federating Manager.... ");
            }
            Runtime rt = Runtime.getRuntime();
            this.pooledMembershipExecutor = Executors.newFixedThreadPool(rt.availableProcessors());
            this.running = true;
            this.startManagingActivity();
            this.messenger.broadcastManagerInfo();
        }
        catch (Exception e) {
            this.running = false;
            throw new ManagementException(e);
        }
    }

    @Override
    public synchronized void stopManager() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping the Federating Manager.... ");
        }
        this.stopManagingActivity();
    }

    private void stopManagingActivity() {
        try {
            this.pooledMembershipExecutor.shutdownNow();
            for (DistributedMember distributedMember : this.repo.getMonitoringRegionMap().keySet()) {
                this.removeMemberArtifacts(distributedMember, false);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void addMember(DistributedMember member) {
        GIITask giiTask = new GIITask(member);
        this.executeTask(() -> {
            try {
                giiTask.call();
            }
            catch (Exception e) {
                logger.warn("Error federating new member {}: {}", (Object)member.getId(), (Object)e.getMessage());
                this.latestException.set(e);
            }
        });
    }

    public void removeMember(DistributedMember member, boolean crashed) {
        RemoveMemberTask removeTask = new RemoveMemberTask(member, crashed);
        this.executeTask(removeTask);
    }

    private void executeTask(Runnable task) {
        try {
            this.pooledMembershipExecutor.execute(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private DistributedMember removeMemberArtifacts(DistributedMember member, boolean crashed) {
        Region<String, Object> proxyRegion = this.repo.getEntryFromMonitoringRegionMap(member);
        Region<NotificationKey, Notification> notifRegion = this.repo.getEntryFromNotifRegionMap(member);
        if (proxyRegion == null && notifRegion == null) {
            return member;
        }
        this.repo.romoveEntryFromMonitoringRegionMap(member);
        this.repo.removeEntryFromNotifRegionMap(member);
        if (!this.cache.isClosed()) {
            this.proxyFactory.removeAllProxies(member, proxyRegion);
            proxyRegion.localDestroyRegion();
            notifRegion.localDestroyRegion();
        }
        if (!this.cache.getDistributedSystem().getDistributedMember().equals(member)) {
            this.service.memberDeparted((InternalDistributedMember)member, crashed);
        }
        return member;
    }

    public void suspectMember(DistributedMember member, InternalDistributedMember whoSuspected, String reason) {
        this.service.memberSuspect((InternalDistributedMember)member, whoSuspected, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startManagingActivity() throws Exception {
        boolean isDebugEnabled = logger.isDebugEnabled();
        ArrayList<GIITask> giiTaskList = new ArrayList<GIITask>();
        for (DistributedMember distributedMember : this.cache.getDistributionManager().getOtherDistributionManagerIds()) {
            giiTaskList.add(new GIITask(distributedMember));
        }
        try {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation started  : ");
            }
            List futureTaskList = this.pooledMembershipExecutor.invokeAll(giiTaskList);
            for (Future future : futureTaskList) {
                String memberId = null;
                try {
                    DistributedMember returnedMember = (DistributedMember)future.get();
                    if (returnedMember != null) {
                        memberId = returnedMember.getId();
                    }
                    if (future.isDone() && isDebugEnabled) {
                        logger.debug("Monitoring Resource Created for : {}", (Object)memberId);
                    }
                    if (!future.isCancelled() || !isDebugEnabled) continue;
                    logger.debug("Monitoring resource Creation Failed for : {}", (Object)memberId);
                }
                catch (ExecutionException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("ExecutionException during Management GII: {}", (Object)e.getMessage(), (Object)e);
                }
                catch (CancellationException e) {
                    if (!isDebugEnabled) continue;
                    ManagementException mgEx = new ManagementException(e.fillInStackTrace());
                    logger.debug("InterruptedException while creating Monitoring resource with error : {}", (Object)mgEx.getMessage(), (Object)mgEx);
                }
            }
        }
        catch (InterruptedException e) {
            if (isDebugEnabled) {
                ManagementException managementException = new ManagementException(e.fillInStackTrace());
                logger.debug("InterruptedException while creating Monitoring resource with error : ", (Object)managementException.getMessage(), (Object)managementException);
            }
        }
        finally {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation completed");
            }
        }
    }

    public MBeanProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public long getLastUpdateTime(ObjectName objectName) {
        return this.proxyFactory.getLastUpdateTime(objectName);
    }

    public <T> T findProxy(ObjectName objectName, Class<T> interfaceClass) {
        return this.proxyFactory.findProxy(objectName, interfaceClass);
    }

    public Set<ObjectName> findAllProxies(DistributedMember member) {
        return this.proxyFactory.findAllProxies(member);
    }

    public MemberMessenger getMessenger() {
        return this.messenger;
    }

    @TestingOnly
    public void setMessenger(MemberMessenger messenger) {
        this.messenger = messenger;
    }

    @TestingOnly
    public synchronized Exception getAndResetLatestException() {
        return this.latestException.getAndSet(null);
    }

    private class GIITask
    implements Callable<DistributedMember> {
        private DistributedMember member;

        protected GIITask(DistributedMember member) {
            this.member = member;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public DistributedMember call() {
            DistributedMember distributedMember = this.member;
            synchronized (distributedMember) {
                block23: {
                    String appender = MBeanJMXAdapter.getUniqueIDForMember(this.member);
                    String monitoringRegionName = "_monitoringRegion_" + appender;
                    String notificationRegionName = "_notificationRegion_" + appender;
                    if (FederatingManager.this.cache.getRegion(monitoringRegionName) != null && FederatingManager.this.cache.getRegion(notificationRegionName) != null) {
                        return this.member;
                    }
                    try {
                        Region<NotificationKey, Notification> proxyNotificationRegion;
                        Region<String, Object> proxyMonitoringRegion;
                        if (Thread.currentThread().isInterrupted()) break block23;
                        InternalRegionArguments internalArgs = new InternalRegionArguments();
                        internalArgs.setIsUsedForMetaRegion(true);
                        HasCachePerfStats monitoringRegionStats = new HasCachePerfStats(){

                            @Override
                            public CachePerfStats getCachePerfStats() {
                                return new CachePerfStats(FederatingManager.this.cache.getDistributedSystem(), "managementRegionStats");
                            }
                        };
                        internalArgs.setCachePerfStatsHolder(monitoringRegionStats);
                        AttributesFactory<String, Object> monitorAttrFactory = new AttributesFactory<String, Object>();
                        monitorAttrFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                        monitorAttrFactory.setDataPolicy(DataPolicy.REPLICATE);
                        monitorAttrFactory.setConcurrencyChecksEnabled(false);
                        ManagementCacheListener mgmtCacheListener = new ManagementCacheListener(FederatingManager.this.proxyFactory);
                        monitorAttrFactory.addCacheListener(mgmtCacheListener);
                        RegionAttributes monitoringRegionAttrs = monitorAttrFactory.create();
                        AttributesFactory<NotificationKey, Notification> notifAttrFactory = new AttributesFactory<NotificationKey, Notification>();
                        notifAttrFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                        notifAttrFactory.setDataPolicy(DataPolicy.REPLICATE);
                        notifAttrFactory.setConcurrencyChecksEnabled(false);
                        notifAttrFactory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes(10, EvictionAction.LOCAL_DESTROY));
                        NotificationCacheListener notifListener = new NotificationCacheListener(FederatingManager.this.proxyFactory);
                        notifAttrFactory.addCacheListener(notifListener);
                        RegionAttributes notifRegionAttrs = notifAttrFactory.create();
                        boolean proxyMonitoringRegionCreated = false;
                        boolean proxyNotifRegionCreated = false;
                        try {
                            if (!FederatingManager.this.running) {
                                return null;
                            }
                            proxyMonitoringRegion = FederatingManager.this.cache.createVMRegion(monitoringRegionName, monitoringRegionAttrs, internalArgs);
                            proxyMonitoringRegionCreated = true;
                        }
                        catch (IOException | ClassNotFoundException | RegionExistsException | TimeoutException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Error During Internal Region creation {}", (Object)e.getMessage(), (Object)e);
                            }
                            throw new ManagementException(e);
                        }
                        try {
                            if (!FederatingManager.this.running) {
                                DistributedMember e = null;
                                return e;
                            }
                            proxyNotificationRegion = FederatingManager.this.cache.createVMRegion(notificationRegionName, notifRegionAttrs, internalArgs);
                            proxyNotifRegionCreated = true;
                        }
                        catch (IOException | ClassNotFoundException | RegionExistsException | TimeoutException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Error During Internal Region creation {}", (Object)e.getMessage(), (Object)e);
                            }
                            throw new ManagementException(e);
                        }
                        finally {
                            if (!proxyNotifRegionCreated && proxyMonitoringRegionCreated) {
                                proxyMonitoringRegion.localDestroyRegion();
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Management Region created with Name : {}", (Object)proxyMonitoringRegion.getName());
                            logger.debug("Notification Region created with Name : {}", (Object)proxyNotificationRegion.getName());
                        }
                        FederatingManager.this.repo.putEntryInMonitoringRegionMap(this.member, proxyMonitoringRegion);
                        FederatingManager.this.repo.putEntryInNotifRegionMap(this.member, proxyNotificationRegion);
                        try {
                            if (!FederatingManager.this.running) {
                                return null;
                            }
                            FederatingManager.this.proxyFactory.createAllProxies(this.member, proxyMonitoringRegion);
                            mgmtCacheListener.markReady();
                            notifListener.markReady();
                        }
                        catch (Exception e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Error During GII Proxy creation {}", (Object)e.getMessage(), (Object)e);
                            }
                            throw new ManagementException(e);
                        }
                    }
                    catch (Exception e) {
                        throw new ManagementException(e);
                    }
                }
                FederatingManager.this.service.memberJoined((InternalDistributedMember)this.member);
                FederatingManager.this.messenger.sendManagerInfo(this.member);
                return this.member;
            }
        }
    }

    private class RemoveMemberTask
    implements Runnable {
        private DistributedMember member;
        boolean crashed;

        protected RemoveMemberTask(DistributedMember member, boolean crashed) {
            this.member = member;
            this.crashed = crashed;
        }

        @Override
        public void run() {
            FederatingManager.this.removeMemberArtifacts(this.member, this.crashed);
        }
    }
}

