/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ConnectExceptions
extends GemFireCheckedException {
    private static final long serialVersionUID = -4173688946448867706L;
    private List<Throwable> causes = new ArrayList<Throwable>();
    private List<InternalDistributedMember> members = new ArrayList<InternalDistributedMember>();

    public ConnectExceptions() {
        super(LocalizedStrings.ConnectException_COULD_NOT_CONNECT.toLocalizedString());
    }

    public void addFailure(InternalDistributedMember member, Throwable cause) {
        this.members.add(member);
        this.causes.add(cause);
    }

    public List<InternalDistributedMember> getMembers() {
        return this.members;
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        for (InternalDistributedMember member : this.members) {
            sb.append(' ').append(member);
        }
        sb.append(" ").append(LocalizedStrings.ConnectException_CAUSES.toLocalizedString());
        for (Throwable cause : this.causes) {
            sb.append(" {").append(cause).append("}");
        }
        return LocalizedStrings.ConnectException_COULD_NOT_CONNECT_TO_0.toLocalizedString(sb);
    }
}

