/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.geode.GemFireException;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.io.RollingFileHandler;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.statistics.IgnoreResourceException;
import org.apache.geode.internal.statistics.ResourceInstance;
import org.apache.geode.internal.statistics.ResourceType;
import org.apache.geode.internal.statistics.SampleHandler;
import org.apache.geode.internal.statistics.StatArchiveHandler;
import org.apache.geode.internal.statistics.StatArchiveHandlerConfig;
import org.apache.geode.internal.statistics.StatMonitorHandler;
import org.apache.geode.internal.statistics.StatisticsSampler;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class SampleCollector {
    private static final Logger logger = LogService.getLogger();
    private static SampleCollector instance;
    private final StatisticsSampler sampler;
    private final SampleHandlers sampleHandlers = new SampleHandlers();
    private final Map<StatisticsType, ResourceType> resourceTypeMap = new HashMap<StatisticsType, ResourceType>();
    private final Map<Statistics, ResourceInstance> resourceInstMap = new HashMap<Statistics, ResourceInstance>();
    private int resourceTypeId = 0;
    private int resourceInstId = 0;
    private int statResourcesModCount;
    private StatArchiveHandler statArchiveHandler;
    private StatMonitorHandler statMonitorHandler;

    public SampleCollector(StatisticsSampler sampler) {
        this.sampler = sampler;
        this.statResourcesModCount = sampler.getStatisticsModCount() == 0 ? -1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StatMonitorHandler getStatMonitorHandler() {
        Class<SampleCollector> clazz = SampleCollector.class;
        synchronized (SampleCollector.class) {
            if (instance == null) {
                throw new IllegalStateException("Statistics sampler is not available");
            }
            SampleHandlers sampleHandlers = SampleCollector.instance.sampleHandlers;
            synchronized (sampleHandlers) {
                StatMonitorHandler handler = SampleCollector.instance.statMonitorHandler;
                if (handler == null) {
                    handler = new StatMonitorHandler();
                    instance.addSampleHandler(handler);
                    SampleCollector.instance.statMonitorHandler = handler;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                // ** MonitorExit[var0] (shouldn't be in output)
                return handler;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="There is never more than one SampleCollector instance.")
    public void initialize(StatArchiveHandlerConfig config, long nanosTimeStamp, RollingFileHandler rollingFileHandler) {
        Class<SampleCollector> clazz = SampleCollector.class;
        synchronized (SampleCollector.class) {
            instance = this;
            SampleHandlers sampleHandlers = this.sampleHandlers;
            synchronized (sampleHandlers) {
                StatArchiveHandler newStatArchiveHandler;
                this.statArchiveHandler = newStatArchiveHandler = new StatArchiveHandler(config, this, rollingFileHandler);
                this.addSampleHandler(newStatArchiveHandler);
                newStatArchiveHandler.initialize(nanosTimeStamp);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Class<SampleCollector> clazz = SampleCollector.class;
        synchronized (SampleCollector.class) {
            SampleHandlers sampleHandlers = this.sampleHandlers;
            synchronized (sampleHandlers) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance == this;
            }
        }
    }

    public void addSampleHandler(SampleHandler handler) {
        this.sampleHandlers.addSampleHandler(handler);
    }

    public void removeSampleHandler(SampleHandler handler) {
        this.sampleHandlers.removeSampleHandler(handler);
    }

    public boolean containsSampleHandler(SampleHandler handler) {
        return this.sampleHandlers.contains(handler);
    }

    public void sample(long nanosTimeStamp) {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#sample nanosTimeStamp={}", (Object)nanosTimeStamp);
        }
        List<MarkableSampleHandler> handlers = this.sampleHandlers.currentHandlers();
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#sample handlers={}", handlers);
        }
        this.sampleResources(handlers);
        ArrayList<ResourceInstance> updatedResources = new ArrayList<ResourceInstance>();
        for (ResourceInstance ri : this.resourceInstMap.values()) {
            StatisticDescriptor[] stats = ri.getResourceType().getStatisticDescriptors();
            if (ri.getStatistics().isClosed()) continue;
            int[] updatedStats = new int[stats.length];
            long[] statValues = ri.getPreviousStatValues();
            if (statValues == null) {
                statValues = new long[stats.length];
                for (int i = 0; i < stats.length; ++i) {
                    statValues[i] = ri.getRawStatValue(stats[i]);
                    updatedStats[i] = i;
                }
            } else {
                statValues = Arrays.copyOf(statValues, statValues.length);
                int updatedStatsIdx = 0;
                for (int i = 0; i < stats.length; ++i) {
                    long value = ri.getRawStatValue(stats[i]);
                    if (value == statValues[i]) continue;
                    statValues[i] = value;
                    updatedStats[updatedStatsIdx] = i;
                    ++updatedStatsIdx;
                }
                updatedStats = Arrays.copyOf(updatedStats, updatedStatsIdx);
            }
            ri.setUpdatedStats(updatedStats);
            ri.setLatestStatValues(statValues);
            updatedResources.add(ri);
        }
        try {
            this.notifyAllHandlersOfSample(handlers, updatedResources, nanosTimeStamp);
        }
        catch (IllegalArgumentException e) {
            logger.warn(LogMarker.STATISTICS_MARKER, "Use of java.lang.System.nanoTime() resulted in a non-positive timestamp delta. Skipping notification of statistics sample.", (Throwable)e);
        }
        for (ResourceInstance ri : updatedResources) {
            ri.setPreviousStatValues(ri.getLatestStatValues());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<SampleCollector> clazz = SampleCollector.class;
        synchronized (SampleCollector.class) {
            SampleHandlers sampleHandlers = this.sampleHandlers;
            synchronized (sampleHandlers) {
                SampleHandler handler;
                if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
                    logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#close");
                }
                try {
                    handler = this.statArchiveHandler;
                    if (handler != null) {
                        ((StatArchiveHandler)handler).close();
                    }
                }
                catch (GemFireException ignore) {
                    logger.warn(LogMarker.STATISTICS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.HostStatSampler_STATISTIC_ARCHIVER_SHUTDOWN_FAILED_BECAUSE__0, ignore.getMessage()));
                }
                handler = this.statMonitorHandler;
                if (handler != null) {
                    ((StatMonitorHandler)handler).close();
                }
            }
            if (instance == this) {
                instance = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeArchive(File newFile, long nanosTimeStamp) {
        SampleHandlers sampleHandlers = this.sampleHandlers;
        synchronized (sampleHandlers) {
            StatArchiveHandler handler;
            if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#changeArchive newFile={}, nanosTimeStamp={}", (Object)newFile, (Object)nanosTimeStamp);
            }
            if ((handler = this.statArchiveHandler) != null) {
                handler.changeArchiveFile(newFile, nanosTimeStamp);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("sampler=").append(this.sampler);
        sb.append(", statResourcesModCount=").append(this.statResourcesModCount);
        sb.append(", resourceTypeId=").append(this.resourceTypeId);
        sb.append(", resourceInstId=").append(this.resourceInstId);
        sb.append(", resourceTypeMap.size()=").append(this.resourceTypeMap.size());
        sb.append(", resourceInstMap.size()=").append(this.resourceInstMap.size());
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatArchiveHandler getStatArchiveHandler() {
        SampleHandlers sampleHandlers = this.sampleHandlers;
        synchronized (sampleHandlers) {
            return this.statArchiveHandler;
        }
    }

    protected List<MarkableSampleHandler> currentHandlersForTesting() {
        return this.sampleHandlers.currentHandlers();
    }

    private void sampleResources(List<MarkableSampleHandler> handlers) {
        int newModCount;
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#sampleResources handlers={}", handlers);
        }
        if (this.statResourcesModCount != (newModCount = this.sampler.getStatisticsModCount())) {
            this.statResourcesModCount = newModCount;
            int ignoreCount = 0;
            Statistics[] resources = this.sampler.getStatistics();
            for (int i = 0; i < resources.length; ++i) {
                Statistics statistics = resources[i];
                if (this.resourceInstMap.containsKey(statistics)) continue;
                try {
                    ResourceType type = this.getResourceType(handlers, statistics);
                    ResourceInstance resource = this.allocateResourceInstance(type, statistics);
                    this.notifyOldHandlersOfResource(handlers, resource);
                    continue;
                }
                catch (IgnoreResourceException ex) {
                    ++ignoreCount;
                }
            }
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#sampleResources resources.length={}, ignoreCount={}", (Object)resources.length, (Object)ignoreCount);
            }
            List<ResourceInstance> ri = this.cleanupResources(resources, ignoreCount);
            this.notifyOldHandlers(handlers, ri);
        }
        this.notifyNewHandlersOfResources(handlers, this.resourceTypeMap.values(), this.resourceInstMap.values());
    }

    private ResourceType getResourceType(List<MarkableSampleHandler> handlers, Statistics statistics) throws IgnoreResourceException {
        StatisticsType type;
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#getResourceType statistics={}", (Object)statistics);
        }
        if ((type = statistics.getType()) == null) {
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#getResourceType type={}, throwing IgnoreResourceException", (Object)type);
            }
            throw new IgnoreResourceException();
        }
        ResourceType resourceType = null;
        try {
            resourceType = this.resourceTypeMap.get(type);
        }
        catch (NullPointerException ex) {
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#getResourceType resourceTypeMap.get threw NPE, throwing NullPointerException");
            }
            throw new IgnoreResourceException();
        }
        if (resourceType == null) {
            resourceType = this.allocateResourceType(handlers, type);
            this.notifyOldHandlersOfResourceType(handlers, resourceType);
        }
        return resourceType;
    }

    private ResourceType allocateResourceType(List<MarkableSampleHandler> handlers, StatisticsType type) throws IgnoreResourceException {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#allocateResourceType type={}", (Object)type);
        }
        ResourceType resourceType = new ResourceType(this.resourceTypeId, type);
        this.resourceTypeMap.put(type, resourceType);
        ++this.resourceTypeId;
        return resourceType;
    }

    private ResourceInstance allocateResourceInstance(ResourceType type, Statistics s) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#allocateResourceInstance type={}, s={}", (Object)type, (Object)s);
        }
        ResourceInstance resourceInstance = new ResourceInstance(this.resourceInstId, s, type);
        this.resourceInstMap.put(s, resourceInstance);
        ++this.resourceInstId;
        return resourceInstance;
    }

    private List<ResourceInstance> cleanupResources(Statistics[] resources, int ignoreCount) {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#cleanupResources resources.length={}, ignoreCount={}", (Object)resources.length, (Object)ignoreCount);
        }
        int resourcesToDelete = this.resourceInstMap.size() - (resources.length - ignoreCount);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#cleanupResources resourcesToDelete={}", (Object)resourcesToDelete);
        }
        if (resourcesToDelete == 0) {
            return Collections.emptyList();
        }
        ArrayList<ResourceInstance> resourcesRemoved = new ArrayList<ResourceInstance>();
        List<Statistics> resourceList = Arrays.asList(resources);
        Iterator<Map.Entry<Statistics, ResourceInstance>> it = this.resourceInstMap.entrySet().iterator();
        while (it.hasNext() && resourcesToDelete > 0) {
            Map.Entry<Statistics, ResourceInstance> e = it.next();
            Statistics key = e.getKey();
            if (resourceList.contains(key)) continue;
            key.close();
            ResourceInstance inst = e.getValue();
            resourcesRemoved.add(inst);
            --resourcesToDelete;
            it.remove();
        }
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#cleanupResources resourcesRemoved={}", resourcesRemoved);
        }
        return resourcesRemoved;
    }

    private void notifyAllHandlersOfSample(List<MarkableSampleHandler> handlers, List<ResourceInstance> updatedResources, long nanosTimeStamp) {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyAllHandlersOfSample timeStamp={}", (Object)nanosTimeStamp);
        }
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyAllHandlersOfSample updatedResources.size()={}, handlers={}", (Object)updatedResources.size(), handlers);
        }
        for (MarkableSampleHandler handler : handlers) {
            handler.sampled(nanosTimeStamp, Collections.unmodifiableList(updatedResources));
        }
    }

    private void notifyNewHandlersOfResources(List<MarkableSampleHandler> handlers, Collection<ResourceType> types, Collection<ResourceInstance> resources) {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyNewHandlersOfResources ri.size()={}", (Object)resources.size());
        }
        int count = 0;
        for (MarkableSampleHandler handler : handlers) {
            if (handler.isMarked()) continue;
            ArrayList<ResourceType> allocatedResourceTypes = new ArrayList<ResourceType>();
            for (ResourceInstance resourceInstance : resources) {
                ResourceType resourceType = resourceInstance.getResourceType();
                if (!allocatedResourceTypes.contains(resourceType)) {
                    handler.allocatedResourceType(resourceType);
                    allocatedResourceTypes.add(resourceType);
                }
                handler.allocatedResourceInstance(resourceInstance);
            }
            for (ResourceType resourceType : types) {
                if (allocatedResourceTypes.contains(resourceType)) continue;
                handler.allocatedResourceType(resourceType);
            }
            handler.mark();
            ++count;
        }
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyNewHandlersOfResources notified {} new handlers", (Object)count);
        }
    }

    private void notifyOldHandlersOfResource(List<MarkableSampleHandler> handlers, ResourceInstance resource) {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyOldHandlersOfResource resource={}", (Object)resource);
        }
        int count = 0;
        for (MarkableSampleHandler handler : handlers) {
            if (!handler.isMarked()) continue;
            handler.allocatedResourceInstance(resource);
            ++count;
        }
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyOldHandlersOfResource notified {} old handlers", (Object)count);
        }
    }

    private void notifyOldHandlersOfResourceType(List<MarkableSampleHandler> handlers, ResourceType type) {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyOldHandlersOfResourceType type={}", (Object)type);
        }
        int count = 0;
        for (MarkableSampleHandler handler : handlers) {
            if (!handler.isMarked()) continue;
            handler.allocatedResourceType(type);
            ++count;
        }
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyOldHandlersOfResourceType notified {} old handlers", (Object)count);
        }
    }

    private void notifyOldHandlers(List<MarkableSampleHandler> handlers, List<ResourceInstance> ri) {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyOldHandlers ri={}", ri);
        }
        int count = 0;
        for (ResourceInstance resource : ri) {
            for (MarkableSampleHandler handler : handlers) {
                if (!handler.isMarked()) continue;
                handler.destroyedResourceInstance(resource);
                ++count;
            }
        }
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleCollector#notifyOldHandlers notified {} old handlers", (Object)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatMonitorHandler getStatMonitorHandlerSnapshot() {
        SampleHandlers sampleHandlers = this.sampleHandlers;
        synchronized (sampleHandlers) {
            return this.statMonitorHandler;
        }
    }

    public class SampleHandlers
    implements Iterable<MarkableSampleHandler> {
        private volatile List<MarkableSampleHandler> currentHandlers = Collections.emptyList();

        public MarkableSampleHandler getMarkableSampleHandler(SampleHandler handler) {
            if (this.contains(handler)) {
                for (MarkableSampleHandler markableSamplerHandler : this.currentHandlers()) {
                    if (markableSamplerHandler.sampleHandler != handler) continue;
                    return markableSamplerHandler;
                }
            }
            return null;
        }

        public boolean contains(SampleHandler handler) {
            MarkableSampleHandler markableHandler = new MarkableSampleHandler(handler);
            return this.currentHandlers.contains(markableHandler);
        }

        public List<MarkableSampleHandler> currentHandlers() {
            return this.currentHandlers;
        }

        @Override
        public Iterator<MarkableSampleHandler> iterator() {
            return this.currentHandlers.iterator();
        }

        public Iterator<MarkableSampleHandler> markedIterator() {
            return new MarkableIterator(true);
        }

        public Iterator<MarkableSampleHandler> unmarkedIterator() {
            return new MarkableIterator(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addSampleHandler(SampleHandler handler) {
            SampleHandlers sampleHandlers = this;
            synchronized (sampleHandlers) {
                boolean added = false;
                MarkableSampleHandler markableHandler = new MarkableSampleHandler(handler);
                List<MarkableSampleHandler> oldHandlers = this.currentHandlers;
                if (!oldHandlers.contains(markableHandler)) {
                    if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
                        logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleHandlers#addSampleHandler adding markableHandler to {}", (Object)this);
                    }
                    ArrayList<MarkableSampleHandler> newHandlers = new ArrayList<MarkableSampleHandler>(oldHandlers);
                    added = newHandlers.add(markableHandler);
                    this.currentHandlers = Collections.unmodifiableList(newHandlers);
                }
                return added;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSampleHandler(SampleHandler handler) {
            SampleHandlers sampleHandlers = this;
            synchronized (sampleHandlers) {
                boolean removed = false;
                MarkableSampleHandler markableHandler = new MarkableSampleHandler(handler);
                List<MarkableSampleHandler> oldHandlers = this.currentHandlers;
                if (oldHandlers.contains(markableHandler)) {
                    if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
                        logger.trace(LogMarker.STATISTICS_VERBOSE, "SampleHandlers#removeSampleHandler removing markableHandler from {}", (Object)this);
                    }
                    ArrayList<MarkableSampleHandler> newHandlers = new ArrayList<MarkableSampleHandler>(oldHandlers);
                    removed = newHandlers.remove(markableHandler);
                    this.currentHandlers = Collections.unmodifiableList(newHandlers);
                }
                return removed;
            }
        }

        protected int countMarkableSampleHandlers(SampleHandler handler) {
            int count = 0;
            List<MarkableSampleHandler> list = this.currentHandlers();
            for (MarkableSampleHandler wrapper : list) {
                if (wrapper.getSampleHandler() != handler) continue;
                ++count;
            }
            return count;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("@").append(System.identityHashCode(this)).append("{");
            sb.append("currentHandlers=").append(this.currentHandlers);
            return sb.toString();
        }

        private class MarkableIterator
        implements Iterator<MarkableSampleHandler> {
            private final Iterator<MarkableSampleHandler> iterator;

            public MarkableIterator(boolean marked) {
                ArrayList<MarkableSampleHandler> matchingHandlers = new ArrayList<MarkableSampleHandler>();
                List<MarkableSampleHandler> handlers = SampleHandlers.this.currentHandlers();
                for (MarkableSampleHandler handler : handlers) {
                    if (handler.isMarked() != marked) continue;
                    matchingHandlers.add(handler);
                }
                this.iterator = matchingHandlers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public MarkableSampleHandler next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove operation is not supported");
            }
        }
    }

    public class MarkableSampleHandler
    implements SampleHandler {
        private final SampleHandler sampleHandler;
        private boolean mark = false;

        public MarkableSampleHandler(SampleHandler sampleHandler) {
            if (sampleHandler == null) {
                throw new NullPointerException("SampleHandler is null");
            }
            this.sampleHandler = sampleHandler;
        }

        public boolean isMarked() {
            if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "MarkableSampleHandler#isMarked returning {} for {}", (Object)this.mark, (Object)this);
            }
            return this.mark;
        }

        public void mark() {
            if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "MarkableSampleHandler#mark marking {}", (Object)this);
            }
            this.mark = true;
        }

        public SampleHandler getSampleHandler() {
            return this.sampleHandler;
        }

        @Override
        public void sampled(long nanosTimeStamp, List<ResourceInstance> resourceInstances) {
            this.sampleHandler.sampled(nanosTimeStamp, resourceInstances);
        }

        @Override
        public void allocatedResourceType(ResourceType resourceType) {
            this.sampleHandler.allocatedResourceType(resourceType);
        }

        @Override
        public void allocatedResourceInstance(ResourceInstance resourceInstance) {
            this.sampleHandler.allocatedResourceInstance(resourceInstance);
        }

        @Override
        public void destroyedResourceInstance(ResourceInstance resourceInstance) {
            this.sampleHandler.destroyedResourceInstance(resourceInstance);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.sampleHandler.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MarkableSampleHandler other = (MarkableSampleHandler)obj;
            return this.sampleHandler == other.sampleHandler;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("@").append(System.identityHashCode(this)).append("{");
            sb.append("mark=").append(this.mark);
            sb.append(", sampleHandler=").append(this.sampleHandler);
            return sb.toString();
        }
    }
}

