/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.size;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.size.CachingSingleObjectSizer;
import org.apache.geode.internal.size.ObjectTraverser;
import org.apache.geode.internal.size.ReflectionSingleObjectSizer;
import org.apache.geode.internal.size.SingleObjectSizer;

public class ObjectGraphSizer {
    private static final String SIZE_OF_CLASS_NAME = System.getProperty("gemfire.ObjectSizer.SIZE_OF_CLASS", ReflectionSingleObjectSizer.class.getName());
    static final SingleObjectSizer SIZE_OF_UTIL;
    private static ObjectFilter NULL_FILTER;

    public static long size(Object root) throws IllegalArgumentException, IllegalAccessException {
        return ObjectGraphSizer.size(root, false);
    }

    public static long size(Object root, boolean includeStatics) throws IllegalArgumentException, IllegalAccessException {
        return ObjectGraphSizer.size(root, NULL_FILTER, includeStatics);
    }

    public static long size(Object root, ObjectFilter filter, boolean includeStatics) throws IllegalArgumentException, IllegalAccessException {
        SizeVisitor visitor = new SizeVisitor(filter);
        ObjectTraverser.breadthFirstSearch(root, visitor, includeStatics);
        return visitor.getTotalSize();
    }

    public static String histogram(Object root, boolean includeStatics) throws IllegalArgumentException, IllegalAccessException {
        return ObjectGraphSizer.histogram(root, NULL_FILTER, includeStatics);
    }

    public static String histogram(Object root, ObjectFilter filter, boolean includeStatics) throws IllegalArgumentException, IllegalAccessException {
        HistogramVistor visitor = new HistogramVistor(filter);
        ObjectTraverser.breadthFirstSearch(root, visitor, includeStatics);
        return visitor.dump();
    }

    private ObjectGraphSizer() {
    }

    static {
        NULL_FILTER = new ObjectFilter(){

            @Override
            public boolean accept(Object parent, Object object) {
                return true;
            }
        };
        try {
            Class<?> sizeOfClass = ClassPathLoader.getLatest().forName(SIZE_OF_CLASS_NAME);
            SIZE_OF_UTIL = new CachingSingleObjectSizer((SingleObjectSizer)sizeOfClass.newInstance());
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static interface ObjectFilter {
        public boolean accept(Object var1, Object var2);
    }

    private static class SizeVisitor
    implements ObjectTraverser.Visitor {
        private long totalSize;
        private final ObjectFilter filter;

        public SizeVisitor(ObjectFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean visit(Object parent, Object object) {
            if (!this.filter.accept(parent, object)) {
                return false;
            }
            this.totalSize += SIZE_OF_UTIL.sizeof(object);
            return !(object instanceof WeakReference) && !(object instanceof SoftReference);
        }

        public long getTotalSize() {
            return this.totalSize;
        }
    }

    private static class HistogramVistor
    implements ObjectTraverser.Visitor {
        private final Map<Class, Integer> countHisto = new HashMap<Class, Integer>();
        private final Map<Class, Long> sizeHisto = new HashMap<Class, Long>();
        private final ObjectFilter filter;

        public HistogramVistor(ObjectFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean visit(Object parent, Object object) {
            long objectSize;
            if (!this.filter.accept(parent, object)) {
                return false;
            }
            Integer count = this.countHisto.get(object.getClass());
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            this.countHisto.put(object.getClass(), count);
            try {
                objectSize = SIZE_OF_UTIL.sizeof(object);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            Long size = this.sizeHisto.get(object.getClass());
            size = size == null ? Long.valueOf(objectSize) : Long.valueOf(size + objectSize);
            this.sizeHisto.put(object.getClass(), size);
            return true;
        }

        public String dump() {
            StringBuilder result = new StringBuilder();
            result.append("clazz\tsize\tcount\n");
            Set<HistogramEntry> orderedSize = this.getOrderedSet();
            for (HistogramEntry entry : orderedSize) {
                Class clazz = entry.clazz;
                Integer count = entry.count;
                Long size = entry.size;
                result.append(clazz + "\t" + size + "\t" + count + "\n");
            }
            return result.toString();
        }

        public Set<HistogramEntry> getOrderedSet() {
            TreeSet<HistogramEntry> result = new TreeSet<HistogramEntry>();
            for (Map.Entry<Class, Long> entry : this.sizeHisto.entrySet()) {
                Class clazz = entry.getKey();
                Long size = entry.getValue();
                Integer count = this.countHisto.get(clazz);
                result.add(new HistogramEntry(clazz, count, size));
            }
            return result;
        }

        private static class HistogramEntry
        implements Comparable<HistogramEntry> {
            private final Class clazz;
            private final Integer count;
            private final Long size;

            public HistogramEntry(Class clazz, Integer count, Long size) {
                this.size = size;
                this.clazz = clazz;
                this.count = count;
            }

            @Override
            public int compareTo(HistogramEntry o) {
                int diff = this.size.compareTo(o.size);
                if (diff == 0) {
                    diff = this.clazz.getName().compareTo(o.clazz.getName());
                }
                return diff;
            }

            public String toString() {
                return this.size.toString();
            }
        }
    }
}

