/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.lang.Validate;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.ControlFileWatchdog;
import org.apache.geode.internal.process.ControlNotificationHandler;
import org.apache.geode.internal.process.FileAlreadyExistsException;
import org.apache.geode.internal.process.LocalProcessLauncher;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessType;
import org.apache.logging.log4j.Logger;

public class ControllableProcess {
    private static final Logger logger = LogService.getLogger();
    private final File directory;
    private final LocalProcessLauncher launcher;
    private final ControlFileWatchdog stopRequestFileWatchdog;
    private final ControlFileWatchdog statusRequestFileWatchdog;

    public ControllableProcess(ControlNotificationHandler handler, File directory, ProcessType processType, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this(directory, processType, force, ControllableProcess.createPidFile(directory, processType), ControllableProcess.createStopHandler(handler), ControllableProcess.createStatusHandler(handler, directory, processType));
    }

    private ControllableProcess(File directory, ProcessType processType, boolean force, File pidFile, ControlFileWatchdog.ControlRequestHandler stopHandler, ControlFileWatchdog.ControlRequestHandler statusHandler) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this(directory, processType, ControllableProcess.createLocalProcessLauncher(pidFile, force), ControllableProcess.createStopRequestFileWatchdog(directory, processType, stopHandler), ControllableProcess.createStatusRequestFileWatchdog(directory, processType, statusHandler));
    }

    ControllableProcess(File directory, ProcessType processType, LocalProcessLauncher launcher, ControlFileWatchdog stopRequestFileWatchdog, ControlFileWatchdog statusRequestFileWatchdog) {
        Validate.notNull((Object)directory, (String)("Invalid directory '" + directory + "' specified"));
        Validate.notNull((Object)((Object)processType), (String)("Invalid processType '" + (Object)((Object)processType) + "' specified"));
        Validate.notNull((Object)launcher, (String)("Invalid launcher '" + launcher + "' specified"));
        Validate.notNull((Object)stopRequestFileWatchdog, (String)("Invalid stopRequestFileWatchdog '" + stopRequestFileWatchdog + "' specified"));
        Validate.notNull((Object)statusRequestFileWatchdog, (String)("Invalid statusRequestFileWatchdog '" + statusRequestFileWatchdog + "' specified"));
        this.directory = directory;
        this.launcher = launcher;
        this.stopRequestFileWatchdog = stopRequestFileWatchdog;
        this.statusRequestFileWatchdog = statusRequestFileWatchdog;
        this.deleteFiles(directory, processType);
        stopRequestFileWatchdog.start();
        statusRequestFileWatchdog.start();
    }

    public int getPid() {
        return this.launcher.getPid();
    }

    public File getPidFile() {
        return this.launcher.getPidFile();
    }

    public File getDirectory() {
        return this.directory;
    }

    public void stop() {
        boolean interrupted = false;
        try {
            interrupted = this.stop(this.statusRequestFileWatchdog);
            interrupted = this.stop(this.stopRequestFileWatchdog) || interrupted;
            this.launcher.close();
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void stop(boolean deletePidFileOnStop) {
        boolean interrupted = false;
        try {
            interrupted = this.stop(this.statusRequestFileWatchdog);
            interrupted = this.stop(this.stopRequestFileWatchdog) || interrupted;
            this.launcher.close(deletePidFileOnStop);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean stop(ControlFileWatchdog fileWatchdog) {
        boolean interrupted = false;
        try {
            fileWatchdog.stop();
        }
        catch (InterruptedException e) {
            interrupted = true;
            logger.warn("Interrupted while stopping status handler for controllable process.", (Throwable)e);
        }
        return interrupted;
    }

    private void deleteFiles(File directory, ProcessType processType) {
        try {
            ControllableProcess.deleteFileWithValidation(new File(directory, processType.getStatusRequestFileName()), "statusRequestFile");
            ControllableProcess.deleteFileWithValidation(new File(directory, processType.getStatusFileName()), "statusFile");
            ControllableProcess.deleteFileWithValidation(new File(directory, processType.getStopRequestFileName()), "stopRequestFile");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static File createPidFile(File directory, ProcessType processType) {
        return new File(directory, processType.getPidFileName());
    }

    private static LocalProcessLauncher createLocalProcessLauncher(File pidFile, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        return new LocalProcessLauncher(pidFile, force);
    }

    private static ControlFileWatchdog.ControlRequestHandler createStopHandler(ControlNotificationHandler handler) {
        return handler::handleStop;
    }

    private static ControlFileWatchdog.ControlRequestHandler createStatusHandler(ControlNotificationHandler handler, File directory, ProcessType processType) {
        return () -> ControllableProcess.writeStatusToFile(ControllableProcess.fetchStatusWithValidation(handler), directory, processType);
    }

    private static ControlFileWatchdog createStopRequestFileWatchdog(File directory, ProcessType processType, ControlFileWatchdog.ControlRequestHandler stopHandler) {
        return new ControlFileWatchdog(directory, processType.getStopRequestFileName(), stopHandler, false);
    }

    private static ControlFileWatchdog createStatusRequestFileWatchdog(File directory, ProcessType processType, ControlFileWatchdog.ControlRequestHandler statusHandler) {
        return new ControlFileWatchdog(directory, processType.getStatusRequestFileName(), statusHandler, false);
    }

    private static String fetchStatusWithValidation(ControlNotificationHandler handler) {
        AbstractLauncher.ServiceState<?> state = handler.handleStatus();
        if (state == null) {
            throw new IllegalStateException("Null ServiceState is invalid");
        }
        String jsonContent = state.toJson();
        if (jsonContent == null) {
            throw new IllegalStateException("Null JSON for status is invalid");
        }
        if (jsonContent.isEmpty()) {
            throw new IllegalStateException("Empty JSON for status is invalid");
        }
        return jsonContent;
    }

    private static void deleteFileWithValidation(File file, String fileNameForMessage) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Unable to delete " + fileNameForMessage + "'" + file.getCanonicalPath() + "'");
        }
    }

    private static void writeStatusToFile(String jsonContent, File directory, ProcessType processType) throws IOException {
        File statusFile = new File(directory, processType.getStatusFileName());
        File statusFileTmp = new File(directory, processType.getStatusFileName() + ".tmp");
        ControllableProcess.deleteFileWithValidation(statusFile, "statusFile");
        ControllableProcess.deleteFileWithValidation(statusFileTmp, "statusFileTmp");
        if (!statusFileTmp.createNewFile()) {
            throw new IOException("Unable to create statusFileTmp '" + statusFileTmp.getCanonicalPath() + "'");
        }
        FileWriter writer = new FileWriter(statusFileTmp);
        writer.write(jsonContent);
        writer.flush();
        writer.close();
        if (!statusFileTmp.renameTo(statusFile)) {
            throw new IOException("Unable to rename statusFileTmp '" + statusFileTmp.getCanonicalPath() + "' to '" + statusFile.getCanonicalPath() + "'");
        }
    }
}

