/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.security.SecurableCommunicationChannel;

public class SSLConfigurationFactory {
    public static final String JAVAX_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String JAVAX_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String JAVAX_TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    private static SSLConfigurationFactory instance = new SSLConfigurationFactory();
    private DistributionConfig distributionConfig = null;
    private Map<SecurableCommunicationChannel, SSLConfig> registeredSSLConfig = new HashMap<SecurableCommunicationChannel, SSLConfig>();

    private SSLConfigurationFactory() {
    }

    private static synchronized SSLConfigurationFactory getInstance() {
        if (instance == null) {
            instance = new SSLConfigurationFactory();
        }
        return instance;
    }

    private DistributionConfig getDistributionConfig() {
        if (this.distributionConfig == null) {
            throw new GemFireConfigException("SSL Configuration requires a valid distribution config.");
        }
        return this.distributionConfig;
    }

    public static void setDistributionConfig(DistributionConfig distributionConfig) {
        if (distributionConfig == null) {
            throw new GemFireConfigException("SSL Configuration requires a valid distribution config.");
        }
        SSLConfigurationFactory.getInstance().distributionConfig = distributionConfig;
    }

    @Deprecated
    public static SSLConfig getSSLConfigForComponent(SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig sslConfig = SSLConfigurationFactory.getInstance().getRegisteredSSLConfigForComponent(sslEnabledComponent);
        if (sslConfig == null) {
            sslConfig = SSLConfigurationFactory.getInstance().createSSLConfigForComponent(sslEnabledComponent);
            SSLConfigurationFactory.getInstance().registeredSSLConfigForComponent(sslEnabledComponent, sslConfig);
        }
        return sslConfig;
    }

    private synchronized void registeredSSLConfigForComponent(SecurableCommunicationChannel sslEnabledComponent, SSLConfig sslConfig) {
        this.registeredSSLConfig.put(sslEnabledComponent, sslConfig);
    }

    private SSLConfig createSSLConfigForComponent(SecurableCommunicationChannel sslEnabledComponent) {
        return this.createSSLConfigForComponent(this.getDistributionConfig(), sslEnabledComponent);
    }

    private SSLConfig createSSLConfigForComponent(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig sslConfig = this.createSSLConfig(distributionConfig, sslEnabledComponent);
        SecurableCommunicationChannel[] sslEnabledComponents = distributionConfig.getSecurableCommunicationChannels();
        if (sslEnabledComponents.length == 0) {
            sslConfig = this.configureLegacyClusterSSL(distributionConfig, sslConfig);
        }
        sslConfig.setSecurableCommunicationChannel(sslEnabledComponent);
        switch (sslEnabledComponent) {
            case ALL: {
                this.createSSLConfigForComponent(distributionConfig, SecurableCommunicationChannel.WEB);
                break;
            }
            case CLUSTER: {
                if (sslEnabledComponents.length > 0) {
                    sslConfig = this.setAliasForComponent(sslConfig, distributionConfig.getClusterSSLAlias());
                    break;
                }
                sslConfig = this.configureLegacyClusterSSL(distributionConfig, sslConfig);
                break;
            }
            case LOCATOR: {
                if (sslEnabledComponents.length <= 0) break;
                sslConfig = this.setAliasForComponent(sslConfig, distributionConfig.getLocatorSSLAlias());
                break;
            }
            case SERVER: {
                if (sslEnabledComponents.length > 0) {
                    sslConfig = this.setAliasForComponent(sslConfig, distributionConfig.getServerSSLAlias());
                    break;
                }
                sslConfig = this.configureLegacyServerSSL(distributionConfig, sslConfig);
                break;
            }
            case GATEWAY: {
                if (sslEnabledComponents.length > 0) {
                    sslConfig = this.setAliasForComponent(sslConfig, distributionConfig.getGatewaySSLAlias());
                    break;
                }
                sslConfig = this.configureLegacyGatewaySSL(distributionConfig, sslConfig);
                break;
            }
            case WEB: {
                if (sslEnabledComponents.length > 0) {
                    sslConfig = this.setAliasForComponent(sslConfig, distributionConfig.getHTTPServiceSSLAlias());
                    sslConfig.setRequireAuth(distributionConfig.getSSLWebRequireAuthentication());
                    break;
                }
                sslConfig = this.configureLegacyHttpServiceSSL(distributionConfig, sslConfig);
                break;
            }
            case JMX: {
                sslConfig = sslEnabledComponents.length > 0 ? this.setAliasForComponent(sslConfig, distributionConfig.getJMXSSLAlias()) : this.configureLegacyJMXSSL(distributionConfig, sslConfig);
            }
        }
        this.configureSSLPropertiesFromSystemProperties(sslConfig);
        return sslConfig;
    }

    private SSLConfig setAliasForComponent(SSLConfig sslConfig, String clusterSSLAlias) {
        if (!StringUtils.isEmpty((String)clusterSSLAlias)) {
            sslConfig.setAlias(clusterSSLAlias);
        }
        return sslConfig;
    }

    private SSLConfig createSSLConfig(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig sslConfig = new SSLConfig();
        sslConfig.setCiphers(distributionConfig.getSSLCiphers());
        sslConfig.setEndpointIdentificationEnabled(distributionConfig.getSSLEndpointIdentificationEnabled());
        sslConfig.setEnabled(this.determineIfSSLEnabledForSSLComponent(distributionConfig, sslEnabledComponent));
        sslConfig.setKeystore(distributionConfig.getSSLKeyStore());
        sslConfig.setKeystorePassword(distributionConfig.getSSLKeyStorePassword());
        sslConfig.setKeystoreType(distributionConfig.getSSLKeyStoreType());
        sslConfig.setTruststore(distributionConfig.getSSLTrustStore());
        sslConfig.setTruststorePassword(distributionConfig.getSSLTrustStorePassword());
        sslConfig.setTruststoreType(distributionConfig.getSSLTrustStoreType());
        sslConfig.setProtocols(distributionConfig.getSSLProtocols());
        sslConfig.setRequireAuth(distributionConfig.getSSLRequireAuthentication());
        sslConfig.setAlias(distributionConfig.getSSLDefaultAlias());
        return sslConfig;
    }

    private boolean determineIfSSLEnabledForSSLComponent(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        if (ArrayUtils.contains((Object[])distributionConfig.getSecurableCommunicationChannels(), (Object)((Object)SecurableCommunicationChannel.NONE))) {
            return false;
        }
        if (ArrayUtils.contains((Object[])distributionConfig.getSecurableCommunicationChannels(), (Object)((Object)SecurableCommunicationChannel.ALL))) {
            return true;
        }
        return ArrayUtils.contains((Object[])distributionConfig.getSecurableCommunicationChannels(), (Object)((Object)sslEnabledComponent));
    }

    private SSLConfig configureLegacyClusterSSL(DistributionConfig distributionConfig, SSLConfig sslConfig) {
        sslConfig.setCiphers(distributionConfig.getClusterSSLCiphers());
        sslConfig.setEnabled(distributionConfig.getClusterSSLEnabled());
        sslConfig.setKeystore(distributionConfig.getClusterSSLKeyStore());
        sslConfig.setKeystorePassword(distributionConfig.getClusterSSLKeyStorePassword());
        sslConfig.setKeystoreType(distributionConfig.getClusterSSLKeyStoreType());
        sslConfig.setTruststore(distributionConfig.getClusterSSLTrustStore());
        sslConfig.setTruststorePassword(distributionConfig.getClusterSSLTrustStorePassword());
        sslConfig.setTruststoreType(distributionConfig.getClusterSSLKeyStoreType());
        sslConfig.setProtocols(distributionConfig.getClusterSSLProtocols());
        sslConfig.setRequireAuth(distributionConfig.getClusterSSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureLegacyServerSSL(DistributionConfig distributionConfig, SSLConfig sslConfig) {
        sslConfig.setCiphers(distributionConfig.getServerSSLCiphers());
        sslConfig.setEnabled(distributionConfig.getServerSSLEnabled());
        sslConfig.setKeystore(distributionConfig.getServerSSLKeyStore());
        sslConfig.setKeystorePassword(distributionConfig.getServerSSLKeyStorePassword());
        sslConfig.setKeystoreType(distributionConfig.getServerSSLKeyStoreType());
        sslConfig.setTruststore(distributionConfig.getServerSSLTrustStore());
        sslConfig.setTruststorePassword(distributionConfig.getServerSSLTrustStorePassword());
        sslConfig.setTruststoreType(distributionConfig.getServerSSLKeyStoreType());
        sslConfig.setProtocols(distributionConfig.getServerSSLProtocols());
        sslConfig.setRequireAuth(distributionConfig.getServerSSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureLegacyJMXSSL(DistributionConfig distributionConfig, SSLConfig sslConfig) {
        sslConfig.setCiphers(distributionConfig.getJmxManagerSSLCiphers());
        sslConfig.setEnabled(distributionConfig.getJmxManagerSSLEnabled());
        sslConfig.setKeystore(distributionConfig.getJmxManagerSSLKeyStore());
        sslConfig.setKeystorePassword(distributionConfig.getJmxManagerSSLKeyStorePassword());
        sslConfig.setKeystoreType(distributionConfig.getJmxManagerSSLKeyStoreType());
        sslConfig.setTruststore(distributionConfig.getJmxManagerSSLTrustStore());
        sslConfig.setTruststorePassword(distributionConfig.getJmxManagerSSLTrustStorePassword());
        sslConfig.setTruststoreType(distributionConfig.getJmxManagerSSLKeyStoreType());
        sslConfig.setProtocols(distributionConfig.getJmxManagerSSLProtocols());
        sslConfig.setRequireAuth(distributionConfig.getJmxManagerSSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureLegacyGatewaySSL(DistributionConfig distributionConfig, SSLConfig sslConfig) {
        sslConfig.setCiphers(distributionConfig.getGatewaySSLCiphers());
        sslConfig.setEnabled(distributionConfig.getGatewaySSLEnabled());
        sslConfig.setKeystore(distributionConfig.getGatewaySSLKeyStore());
        sslConfig.setKeystorePassword(distributionConfig.getGatewaySSLKeyStorePassword());
        sslConfig.setKeystoreType(distributionConfig.getGatewaySSLKeyStoreType());
        sslConfig.setTruststore(distributionConfig.getGatewaySSLTrustStore());
        sslConfig.setTruststorePassword(distributionConfig.getGatewaySSLTrustStorePassword());
        sslConfig.setProtocols(distributionConfig.getGatewaySSLProtocols());
        sslConfig.setRequireAuth(distributionConfig.getGatewaySSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureLegacyHttpServiceSSL(DistributionConfig distributionConfig, SSLConfig sslConfig) {
        sslConfig.setCiphers(distributionConfig.getHttpServiceSSLCiphers());
        sslConfig.setEnabled(distributionConfig.getHttpServiceSSLEnabled());
        sslConfig.setKeystore(distributionConfig.getHttpServiceSSLKeyStore());
        sslConfig.setKeystorePassword(distributionConfig.getHttpServiceSSLKeyStorePassword());
        sslConfig.setKeystoreType(distributionConfig.getHttpServiceSSLKeyStoreType());
        sslConfig.setTruststore(distributionConfig.getHttpServiceSSLTrustStore());
        sslConfig.setTruststorePassword(distributionConfig.getHttpServiceSSLTrustStorePassword());
        sslConfig.setTruststoreType(distributionConfig.getHttpServiceSSLKeyStoreType());
        sslConfig.setProtocols(distributionConfig.getHttpServiceSSLProtocols());
        sslConfig.setRequireAuth(distributionConfig.getHttpServiceSSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureSSLPropertiesFromSystemProperties(SSLConfig sslConfig) {
        return this.configureSSLPropertiesFromSystemProperties(sslConfig, null);
    }

    private SSLConfig configureSSLPropertiesFromSystemProperties(SSLConfig sslConfig, Properties properties) {
        if (StringUtils.isEmpty((String)sslConfig.getKeystore())) {
            sslConfig.setKeystore(this.getValueFromSystemProperties(properties, JAVAX_KEYSTORE));
        }
        if (StringUtils.isEmpty((String)sslConfig.getKeystoreType())) {
            sslConfig.setKeystoreType(this.getValueFromSystemProperties(properties, JAVAX_KEYSTORE_TYPE));
        }
        if (StringUtils.isEmpty((String)sslConfig.getKeystorePassword())) {
            sslConfig.setKeystorePassword(this.getValueFromSystemProperties(properties, JAVAX_KEYSTORE_PASSWORD));
        }
        if (StringUtils.isEmpty((String)sslConfig.getTruststore())) {
            sslConfig.setTruststore(this.getValueFromSystemProperties(properties, JAVAX_TRUSTSTORE));
        }
        if (StringUtils.isEmpty((String)sslConfig.getTruststorePassword())) {
            sslConfig.setTruststorePassword(this.getValueFromSystemProperties(properties, JAVAX_TRUSTSTORE_PASSWORD));
        }
        if (StringUtils.isEmpty((String)sslConfig.getTruststoreType())) {
            sslConfig.setTruststoreType(this.getValueFromSystemProperties(properties, JAVAX_TRUSTSTORE_TYPE));
        }
        return sslConfig;
    }

    private String getValueFromSystemProperties(Properties properties, String property) {
        String propertyValue = null;
        if (properties != null) {
            propertyValue = properties.getProperty(property);
        }
        if (property != null && (propertyValue = System.getProperty(property)) != null && propertyValue.trim().equals("")) {
            propertyValue = System.getenv(property);
        }
        return propertyValue;
    }

    private SSLConfig getRegisteredSSLConfigForComponent(SecurableCommunicationChannel sslEnabledComponent) {
        return this.registeredSSLConfig.get((Object)sslEnabledComponent);
    }

    public static void close() {
        SSLConfigurationFactory.getInstance().clearSSLConfigForAllComponents();
        SSLConfigurationFactory.getInstance().distributionConfig = null;
    }

    private void clearSSLConfigForAllComponents() {
        this.registeredSSLConfig.clear();
    }

    @Deprecated
    public static SSLConfig getSSLConfigForComponent(boolean useSSL, boolean needClientAuth, String protocols, String ciphers, Properties gfsecurityProps, String alias) {
        SSLConfig sslConfig = new SSLConfig();
        sslConfig.setAlias(alias);
        sslConfig.setCiphers(ciphers);
        sslConfig.setProtocols(protocols);
        sslConfig.setRequireAuth(needClientAuth);
        sslConfig.setEnabled(useSSL);
        sslConfig = SSLConfigurationFactory.getInstance().configureSSLPropertiesFromSystemProperties(sslConfig, gfsecurityProps);
        return sslConfig;
    }

    public static SSLConfig getSSLConfigForComponent(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        return SSLConfigurationFactory.getInstance().createSSLConfigForComponent(distributionConfig, sslEnabledComponent);
    }

    public static SSLConfig getSSLConfigForComponent(Properties properties, SecurableCommunicationChannel sslEnabledComponent) {
        return SSLConfigurationFactory.getInstance().createSSLConfigForComponent(new DistributionConfigImpl(properties), sslEnabledComponent);
    }
}

