/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging.log4j;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;

public class LogLevel {
    private static Map<String, Level> LEVELS = new HashMap<String, Level>();
    private static Map<String, Integer> S2I = new HashMap<String, Integer>();
    private static Map<Integer, String> I2S = new HashMap<Integer, String>();

    public static Level resolveLevel(String level) {
        Level log4jLevel = LEVELS.get(level.toUpperCase());
        return log4jLevel == null ? Level.OFF : log4jLevel;
    }

    public static Level getLevel(String level) {
        return LEVELS.get(level.toUpperCase());
    }

    public static int getLogWriterLevel(Level log4jLevel) {
        Integer result = S2I.get(log4jLevel.name());
        if (result == null) {
            throw new IllegalArgumentException("Unknown Log4J level [" + log4jLevel + "].");
        }
        return result;
    }

    public static Level getLog4jLevel(int logWriterLevel) {
        String log4jLevel = I2S.get(logWriterLevel);
        if (log4jLevel == null) {
            throw new IllegalArgumentException("Unknown LogWriter level [" + logWriterLevel + "].");
        }
        return Level.getLevel((String)log4jLevel);
    }

    public static int getLogWriterLevel(String levelName) {
        if (levelName == null) {
            throw new IllegalArgumentException("Levalname can't be null");
        }
        Integer level = S2I.get(levelName.toUpperCase());
        if (level != null) {
            return level;
        }
        if (levelName.startsWith("level-")) {
            String levelValue = levelName.substring("level-".length());
            return Integer.parseInt(levelValue);
        }
        String values = Arrays.stream(Level.values()).sorted().map(Level::name).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("Unknown log-level \"" + levelName + "\". Valid levels are: " + values + ".");
    }

    public static String getLog4jLevelAsString(int logWriterLevel) {
        return LogLevel.getLog4jLevel(logWriterLevel).name().toLowerCase();
    }

    static {
        I2S.put(Integer.MAX_VALUE, "OFF");
        I2S.put(1000, "FATAL");
        I2S.put(950, "ERROR");
        I2S.put(900, "WARN");
        I2S.put(800, "INFO");
        I2S.put(700, "INFO");
        I2S.put(500, "DEBUG");
        I2S.put(400, "TRACE");
        I2S.put(300, "TRACE");
        I2S.put(Integer.MIN_VALUE, "ALL");
        S2I.put("NONE", Integer.MAX_VALUE);
        S2I.put("SEVERE", 1000);
        S2I.put("ERROR", 950);
        S2I.put("WARNING", 900);
        S2I.put("INFO", 800);
        S2I.put("CONFIG", 700);
        S2I.put("FINE", 500);
        S2I.put("FINER", 400);
        S2I.put("FINEST", 300);
        S2I.put("ALL", Integer.MIN_VALUE);
        S2I.put("OFF", Integer.MAX_VALUE);
        S2I.put("FATAL", 1000);
        S2I.put("WARN", 900);
        S2I.put("DEBUG", 500);
        S2I.put("TRACE", 300);
        Arrays.stream(Level.values()).forEach(level -> LEVELS.put(level.name(), (Level)level));
        LEVELS.put("SEVERE", LogLevel.getLog4jLevel(1000));
        LEVELS.put("WARNING", LogLevel.getLog4jLevel(900));
        LEVELS.put("CONFIG", LogLevel.getLog4jLevel(700));
        LEVELS.put("FINE", LogLevel.getLog4jLevel(500));
        LEVELS.put("FINER", LogLevel.getLog4jLevel(400));
        LEVELS.put("FINEST", LogLevel.getLog4jLevel(300));
        LEVELS.put("NONE", LogLevel.getLog4jLevel(Integer.MAX_VALUE));
    }
}

