/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging.log4j;

import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.FastLogger;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class AppenderContext {
    public static final String LOGGER_PROPERTY = "gemfire.logging.appenders.LOGGER";
    private final String name;

    public AppenderContext() {
        this(System.getProperty(LOGGER_PROPERTY, ""));
    }

    public AppenderContext(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LoggerContext getLoggerContext() {
        return this.getLogger().getContext();
    }

    public LoggerConfig getLoggerConfig() {
        Logger logger = this.getLogger();
        LoggerContext context = logger.getContext();
        return context.getConfiguration().getLoggerConfig(logger.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AppenderContext:");
        if ("".equals(this.name)) {
            sb.append("<ROOT>");
        } else {
            sb.append(this.name);
        }
        return sb.toString();
    }

    private Logger getLogger() {
        Logger logger = null;
        logger = "".equals(this.name) ? (Logger)LogService.getRootLogger() : (Logger)((FastLogger)LogService.getLogger(this.name)).getExtendedLogger();
        return logger;
    }
}

