/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.jta;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.geode.CancelException;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.jta.GlobalTransaction;
import org.apache.geode.internal.jta.TransactionImpl;
import org.apache.geode.internal.jta.TransactionUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.logging.log4j.Logger;

@Deprecated
public class TransactionManagerImpl
implements TransactionManager,
Serializable {
    private static final long serialVersionUID = 5033392316185449821L;
    private static final Logger logger = LogService.getLogger();
    private Map transactionMap = new ConcurrentHashMap();
    private Map globalTransactionMap = Collections.synchronizedMap(new HashMap());
    protected SortedSet gtxSet = Collections.synchronizedSortedSet(new TreeSet(new GlobalTransactionComparator()));
    private transient TransactionTimeOutThread cleaner;
    private static TransactionManagerImpl transactionManager = null;
    private transient Thread cleanUpThread = null;
    static final int DEFAULT_TRANSACTION_TIMEOUT = Integer.getInteger("jta.defaultTimeout", 600);
    private static final int MARKED_ROLLBACK = 1;
    private static final int EXCEPTION_IN_NOTIFY_BEFORE_COMPLETION = 2;
    private static final int COMMIT_FAILED_SO_ROLLEDBAK = 3;
    private static final int COMMIT_FAILED_ROLLBAK_ALSO_FAILED = 4;
    private static final int ROLLBAK_FAILED = 5;
    private static boolean VERBOSE = Boolean.getBoolean("jta.VERBOSE");
    private boolean isActive = true;
    private final transient AtomicBoolean loggedJTATransactionManagerDeprecatedWarning = new AtomicBoolean(false);

    private TransactionManagerImpl() {
        this.cleaner = new TransactionTimeOutThread();
        LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup(LocalizedStrings.TransactionManagerImpl_CLEAN_UP_THREADS.toLocalizedString());
        this.cleanUpThread = new Thread(group, this.cleaner, "GlobalTXTimeoutMonitor");
        this.cleanUpThread.setDaemon(true);
        this.cleanUpThread.start();
    }

    public static TransactionManagerImpl getTransactionManager() {
        if (transactionManager == null) {
            TransactionManagerImpl.createTransactionManager();
        }
        return transactionManager;
    }

    private static synchronized void createTransactionManager() {
        if (transactionManager == null) {
            transactionManager = new TransactionManagerImpl();
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        Thread thread;
        if (this.loggedJTATransactionManagerDeprecatedWarning.compareAndSet(false, true)) {
            logger.warn("Geode JTA transaction manager is deprecated since 1.2.0, please use a third party JTA transaction manager instead");
        }
        if (!this.isActive) {
            throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
        }
        LogWriterI18n log = TransactionUtils.getLogWriterI18n();
        if (log.fineEnabled()) {
            log.fine("TransactionManager.begin() invoked");
        }
        if (this.transactionMap.get(thread = Thread.currentThread()) != null) {
            String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_BEGIN_NESTED_TRANSACTION_IS_NOT_SUPPORTED.toLocalizedString();
            if (VERBOSE) {
                log.fine(exception);
            }
            throw new NotSupportedException(exception);
        }
        try {
            TransactionImpl transaction = new TransactionImpl();
            this.transactionMap.put(thread, transaction);
            GlobalTransaction globalTransaction = new GlobalTransaction();
            this.globalTransactionMap.put(transaction, globalTransaction);
            globalTransaction.addTransaction(transaction);
            globalTransaction.setStatus(0);
        }
        catch (Exception e) {
            String exception = LocalizedStrings.TransactionManagerImpl_BEGIN__SYSTEMEXCEPTION_DUE_TO_0.toLocalizedString(e);
            if (log.severeEnabled()) {
                log.severe(LocalizedStrings.TransactionManagerImpl_BEGIN__SYSTEMEXCEPTION_DUE_TO_0, new Object[]{e});
            }
            throw new SystemException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException {
        LogWriterI18n writer;
        Throwable e;
        int status;
        GlobalTransaction gtx;
        int cozOfException;
        block46: {
            if (!this.isActive) {
                throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
            }
            cozOfException = -1;
            Transaction transactionImpl = this.getTransaction();
            if (transactionImpl == null) {
                String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_COMMIT_TRANSACTION_IS_NULL_CANNOT_COMMIT_A_NULL_TRANSACTION.toLocalizedString();
                LogWriterI18n writer2 = TransactionUtils.getLogWriterI18n();
                if (VERBOSE) {
                    writer2.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            gtx = this.getGlobalTransaction(transactionImpl);
            if (gtx == null) {
                String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_COMMIT_GLOBAL_TRANSACTION_IS_NULL_CANNOT_COMMIT_A_NULL_GLOBAL_TRANSACTION.toLocalizedString();
                LogWriterI18n writer3 = TransactionUtils.getLogWriterI18n();
                if (VERBOSE) {
                    writer3.fine(exception);
                }
                throw new SystemException(exception);
            }
            boolean isCommit = false;
            status = -1;
            status = gtx.getStatus();
            if (status == 0 || status == 1) {
                GlobalTransaction globalTransaction = gtx;
                synchronized (globalTransaction) {
                    status = gtx.getStatus();
                    if (status == 0) {
                        gtx.setStatus(8);
                        isCommit = true;
                    } else if (status == 1) {
                        gtx.setStatus(9);
                        cozOfException = 1;
                    } else {
                        String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_COMMIT_TRANSACTION_NOT_ACTIVE_CANNOT_BE_COMMITTED_TRANSACTION_STATUS_0.toLocalizedString(status);
                        LogWriterI18n writer4 = TransactionUtils.getLogWriterI18n();
                        if (VERBOSE) {
                            writer4.fine(exception);
                        }
                        throw new IllegalStateException(exception);
                    }
                }
            } else {
                String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_COMMIT_TRANSACTION_IS_NOT_ACTIVE_AND_CANNOT_BE_COMMITTED.toLocalizedString();
                LogWriterI18n writer5 = TransactionUtils.getLogWriterI18n();
                if (VERBOSE) {
                    writer5.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            boolean isClean = false;
            e = null;
            try {
                ((TransactionImpl)transactionImpl).notifyBeforeCompletion();
                isClean = true;
            }
            catch (Exception ge) {
                this.setRollbackOnly();
                cozOfException = 2;
                e = ge;
            }
            if (isCommit) {
                GlobalTransaction ge = gtx;
                synchronized (ge) {
                    status = gtx.getStatus();
                    if (status == 8) {
                        try {
                            gtx.commit();
                        }
                        catch (RollbackException rbe) {
                            e = rbe;
                            cozOfException = 3;
                        }
                        catch (SystemException se) {
                            e = se;
                            cozOfException = 4;
                        }
                    } else if (status == 9) {
                        try {
                            gtx.rollback();
                            if (isClean) {
                                cozOfException = 1;
                            }
                        }
                        catch (SystemException se) {
                            e = se;
                            cozOfException = 5;
                        }
                    }
                }
            }
            try {
                gtx.rollback();
            }
            catch (SystemException se) {
                e = se;
                cozOfException = 5;
            }
            try {
                status = gtx.getStatus();
                ((TransactionImpl)transactionImpl).notifyAfterCompletion(status);
            }
            catch (Exception ge) {
                writer = TransactionUtils.getLogWriterI18n();
                if (!writer.infoEnabled()) break block46;
                writer.info(LocalizedStrings.TransactionManagerImpl_EXCEPTION_IN_NOTIFY_AFTER_COMPLETION_DUE_TO__0, ge.getMessage(), (Throwable)ge);
            }
        }
        Thread thread = Thread.currentThread();
        this.transactionMap.remove(thread);
        this.gtxSet.remove(gtx);
        if (status != 3) {
            switch (cozOfException) {
                case 2: {
                    String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_COMMIT_TRANSACTION_ROLLED_BACK_BECAUSE_OF_EXCEPTION_IN_NOTIFYBEFORECOMPLETION_FUNCTION_CALL_ACTUAL_EXCEPTION_0.toLocalizedString();
                    LogWriterI18n writer6 = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer6.fine(exception, e);
                    }
                    RollbackException re = new RollbackException(exception);
                    re.initCause(e);
                    throw re;
                }
                case 1: {
                    String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_COMMIT_TRANSACTION_ROLLED_BACK_BECAUSE_A_USER_MARKED_IT_FOR_ROLLBACK.toLocalizedString();
                    LogWriterI18n writer7 = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer7.fine(exception, e);
                    }
                    throw new RollbackException(exception);
                }
                case 3: {
                    writer = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer.fine(e);
                    }
                    throw (RollbackException)e;
                }
                case 4: 
                case 5: {
                    writer = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer.fine(e);
                    }
                    throw (SystemException)e;
                }
            }
        }
        gtx.setStatus(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        SystemException se;
        GlobalTransaction gtx;
        LogWriterI18n writer;
        block20: {
            if (!this.isActive) {
                throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
            }
            writer = TransactionUtils.getLogWriterI18n();
            Transaction transactionImpl = this.getTransaction();
            if (transactionImpl == null) {
                String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_ROLLBACK_NO_TRANSACTION_EXISTS.toLocalizedString();
                if (VERBOSE) {
                    writer.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            gtx = this.getGlobalTransaction(transactionImpl);
            if (gtx == null) {
                String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_ROLLBACK_NO_GLOBAL_TRANSACTION_EXISTS.toLocalizedString();
                if (VERBOSE) {
                    writer.fine(exception);
                }
                throw new SystemException(exception);
            }
            int status = gtx.getStatus();
            if (status != 0 && status != 1) {
                String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_ROLLBACK_TRANSACTION_STATUS_DOES_NOT_ALLOW_ROLLBACK_TRANSACTIONAL_STATUS_0.toLocalizedString(status);
                if (VERBOSE) {
                    writer.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            status = -1;
            GlobalTransaction exception = gtx;
            synchronized (exception) {
                status = gtx.getStatus();
                if (status != 0 && status != 1) {
                    if (gtx.getStatus() == 9) {
                        String exception2 = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_ROLLBACK_TRANSACTION_ALREADY_IN_A_ROLLING_BACK_STATE_TRANSACTIONAL_STATUS_0.toLocalizedString(status);
                        if (VERBOSE) {
                            writer.fine(exception2);
                        }
                        throw new IllegalStateException(exception2);
                    }
                    String exception3 = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_ROLLBACK_TRANSACTION_STATUS_DOES_NOT_ALLOW_ROLLBACK.toLocalizedString();
                    if (VERBOSE) {
                        writer.fine(exception3);
                    }
                    throw new IllegalStateException(exception3);
                }
                gtx.setStatus(9);
            }
            se = null;
            try {
                gtx.rollback();
            }
            catch (SystemException se1) {
                se = se1;
            }
            try {
                ((TransactionImpl)transactionImpl).notifyAfterCompletion(gtx.getStatus());
            }
            catch (Exception e1) {
                if (!writer.infoEnabled()) break block20;
                writer.info(LocalizedStrings.TransactionManagerImpl_EXCEPTION_IN_NOTIFY_AFTER_COMPLETION_DUE_TO__0, e1.getMessage(), (Throwable)e1);
            }
        }
        Thread thread = Thread.currentThread();
        this.transactionMap.remove(thread);
        this.gtxSet.remove(gtx);
        if (se != null) {
            if (VERBOSE) {
                writer.fine(se);
            }
            throw se;
        }
        gtx.setStatus(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.isActive) {
            throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
        }
        GlobalTransaction gtx = this.getGlobalTransaction();
        if (gtx == null) {
            String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_SETROLLBACKONLY_NO_GLOBAL_TRANSACTION_EXISTS.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        GlobalTransaction exception = gtx;
        synchronized (exception) {
            int status = gtx.getStatus();
            if (status == 0) {
                gtx.setRollbackOnly();
            } else if (status == 8) {
                gtx.setStatus(9);
            } else if (status != 9) {
                String exception2 = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_SETROLLBACKONLY_TRANSACTION_CANNOT_BE_MARKED_FOR_ROLLBACK_TRANSCATION_STATUS_0.toLocalizedString(status);
                LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                if (VERBOSE) {
                    writer.fine(exception2);
                }
                throw new IllegalStateException(exception2);
            }
        }
        LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
        if (VERBOSE) {
            writer.fine("Transaction Set to Rollback only");
        }
    }

    public int getStatus() throws SystemException {
        if (!this.isActive) {
            throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
        }
        GlobalTransaction gtx = this.getGlobalTransaction();
        if (gtx == null) {
            return 6;
        }
        return gtx.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.isActive) {
            throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
        }
        GlobalTransaction gtx = this.getGlobalTransaction();
        if (gtx == null) {
            String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_SETTRANSACTIONTIMEOUT_NO_GLOBAL_TRANSACTION_EXISTS.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        long newExpiry = gtx.setTransactionTimeoutForXARes(seconds);
        if (newExpiry > 0L) {
            this.gtxSet.remove(gtx);
            int status = gtx.getStatus();
            if (status != 6 && status != 3 && status != 4 && !gtx.isExpired()) {
                boolean toAdd = false;
                Object object = gtx;
                synchronized (object) {
                    if (!gtx.isExpired()) {
                        gtx.setTimeoutValue(newExpiry);
                        toAdd = true;
                    }
                }
                if (toAdd) {
                    object = this.gtxSet;
                    synchronized (object) {
                        this.gtxSet.add(gtx);
                        if (this.gtxSet.first() == gtx) {
                            this.gtxSet.notify();
                        }
                    }
                }
            } else {
                String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_SETTRANSACTIONTIMEOUT_TRANSACTION_HAS_EITHER_EXPIRED_OR_ROLLEDBACK_OR_COMMITTED.toLocalizedString();
                LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                if (VERBOSE) {
                    writer.fine(exception);
                }
                throw new SystemException(exception);
            }
        }
    }

    public Transaction suspend() throws SystemException {
        if (!this.isActive) {
            throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
        }
        Transaction txn = this.getTransaction();
        if (null != txn) {
            GlobalTransaction gtx = this.getGlobalTransaction(txn);
            gtx.suspend();
            this.transactionMap.remove(Thread.currentThread());
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.infoEnabled()) {
                writer.info(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPLSUSPENDTRANSACTION_SUSPENDED);
            }
        }
        return txn;
    }

    public void resume(Transaction txn) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (!this.isActive) {
            throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
        }
        if (txn == null) {
            String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_RESUME_CANNOT_RESUME_A_NULL_TRANSACTION.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new InvalidTransactionException(exception);
        }
        GlobalTransaction gtx = this.getGlobalTransaction(txn);
        if (gtx == null) {
            String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_RESUME_CANNOT_RESUME_A_NULL_TRANSACTION.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new InvalidTransactionException(exception);
        }
        gtx.resume();
        try {
            Thread thread = Thread.currentThread();
            this.transactionMap.put(thread, txn);
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.infoEnabled()) {
                writer.info(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPLRESUMETRANSACTION_RESUMED);
            }
        }
        catch (Exception e) {
            String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_RESUME_ERROR_IN_LISTING_THREAD_TO_TRANSACTION_MAP_DUE_TO_0.toLocalizedString(e);
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
    }

    public Transaction getTransaction() throws SystemException {
        if (!this.isActive) {
            throw new SystemException(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGER_INVALID.toLocalizedString());
        }
        Thread thread = Thread.currentThread();
        Transaction txn = (Transaction)this.transactionMap.get(thread);
        return txn;
    }

    GlobalTransaction getGlobalTransaction() throws SystemException {
        Transaction txn = this.getTransaction();
        if (txn == null) {
            return null;
        }
        GlobalTransaction gtx = (GlobalTransaction)this.globalTransactionMap.get(txn);
        return gtx;
    }

    GlobalTransaction getGlobalTransaction(Transaction txn) throws SystemException {
        if (txn == null) {
            String exception = LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPL_GETGLOBALTRANSACTION_NO_TRANSACTION_EXISTS.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        GlobalTransaction gtx = (GlobalTransaction)this.globalTransactionMap.get(txn);
        return gtx;
    }

    Map getGlobalTransactionMap() {
        return this.globalTransactionMap;
    }

    Map getTransactionMap() {
        return this.transactionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanGlobalTransactionMap(List tranxns) {
        List list = tranxns;
        synchronized (list) {
            Iterator iterator = tranxns.iterator();
            while (iterator.hasNext()) {
                this.globalTransactionMap.remove(iterator.next());
            }
        }
    }

    void removeTranxnMappings(List tranxns) {
        Object[] threads = this.transactionMap.keySet().toArray();
        int len = threads.length;
        Object tx = null;
        boolean removed = false;
        Object temp = null;
        for (int i = 0; i < len; ++i) {
            temp = threads[i];
            tx = this.transactionMap.get(temp);
            removed = tranxns.remove(tx);
            if (!removed) continue;
            this.transactionMap.remove(temp);
            this.globalTransactionMap.remove(tx);
        }
    }

    public static void refresh() {
        block2: {
            TransactionManagerImpl.getTransactionManager();
            TransactionManagerImpl.transactionManager.isActive = false;
            TransactionManagerImpl.transactionManager.cleaner.toContinueRunning = false;
            try {
                TransactionManagerImpl.transactionManager.cleanUpThread.interrupt();
            }
            catch (Exception e) {
                LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                if (!writer.infoEnabled()) break block2;
                writer.info(LocalizedStrings.TransactionManagerImpl_TRANSACTIONMANAGERIMPLCLEANUPEXCEPTION_WHILE_CLEANING_THREAD_BEFORE_RE_STATRUP);
            }
        }
        transactionManager = null;
    }

    static class GlobalTransactionComparator
    implements Comparator,
    Serializable {
        GlobalTransactionComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            GlobalTransaction gtx1 = (GlobalTransaction)obj1;
            GlobalTransaction gtx2 = (GlobalTransaction)obj2;
            return gtx1.compare(gtx2);
        }

        @Override
        public boolean equals(Object o1) {
            return this == o1;
        }
    }

    class TransactionTimeOutThread
    implements Runnable {
        protected volatile boolean toContinueRunning = true;

        TransactionTimeOutThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GlobalTransaction currentGtx = null;
            long lag = 0L;
            LogWriterI18n logger = TransactionUtils.getLogWriterI18n();
            while (this.toContinueRunning) {
                try {
                    SortedSet sortedSet = TransactionManagerImpl.this.gtxSet;
                    synchronized (sortedSet) {
                        while (TransactionManagerImpl.this.gtxSet.isEmpty() && this.toContinueRunning) {
                            TransactionManagerImpl.this.gtxSet.wait();
                        }
                        if (!this.toContinueRunning) {
                            continue;
                        }
                        currentGtx = (GlobalTransaction)TransactionManagerImpl.this.gtxSet.first();
                    }
                    boolean continueInner = true;
                    do {
                        Object object = currentGtx;
                        synchronized (object) {
                            lag = System.currentTimeMillis() - currentGtx.getExpirationTime();
                            if (lag >= 0L) {
                                currentGtx.expireGTX();
                                TransactionManagerImpl.this.gtxSet.remove(currentGtx);
                            }
                        }
                        object = TransactionManagerImpl.this.gtxSet;
                        synchronized (object) {
                            if (TransactionManagerImpl.this.gtxSet.isEmpty()) {
                                continueInner = false;
                            } else {
                                currentGtx = (GlobalTransaction)TransactionManagerImpl.this.gtxSet.first();
                                boolean isGTXExp = false;
                                lag = System.currentTimeMillis() - currentGtx.getExpirationTime();
                                if (lag < 0L) {
                                    isGTXExp = false;
                                } else {
                                    isGTXExp = true;
                                    if (!currentGtx.isExpired()) {
                                        currentGtx.expireGTX();
                                    }
                                    TransactionManagerImpl.this.gtxSet.remove(currentGtx);
                                    if (TransactionManagerImpl.this.gtxSet.isEmpty()) {
                                        continueInner = false;
                                    } else {
                                        currentGtx = (GlobalTransaction)TransactionManagerImpl.this.gtxSet.first();
                                    }
                                }
                                if (!isGTXExp && this.toContinueRunning) {
                                    TransactionManagerImpl.this.gtxSet.wait(-lag);
                                    if (TransactionManagerImpl.this.gtxSet.isEmpty()) {
                                        continueInner = false;
                                    } else {
                                        currentGtx = (GlobalTransaction)TransactionManagerImpl.this.gtxSet.first();
                                    }
                                }
                                if (!this.toContinueRunning) {
                                    continueInner = false;
                                }
                            }
                        }
                    } while (continueInner);
                }
                catch (InterruptedException e) {
                    if (this.toContinueRunning) {
                        logger.fine("TransactionTimeOutThread: unexpected exception", e);
                    }
                    return;
                }
                catch (CancelException e) {
                    return;
                }
                catch (Exception e) {
                    if (!logger.severeEnabled() || !this.toContinueRunning) continue;
                    logger.severe(LocalizedStrings.TransactionManagerImpl_TRANSACTIONTIMEOUTTHREAD__RUN_EXCEPTION_OCCURRED_WHILE_INSPECTING_GTX_FOR_EXPIRY, e);
                }
            }
        }
    }
}

