/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.util.EventListener;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.geode.internal.datasource.AbstractPoolCache;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.PoolException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ManagedPoolCacheImpl
extends AbstractPoolCache {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1064642271736399718L;
    private ManagedConnectionFactory connFactory;
    private Subject sub;
    private ConnectionRequestInfo connReqInfo;

    public ManagedPoolCacheImpl(ManagedConnectionFactory connFac, Subject subject, ConnectionRequestInfo connReq, ConnectionEventListener eventListner, ConfiguredDataSourceProperties configs) throws PoolException {
        super((EventListener)eventListner, configs);
        this.connFactory = connFac;
        this.sub = subject;
        this.connReqInfo = connReq;
        this.initializePool();
    }

    @Override
    public Object getNewPoolConnection() throws PoolException {
        ManagedConnection manConn = null;
        try {
            manConn = this.connFactory.createManagedConnection(this.sub, this.connReqInfo);
        }
        catch (ResourceException rex) {
            rex.printStackTrace();
            throw new PoolException(LocalizedStrings.ManagedPoolCacheImpl_MANAGEDPOOLCACHEIMPLGETNEWCONNECTION_EXCEPTION_IN_CREATING_NEW_MANAGED_POOLEDCONNECTION.toLocalizedString(), (Exception)((Object)rex));
        }
        manConn.addConnectionEventListener((ConnectionEventListener)this.connEventListner);
        return manConn;
    }

    @Override
    void destroyPooledConnection(Object connectionObject) {
        block2: {
            try {
                ((ManagedConnection)connectionObject).removeConnectionEventListener((ConnectionEventListener)this.connEventListner);
                ((ManagedConnection)connectionObject).destroy();
                connectionObject = null;
            }
            catch (ResourceException rex) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("ManagedPoolcacheImpl::destroyPooledConnection:Exception in closing the connection.Ignoring it. The exeption is {}", (Object)rex.getMessage(), (Object)rex);
            }
        }
    }
}

