/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.config;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.configuration.XSDRootElement;
import org.apache.geode.internal.ClassPathLoader;
import org.xml.sax.SAXException;

public class JAXBService {
    Marshaller marshaller;
    Unmarshaller unmarshaller;

    public JAXBService(Class<?> ... xsdRootClasses) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])xsdRootClasses);
            this.marshaller = jaxbContext.createMarshaller();
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            String schemas = Arrays.stream(xsdRootClasses).map(c -> {
                XSDRootElement element = c.getAnnotation(XSDRootElement.class);
                if (element != null && StringUtils.isNotEmpty((String)element.namespace()) && StringUtils.isNotEmpty((String)element.schemaLocation())) {
                    return element.namespace() + " " + element.schemaLocation();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.joining(" "));
            this.marshaller.setProperty("jaxb.schemaLocation", (Object)schemas);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void validateWith(URL url) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = factory.newSchema(url);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.marshaller.setSchema(schema);
    }

    public void validateWithLocalCacheXSD() {
        URL local_cache_xsd = ClassPathLoader.getLatest().getResource("META-INF/schemas/geode.apache.org/schema/cache/cache-1.0.xsd");
        this.validateWith(local_cache_xsd);
    }

    public String marshall(Object object) {
        StringWriter sw = new StringWriter();
        try {
            this.marshaller.marshal(object, (Writer)sw);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return sw.toString();
    }

    public <T> T unMarshall(String xml) {
        try {
            return (T)this.unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

