/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

public class CompactConcurrentHashSet2<V>
extends AbstractSet<V>
implements Set<V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = (1 << 32 - RESIZE_STAMP_BITS) - 1;
    private static final int RESIZE_STAMP_SHIFT = 32 - RESIZE_STAMP_BITS;
    static final int MOVED = -1879048193;
    static final int TREEBIN = Integer.MIN_VALUE;
    static final int RESERVED = -2147483647;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("segments", Segment[].class), new ObjectStreamField("segmentMask", Integer.TYPE), new ObjectStreamField("segmentShift", Integer.TYPE)};
    volatile transient Node<V>[] table;
    private volatile transient Node<V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    static final AtomicInteger counterHashCodeGenerator = new AtomicInteger();
    static final int SEED_INCREMENT = 1640531527;
    static final ThreadLocal<CounterHashCode> threadCounterHashCode = new ThreadLocal();
    private static final Unsafe U;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;

    static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    private static int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    static Class<?> comparableClassFor(Object x) {
        if (x instanceof Comparable) {
            Class<?> c = x.getClass();
            if (c == String.class) {
                return c;
            }
            Type[] ts = c.getGenericInterfaces();
            if (ts != null) {
                for (int i = 0; i < ts.length; ++i) {
                    Type[] as;
                    ParameterizedType p;
                    Type t = ts[i];
                    if (!(t instanceof ParameterizedType) || (p = (ParameterizedType)t).getRawType() != Comparable.class || (as = p.getActualTypeArguments()) == null || as.length != 1 || as[0] != c) continue;
                    return c;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> kc, Object k, Object x) {
        return x == null || x.getClass() != kc ? 0 : ((Comparable)k).compareTo(x);
    }

    static <K> Node<K> tabAt(Node<K>[] tab, int i) {
        return (Node)U.getObjectVolatile(tab, ((long)i << ASHIFT) + ABASE);
    }

    static <K> boolean casTabAt(Node<K>[] tab, int i, Node<K> c, Node<K> v) {
        return U.compareAndSwapObject(tab, ((long)i << ASHIFT) + ABASE, c, v);
    }

    static <K> void setTabAt(Node<K>[] tab, int i, Node<K> v) {
        U.putOrderedObject(tab, ((long)i << ASHIFT) + ABASE, v);
    }

    public CompactConcurrentHashSet2() {
    }

    public CompactConcurrentHashSet2(int initialCapacity) {
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeCtl = cap = initialCapacity >= 0x20000000 ? 0x40000000 : CompactConcurrentHashSet2.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    public CompactConcurrentHashSet2(Collection<? extends V> m) {
        this.sizeCtl = 16;
        this.addAll(m);
    }

    public CompactConcurrentHashSet2(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    public CompactConcurrentHashSet2(int initialCapacity, float loadFactor, int concurrencyLevel) {
        long size;
        int cap;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        this.sizeCtl = cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : CompactConcurrentHashSet2.tableSizeFor((int)size);
    }

    @Override
    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    boolean _contains(Object key) {
        Node<Object> e;
        int n;
        if (key == null) {
            return false;
        }
        int h = CompactConcurrentHashSet2.spread(key.hashCode());
        Node<V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = CompactConcurrentHashSet2.tabAt(tab, n - 1 & h)) != null) {
            Object ek;
            int eh = e.hash;
            if (eh == h) {
                ek = e.key;
                if (ek == key || ek != null && key.equals(ek)) {
                    return true;
                }
            } else if (eh < 0) {
                Node<V> p = e.find(h, key);
                return p != null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || (ek = e.key) != key && (ek == null || !key.equals(ek))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean add(V value) {
        return this.putKey(value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putKey(V key, boolean onlyIfAbsent) {
        int binCount;
        block17: {
            boolean wasPresent;
            int i;
            if (key == null) {
                throw new NullPointerException();
            }
            int hash = CompactConcurrentHashSet2.spread(key.hashCode());
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & hash;
                Node<V> f = CompactConcurrentHashSet2.tabAt(tab, i);
                if (f == null) {
                    if (!CompactConcurrentHashSet2.casTabAt(tab, i, null, new Node<V>(hash, key, null))) continue;
                    break block17;
                }
                int fh = f.hash;
                if (fh == -1879048193) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                wasPresent = false;
                Node<V> node = f;
                synchronized (node) {
                    block18: {
                        if (CompactConcurrentHashSet2.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<Object> e = f;
                                while (true) {
                                    Object ek;
                                    if (e.hash == hash && ((ek = e.key) == key || ek != null && key.equals(ek))) {
                                        wasPresent = true;
                                        break block18;
                                    }
                                    Node<V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = new Node<V>(hash, key, null);
                                        break block18;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<V> p = ((TreeBin)f).putTreeVal(hash, key);
                                if (p != null) {
                                    wasPresent = true;
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (wasPresent) {
                return true;
            }
        }
        this.addCount(1L, binCount);
        return false;
    }

    public void addAll(Set<? extends V> m) {
        this.tryPresize(m.size());
        Iterator<V> it = m.iterator();
        while (it.hasNext()) {
            this.putKey(it.next(), false);
        }
    }

    @Override
    public boolean remove(Object key) {
        return this.removeNode(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeNode(Object key) {
        int i;
        Node<V> f;
        int n;
        int hash = CompactConcurrentHashSet2.spread(key.hashCode());
        Node<V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = CompactConcurrentHashSet2.tabAt(tab, i = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1879048193) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            boolean wasPresent = false;
            boolean validated = false;
            Node<V> node = f;
            synchronized (node) {
                if (CompactConcurrentHashSet2.tabAt(tab, i) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<Object> e = f;
                        Node<V> pred = null;
                        do {
                            Object ek;
                            if (e.hash == hash && ((ek = e.key) == key || ek != null && key.equals(ek))) {
                                wasPresent = true;
                                if (pred != null) {
                                    pred.next = e.next;
                                } else {
                                    CompactConcurrentHashSet2.setTabAt(tab, i, e.next);
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        validated = true;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(hash, key, null)) != null) {
                            wasPresent = true;
                            if (t.removeTreeNode(p)) {
                                CompactConcurrentHashSet2.setTabAt(tab, i, CompactConcurrentHashSet2.untreeify(t.first));
                            }
                        }
                    }
                }
            }
            if (!validated) continue;
            if (!wasPresent) break;
            this.addCount(-1L, -1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long delta = 0L;
        int i = 0;
        Node<V>[] tab = this.table;
        while (tab != null && i < tab.length) {
            Node<V> f = CompactConcurrentHashSet2.tabAt(tab, i);
            if (f == null) {
                ++i;
                continue;
            }
            int fh = f.hash;
            if (fh == -1879048193) {
                tab = this.helpTransfer(tab, f);
                i = 0;
                continue;
            }
            Node<V> node = f;
            synchronized (node) {
                if (CompactConcurrentHashSet2.tabAt(tab, i) == f) {
                    Node<Object> p;
                    Node<V> node2 = fh >= 0 ? f : (p = f instanceof TreeBin ? ((TreeBin)f).first : null);
                    while (p != null) {
                        --delta;
                        p = p.next;
                    }
                    CompactConcurrentHashSet2.setTabAt(tab, i++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    @Override
    public String toString() {
        Node<V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        Traverser<V> it = new Traverser<V>(t, f, 0, f);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<V> p = it.advance();
        if (p != null) {
            while (true) {
                Object k;
                sb.append((Object)((k = p.key) == this ? "(this Set)" : k));
                p = it.advance();
                if (p == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int ssize;
        int sshift = 0;
        for (ssize = 1; ssize < 16; ssize <<= 1) {
            ++sshift;
        }
        int segmentShift = 32 - sshift;
        int segmentMask = ssize - 1;
        Segment[] segments = new Segment[16];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = new Segment(0.75f);
        }
        ObjectOutputStream.PutField streamFields = s.putFields();
        streamFields.put("segments", segments);
        streamFields.put("segmentShift", segmentShift);
        streamFields.put("segmentMask", segmentMask);
        s.writeFields();
        Node<V>[] t = this.table;
        if (this.table != null) {
            Node<V> p;
            Traverser<V> it = new Traverser<V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                s.writeObject(p.key);
            }
        }
        s.writeObject(null);
        s.writeObject(null);
        segments = null;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object k;
        this.sizeCtl = -1;
        s.defaultReadObject();
        long size = 0L;
        Node<Object> p = null;
        while ((k = s.readObject()) != null) {
            p = new Node<Object>(CompactConcurrentHashSet2.spread(k.hashCode()), k, p);
            ++size;
        }
        if (size == 0L) {
            this.sizeCtl = 0;
        } else {
            int n;
            if (size >= 0x20000000L) {
                n = 0x40000000;
            } else {
                int sz = (int)size;
                n = CompactConcurrentHashSet2.tableSizeFor(sz + (sz >>> 1) + 1);
            }
            Node[] tab = new Node[n];
            int mask = n - 1;
            long added = 0L;
            while (p != null) {
                boolean insertAtFront;
                Node next = p.next;
                int h = p.hash;
                int j = h & mask;
                Node first = CompactConcurrentHashSet2.tabAt(tab, j);
                if (first == null) {
                    insertAtFront = true;
                } else {
                    Object k2 = p.key;
                    if (first.hash < 0) {
                        TreeBin t = (TreeBin)first;
                        if (t.putTreeVal(h, k2) == null) {
                            ++added;
                        }
                        insertAtFront = false;
                    } else {
                        int binCount = 0;
                        insertAtFront = true;
                        Node<Object> q = first;
                        while (q != null) {
                            Object qk;
                            if (q.hash == h && ((qk = q.key) == k2 || qk != null && k2.equals(qk))) {
                                insertAtFront = false;
                                break;
                            }
                            ++binCount;
                            q = q.next;
                        }
                        if (insertAtFront && binCount >= 8) {
                            insertAtFront = false;
                            ++added;
                            p.next = first;
                            TreeNode hd = null;
                            TreeNode tl = null;
                            q = p;
                            while (q != null) {
                                TreeNode t = new TreeNode(q.hash, q.key, null, null);
                                t.prev = tl;
                                if (t.prev == null) {
                                    hd = t;
                                } else {
                                    tl.next = t;
                                }
                                tl = t;
                                q = q.next;
                            }
                            CompactConcurrentHashSet2.setTabAt(tab, j, new TreeBin(hd));
                        }
                    }
                }
                if (insertAtFront) {
                    ++added;
                    p.next = first;
                    CompactConcurrentHashSet2.setTabAt(tab, j, p);
                }
                p = next;
            }
            this.table = tab;
            this.sizeCtl = n - (n >>> 2);
            this.baseCount = added;
        }
    }

    @Override
    public boolean contains(Object value) {
        return this._contains(value);
    }

    @Override
    public Iterator<V> iterator() {
        CompactConcurrentHashSet2 m = this;
        Node<V>[] t = m.table;
        int f = m.table == null ? 0 : t.length;
        return new KeyIterator<V>(t, f, 0, f, m);
    }

    public long mappingCount() {
        long n = this.sumCount();
        return n < 0L ? 0L : n;
    }

    static int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 1 << RESIZE_STAMP_BITS - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (U.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private void addCount(long x, int check) {
        long s;
        long b;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !U.compareAndSwapLong(this, BASECOUNT, b = this.baseCount, s = b + x)) {
            long v;
            CounterCell a;
            int m;
            boolean uncontended = true;
            CounterHashCode hc = threadCounterHashCode.get();
            if (hc == null || as == null || (m = as.length - 1) < 0 || (a = as[m & hc.code]) == null || !(uncontended = U.compareAndSwapLong(a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, hc, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl)) {
                int n;
                Node<V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = CompactConcurrentHashSet2.resizeStamp(n);
                if (sc < 0) {
                    if (sc >>> RESIZE_STAMP_SHIFT != rs || sc == rs + 1 || sc == rs + MAX_RESIZERS) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (U.compareAndSwapInt(this, SIZECTL, sc, (rs << RESIZE_STAMP_SHIFT) + 2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    Node<V>[] helpTransfer(Node<V>[] tab, Node<V> f) {
        if (tab != null && f instanceof ForwardingNode) {
            Node<K>[] nextTab = ((ForwardingNode)f).nextTable;
            if (((ForwardingNode)f).nextTable != null) {
                int sc;
                int rs = CompactConcurrentHashSet2.resizeStamp(tab.length);
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc >>> RESIZE_STAMP_SHIFT == rs && sc != rs + 1 && sc != rs + MAX_RESIZERS && this.transferIndex > 0) {
                    if (!U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : CompactConcurrentHashSet2.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int n2;
            Node<V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                int n3 = n2 = sc > c ? sc : c;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table) continue;
            int rs = CompactConcurrentHashSet2.resizeStamp(n2);
            if (sc < 0) {
                if (sc >>> RESIZE_STAMP_SHIFT != rs || sc == rs + 1 || sc == rs + MAX_RESIZERS) break;
                Node<V>[] nt = this.nextTable;
                if (this.nextTable == null || this.transferIndex <= 0) break;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                this.transfer(tab, nt);
                continue;
            }
            if (!U.compareAndSwapInt(this, SIZECTL, sc, (rs << RESIZE_STAMP_SHIFT) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(Node<V>[] tab, Node<V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n;
        }
        int nextn = nextTab.length;
        ForwardingNode<V> fwd = new ForwardingNode<V>(nextTab);
        boolean advance = true;
        boolean finishing = false;
        int i = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!U.compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i < 0 || i >= n || i + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) continue;
                if (sc - 2 != CompactConcurrentHashSet2.resizeStamp(n) << RESIZE_STAMP_SHIFT) {
                    return;
                }
                advance = true;
                finishing = true;
                i = n;
                continue;
            }
            TreeBin f = CompactConcurrentHashSet2.tabAt(tab, i);
            if (f == null) {
                advance = CompactConcurrentHashSet2.casTabAt(tab, i, null, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1879048193) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (CompactConcurrentHashSet2.tabAt(tab, i) == f) {
                    Node hn;
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        Node lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            Object pk = p.key;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, ln);
                            } else {
                                hn = new Node(ph, pk, hn);
                            }
                            p = p.next;
                        }
                        CompactConcurrentHashSet2.setTabAt(nextTab, i, ln);
                        CompactConcurrentHashSet2.setTabAt(nextTab, i + n, hn);
                        CompactConcurrentHashSet2.setTabAt(tab, i, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode p = new TreeNode(h, e.key, null, null);
                            if ((h & n) == 0) {
                                p.prev = loTail;
                                if (p.prev == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                p.prev = hiTail;
                                if (p.prev == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? CompactConcurrentHashSet2.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo) : t);
                        hn = hc <= 6 ? CompactConcurrentHashSet2.untreeify(hi) : (lc != 0 ? new TreeBin(hi) : t);
                        CompactConcurrentHashSet2.setTabAt(nextTab, i, ln);
                        CompactConcurrentHashSet2.setTabAt(nextTab, i + n, hn);
                        CompactConcurrentHashSet2.setTabAt(tab, i, fwd);
                        advance = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void treeifyBin(Node<V>[] tab, int index) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node<V> b = CompactConcurrentHashSet2.tabAt(tab, index);
                if (b != null && b.hash >= 0) {
                    Node<V> node = b;
                    synchronized (node) {
                        if (CompactConcurrentHashSet2.tabAt(tab, index) == b) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<Object> e = b;
                            while (e != null) {
                                TreeNode p = new TreeNode(e.hash, e.key, null, null);
                                p.prev = tl;
                                if (p.prev == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            CompactConcurrentHashSet2.setTabAt(tab, index, new TreeBin(hd));
                        }
                    }
                }
            }
        }
    }

    static <K> Node<K> untreeify(Node<K> b) {
        Node hd = null;
        Node tl = null;
        Node<K> q = b;
        while (q != null) {
            Node p = new Node(q.hash, q.key, null);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    long sumCount() {
        CounterCell[] as = this.counterCells;
        long sum = this.baseCount;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                CounterCell a = as[i];
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAddCount(long x, CounterHashCode hc, boolean wasUncontended) {
        int h;
        if (hc == null) {
            hc = new CounterHashCode();
            int s = counterHashCodeGenerator.addAndGet(1640531527);
            hc.code = s == 0 ? 1 : s;
            h = hc.code;
            threadCounterHashCode.set(hc);
        } else {
            h = hc.code;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] as = this.counterCells;
            if (this.counterCells != null && (n = as.length) > 0) {
                CounterCell a = as[n - 1 & h];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            break;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (U.compareAndSwapLong(a, CELLVALUE, v, v + x)) break;
                    if (this.counterCells != as || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == as) {
                                CounterCell[] rs = new CounterCell[n << 1];
                                for (int i = 0; i < n; ++i) {
                                    rs[i] = as[i];
                                }
                                this.counterCells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h ^= h << 13;
                h ^= h >>> 17;
                h ^= h << 5;
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == as && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == as) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                break;
            }
            v = this.baseCount;
            if (U.compareAndSwapLong(this, BASECOUNT, v, v + x)) break;
        }
        hc.code = h;
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            U = (Unsafe)f.get(null);
            Class<CompactConcurrentHashSet2> k = CompactConcurrentHashSet2.class;
            SIZECTL = U.objectFieldOffset(k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = U.objectFieldOffset(k.getDeclaredField("transferIndex"));
            BASECOUNT = U.objectFieldOffset(k.getDeclaredField("baseCount"));
            CELLSBUSY = U.objectFieldOffset(k.getDeclaredField("cellsBusy"));
            Class<CounterCell> ck = CounterCell.class;
            CELLVALUE = U.objectFieldOffset(ck.getDeclaredField("value"));
            Class<Node[]> ak = Node[].class;
            ABASE = U.arrayBaseOffset(ak);
            int scale = U.arrayIndexScale(ak);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        Class<LockSupport> clazz = LockSupport.class;
    }

    static class CounterHashCode {
        int code;

        CounterHashCode() {
        }
    }

    static class CounterCell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;

        CounterCell(long x) {
            this.value = x;
        }
    }

    static class KeyIterator<K>
    extends BaseIterator<K>
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator(Node<K>[] tab, int index, int size, int limit, CompactConcurrentHashSet2<K> map) {
            super(tab, index, size, limit, map);
        }

        @Override
        public K next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object k = p.key;
            this.lastReturned = p;
            this.advance();
            return k;
        }

        @Override
        public K nextElement() {
            return this.next();
        }
    }

    static class BaseIterator<K>
    extends Traverser<K> {
        final CompactConcurrentHashSet2<K> set;
        Node<K> lastReturned;

        BaseIterator(Node<K>[] tab, int size, int index, int limit, CompactConcurrentHashSet2<K> map) {
            super(tab, size, index, limit);
            this.set = map;
            this.advance();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public void remove() {
            Node<K> p = this.lastReturned;
            if (p == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.set.removeNode(p.key);
        }
    }

    static class Traverser<K> {
        Node<K>[] tab;
        Node<K> next;
        TableStack<K> stack;
        TableStack<K> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<K>[] tab, int size, int index, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index;
            this.baseLimit = limit;
            this.next = null;
        }

        Node<K> advance() {
            Node<K> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i;
                int n;
                Node<K>[] t;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i = this.index) && i >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = CompactConcurrentHashSet2.tabAt(t, i);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        this.pushState(t, i, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K>[] t, int i, int n) {
            TableStack<K> s = this.spare;
            if (s != null) {
                this.spare = s.next;
            } else {
                s = new TableStack();
            }
            s.tab = t;
            s.length = n;
            s.index = i;
            s.next = this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<K> s;
            while ((s = this.stack) != null && (this.index += (len = s.length)) >= n) {
                n = len;
                this.index = s.index;
                this.tab = s.tab;
                s.tab = null;
                TableStack next = s.next;
                s.next = this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static class TableStack<K> {
        int length;
        int index;
        Node<K>[] tab;
        TableStack<K> next;

        TableStack() {
        }
    }

    static class TreeBin<K>
    extends Node<K> {
        TreeNode<K> root;
        volatile TreeNode<K> first;
        volatile Thread waiter;
        volatile int lockState;
        static final int WRITER = 1;
        static final int WAITER = 2;
        static final int READER = 4;
        private static final Unsafe U;
        private static final long LOCKSTATE;

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        TreeBin(TreeNode<K> b) {
            super(Integer.MIN_VALUE, null, null);
            this.first = b;
            TreeNode r = null;
            TreeNode x = b;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (r == null) {
                    x.parent = null;
                    x.red = false;
                    r = x;
                } else {
                    TreeNode xp;
                    int dir;
                    Object k = x.key;
                    int h = x.hash;
                    Class<?> kc = null;
                    TreeNode p = r;
                    do {
                        Object pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = CompactConcurrentHashSet2.comparableClassFor(k)) == null || (dir = CompactConcurrentHashSet2.compareComparables(kc, k, pk)) == 0) {
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private void lockRoot() {
            if (!U.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private void unlockRoot() {
            this.lockState = 0;
        }

        private void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s;
                if (((s = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Node<K> find(int h, Object k) {
            if (k != null) {
                Node e = this.first;
                while (e != null) {
                    TreeNode<K> p;
                    int s = this.lockState;
                    if ((s & 3) != 0) {
                        Object ek;
                        if (e.hash == h && ((ek = e.key) == k || ek != null && k.equals(ek))) {
                            return e;
                        }
                        e = e.next;
                        continue;
                    }
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s + 4)) continue;
                    try {
                        TreeNode<K> r = this.root;
                        p = r == null ? null : r.findTreeNode(h, k, null);
                    }
                    finally {
                        Thread w;
                        int ls;
                        while (!U.compareAndSwapInt(this, LOCKSTATE, ls = this.lockState, ls - 4)) {
                        }
                        if (ls == 6 && (w = this.waiter) != null) {
                            LockSupport.unpark(w);
                        }
                    }
                    return p;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TreeNode<K> putTreeVal(int h, K k) {
            block19: {
                TreeNode<K> xp;
                int dir;
                Class<?> kc = null;
                boolean searched = false;
                TreeNode<K> p = this.root;
                do {
                    if (p == null) {
                        this.root = new TreeNode<K>(h, k, null, null);
                        this.first = this.root;
                        break block19;
                    }
                    int ph = p.hash;
                    if (ph > h) {
                        dir = -1;
                    } else if (ph < h) {
                        dir = 1;
                    } else {
                        Object pk = p.key;
                        if (pk == k || pk != null && k.equals(pk)) {
                            return p;
                        }
                        if (kc == null && (kc = CompactConcurrentHashSet2.comparableClassFor(k)) == null || (dir = CompactConcurrentHashSet2.compareComparables(kc, k, pk)) == 0) {
                            if (!searched) {
                                TreeNode q;
                                searched = true;
                                TreeNode ch = p.left;
                                if (ch != null && (q = ch.findTreeNode(h, k, kc)) != null || (ch = p.right) != null && (q = ch.findTreeNode(h, k, kc)) != null) {
                                    return q;
                                }
                            }
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                    }
                    xp = p;
                } while ((p = dir <= 0 ? p.left : p.right) != null);
                TreeNode<K> f = this.first;
                TreeNode<K> x = new TreeNode<K>(h, k, f, xp);
                this.first = x;
                if (f != null) {
                    f.prev = x;
                }
                if (dir <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeTreeNode(TreeNode<K> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<K> r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p.red;
                    p.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p.parent;
                    if (s == pr) {
                        p.parent = s;
                        s.right = p;
                    } else {
                        TreeNode sp = s.parent;
                        p.parent = sp;
                        if (p.parent != null) {
                            if (s == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        if ((s.right = pr) != null) {
                            pr.parent = s;
                        }
                    }
                    p.left = null;
                    p.right = sr;
                    if (p.right != null) {
                        sr.parent = p;
                    }
                    if ((s.left = pl) != null) {
                        pl.parent = s;
                    }
                    if ((s.parent = pp2) == null) {
                        r = s;
                    } else if (p == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = sr != null ? sr : p;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p);
                }
                if (replacement != p) {
                    replacement.parent = p.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.parent = null;
                    p.right = null;
                    p.left = null;
                }
                TreeNode<K> treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static <K> TreeNode<K> rotateLeft(TreeNode<K> root, TreeNode<K> p) {
            TreeNode r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <K> TreeNode<K> rotateRight(TreeNode<K> root, TreeNode<K> p) {
            TreeNode l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static <K> TreeNode<K> balanceInsertion(TreeNode<K> root, TreeNode<K> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeBin.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeBin.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        static <K> TreeNode<K> balanceDeletion(TreeNode<K> root, TreeNode<K> x) {
            while (x != null && x != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <K> boolean checkInvariants(TreeNode<K> t) {
            TreeNode tp = t.parent;
            TreeNode tl = t.left;
            TreeNode tr = t.right;
            TreeNode tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                U = (Unsafe)f.get(null);
                Class<TreeBin> k = TreeBin.class;
                LOCKSTATE = U.objectFieldOffset(k.getDeclaredField("lockState"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    static class TreeNode<K>
    extends Node<K> {
        TreeNode<K> parent;
        TreeNode<K> left;
        TreeNode<K> right;
        TreeNode<K> prev;
        boolean red;

        TreeNode(int hash, K key, Node<K> next, TreeNode<K> parent) {
            super(hash, key, next);
            this.parent = parent;
        }

        @Override
        Node<K> find(int h, Object k) {
            return this.findTreeNode(h, k, null);
        }

        TreeNode<K> findTreeNode(int h, Object k, Class<?> kc) {
            if (k != null) {
                TreeNode<K> p = this;
                do {
                    int dir;
                    TreeNode<K> pl = p.left;
                    TreeNode<K> pr = p.right;
                    int ph = p.hash;
                    if (ph > h) {
                        p = pl;
                        continue;
                    }
                    if (ph < h) {
                        p = pr;
                        continue;
                    }
                    Object pk = p.key;
                    if (pk == k || pk != null && k.equals(pk)) {
                        return p;
                    }
                    if (pl == null) {
                        p = pr;
                        continue;
                    }
                    if (pr == null) {
                        p = pl;
                        continue;
                    }
                    if ((kc != null || (kc = CompactConcurrentHashSet2.comparableClassFor(k)) != null) && (dir = CompactConcurrentHashSet2.compareComparables(kc, k, pk)) != 0) {
                        p = dir < 0 ? pl : pr;
                        continue;
                    }
                    TreeNode<K> q = pr.findTreeNode(h, k, kc);
                    if (q != null) {
                        return q;
                    }
                    p = pl;
                } while (p != null);
            }
            return null;
        }
    }

    static class ReservationNode<K>
    extends Node<K> {
        ReservationNode() {
            super(-2147483647, null, null);
        }

        @Override
        Node<K> find(int h, Object k) {
            return null;
        }
    }

    static class ForwardingNode<K>
    extends Node<K> {
        final Node<K>[] nextTable;

        ForwardingNode(Node<K>[] tab) {
            super(-1879048193, null, null);
            this.nextTable = tab;
        }

        @Override
        Node<K> find(int h, Object k) {
            Node<K> e;
            int n;
            Node<K>[] tab = this.nextTable;
            if (k != null && tab != null && (n = tab.length) > 0 && (e = CompactConcurrentHashSet2.tabAt(tab, n - 1 & h)) != null) {
                do {
                    Object ek;
                    int eh;
                    if ((eh = e.hash) == h && ((ek = e.key) == k || ek != null && k.equals(ek))) {
                        return e;
                    }
                    if (eh >= 0) continue;
                    return e.find(h, k);
                } while ((e = e.next) != null);
            }
            return null;
        }
    }

    static class Segment<K>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment(float lf) {
            this.loadFactor = lf;
        }
    }

    static class Node<K> {
        final int hash;
        final K key;
        Node<K> next;

        Node(int hash, K key, Node<K> next) {
            this.hash = hash;
            this.key = key;
            this.next = next;
        }

        public K getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            Node e;
            if (!(o instanceof Node)) return false;
            Node k = e = (Node)o;
            if (e == null) return false;
            if (k == this.key) return true;
            if (!((Object)k).equals(this.key)) return false;
            return true;
        }

        Node<K> find(int h, Object k) {
            Node<K> e = this;
            if (k != null) {
                do {
                    K ek;
                    if (e.hash != h || (ek = e.key) != k && (ek == null || !k.equals(ek))) continue;
                    return e;
                } while ((e = e.next) != null);
            }
            return null;
        }
    }
}

