/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Map;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.pdx.internal.EnumInfo;

public class GetPdxEnums70
extends BaseCommand {
    private static final GetPdxEnums70 singleton = new GetPdxEnums70();

    public static Command getCommand() {
        return singleton;
    }

    private GetPdxEnums70() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException {
        Map<Integer, EnumInfo> enums;
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx enums from {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString());
        }
        try {
            InternalCache cache = serverConnection.getCache();
            enums = cache.getPdxRegistry().enumMap();
        }
        catch (Exception e) {
            GetPdxEnums70.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Message responseMsg = serverConnection.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(clientMessage.getTransactionId());
        responseMsg.addObjPart(enums);
        responseMsg.send(serverConnection);
        serverConnection.setAsTrue(1);
    }
}

